/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1703;
import net.minecraft.class_1728;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2371;
import net.minecraft.class_3218;
import net.minecraft.class_3988;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.mixin.rule.MerchantScreenHandlerAccessor;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.periodic.fakeplayer.action.context.TradeContext;
import org.carpetorgaddition.util.InventoryUtils;

public class FakePlayerTrade {
    public static final int TRADE_WAIT_TIME = 1;

    public static void trade(TradeContext context, EntityPlayerMPFake fakePlayer) {
        int index = context.getIndex();
        class_1703 class_17032 = fakePlayer.field_7512;
        if (class_17032 instanceof class_1728) {
            class_1728 merchantScreenHandler = (class_1728)class_17032;
            boolean voidTrade = context.isVoidTrade();
            MutableInt timer = context.getTimer();
            if (voidTrade) {
                class_3988 merchantEntity;
                MerchantScreenHandlerAccessor accessor = (MerchantScreenHandlerAccessor)merchantScreenHandler;
                class_1915 merchant = accessor.getMerchant();
                if (merchant instanceof class_3988 && FakePlayerTrade.shouldWait(merchantEntity = (class_3988)merchant)) {
                    timer.setValue(1);
                    return;
                }
                if (timer.getValue() != 0) {
                    timer.decrement();
                    return;
                }
                timer.setValue(1);
            }
            class_2168 source = fakePlayer.method_5671();
            if (merchantScreenHandler.method_17438().size() <= index) {
                FakePlayerUtils.stopAction(source, fakePlayer, "carpet.commands.playerAction.trade", new Object[0]);
                return;
            }
            FakePlayerTrade.tryTrade(source, fakePlayer, merchantScreenHandler, index, voidTrade);
            if (voidTrade) {
                fakePlayer.method_7346();
            }
        }
    }

    private static void tryTrade(class_2168 source, EntityPlayerMPFake fakePlayer, class_1728 merchantScreenHandler, int index, boolean voidTrade) {
        int loopCount = 0;
        do {
            if (++loopCount > 1000) {
                throw new InfiniteLoopException();
            }
            class_1914 tradeOffer = (class_1914)merchantScreenHandler.method_17438().get(index);
            if (tradeOffer.method_8255()) {
                return;
            }
            merchantScreenHandler.method_7650(index);
            if (FakePlayerTrade.switchItem(fakePlayer, merchantScreenHandler, tradeOffer)) {
                class_1735 outputSlot = merchantScreenHandler.method_7611(2);
                if (outputSlot.method_7681()) {
                    FakePlayerUtils.compareAndThrow((class_1703)merchantScreenHandler, 2, tradeOffer.method_8250(), fakePlayer);
                    if (!CarpetOrgAdditionSettings.villagerInfiniteTrade || CarpetOrgAdditionSettings.fakePlayerMaxCraftCount <= 0 || loopCount < CarpetOrgAdditionSettings.fakePlayerMaxCraftCount) continue;
                    return;
                }
                FakePlayerUtils.stopAction(source, fakePlayer, "carpet.commands.playerAction.trade", new Object[0]);
                return;
            }
            return;
        } while (voidTrade || CarpetOrgAdditionSettings.villagerInfiniteTrade);
    }

    private static boolean switchItem(EntityPlayerMPFake fakePlayer, class_1728 merchantScreenHandler, class_1914 tradeOffer) {
        class_1799 firstBuyItem = tradeOffer.method_19272();
        class_1799 secondBuyItem = tradeOffer.method_8247();
        return FakePlayerTrade.fillTradeSlot(fakePlayer, merchantScreenHandler, firstBuyItem, 0) && FakePlayerTrade.fillTradeSlot(fakePlayer, merchantScreenHandler, secondBuyItem, 1);
    }

    private static boolean fillTradeSlot(EntityPlayerMPFake fakePlayer, class_1728 merchantScreenHandler, class_1799 buyItem, int slotIndex) {
        int index;
        class_2371 list = merchantScreenHandler.field_7761;
        class_1735 tradeSlot = merchantScreenHandler.method_7611(slotIndex);
        if (!tradeSlot.method_7677().method_31574(buyItem.method_7909())) {
            FakePlayerUtils.throwItem((class_1703)merchantScreenHandler, slotIndex, fakePlayer);
        }
        if (buyItem.method_7960() || FakePlayerTrade.slotItemCanTrade(tradeSlot.method_7677(), buyItem)) {
            return true;
        }
        for (index = 3; index < list.size(); ++index) {
            class_1799 itemStack = ((class_1735)list.get(index)).method_7677();
            Predicate<class_1799> predicate = FakePlayerTrade.getStackPredicate(buyItem, tradeSlot.method_7677());
            if (!predicate.test(itemStack) || !FakePlayerUtils.withKeepPickupAndMoveItemStack((class_1703)merchantScreenHandler, index, slotIndex, fakePlayer)) continue;
            if (!merchantScreenHandler.method_34255().method_7960()) {
                FakePlayerUtils.pickupCursorStack((class_1703)merchantScreenHandler, index, fakePlayer);
            }
            if (!FakePlayerTrade.slotItemCanTrade(tradeSlot.method_7677(), buyItem)) continue;
            return true;
        }
        if (CarpetOrgAdditionSettings.fakePlayerCraftPickItemFromShulkerBox) {
            for (index = 3; index < list.size(); ++index) {
                class_1799 contentItemStack;
                int difference = tradeSlot.method_7677().method_7914() - tradeSlot.method_7677().method_7947();
                class_1799 itemStack = ((class_1735)list.get(index)).method_7677();
                Predicate<class_1799> predicate = FakePlayerTrade.getStackPredicate(buyItem, tradeSlot.method_7677());
                if (!InventoryUtils.isShulkerBoxItem(itemStack) || (contentItemStack = InventoryUtils.pickItemFromShulkerBox(itemStack, predicate, difference)).method_7960()) continue;
                FakePlayerUtils.dropCursorStack((class_1703)merchantScreenHandler, fakePlayer);
                merchantScreenHandler.method_34254(contentItemStack);
                FakePlayerUtils.pickupCursorStack((class_1703)merchantScreenHandler, slotIndex, fakePlayer);
                if (!FakePlayerTrade.slotItemCanTrade(tradeSlot.method_7677(), buyItem)) continue;
                return true;
            }
        }
        return false;
    }

    private static Predicate<class_1799> getStackPredicate(class_1799 buyItem, class_1799 slotItem) {
        Predicate<class_1799> predicate = slotItem.method_7960() ? stack -> buyItem.method_31574(stack.method_7909()) : stack -> class_1799.method_31577((class_1799)slotItem, (class_1799)stack);
        return predicate;
    }

    private static boolean shouldWait(class_3988 merchant) {
        class_1923 chunkPos = merchant.method_31476();
        if (merchant.method_37908().method_8393(chunkPos.field_9181, chunkPos.field_9180)) {
            UUID uuid = merchant.method_5667();
            MinecraftServer server = merchant.method_5682();
            if (server == null) {
                return true;
            }
            for (class_3218 world : server.method_3738()) {
                if (world.method_14190(uuid) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean slotItemCanTrade(class_1799 slotItem, class_1799 tradeItem) {
        return slotItem.method_7947() >= tradeItem.method_7947() || slotItem.method_7947() >= slotItem.method_7914();
    }
}

