/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action.context;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.carpetorgaddition.periodic.fakeplayer.action.context.AbstractActionContext;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.wheel.ItemStackPredicate;
import org.carpetorgaddition.util.wheel.TextBuilder;

public class CraftingTableCraftContext
extends AbstractActionContext {
    private final ItemStackPredicate[] predicates = new ItemStackPredicate[9];

    public CraftingTableCraftContext(ItemStackPredicate[] predicates) {
        System.arraycopy(predicates, 0, this.predicates, 0, this.predicates.length);
    }

    public static CraftingTableCraftContext load(JsonObject json) {
        ItemStackPredicate[] predicates = new ItemStackPredicate[9];
        for (int i = 0; i < predicates.length; ++i) {
            String item = json.get(String.valueOf(i)).getAsString();
            predicates[i] = ItemStackPredicate.load(item);
        }
        return new CraftingTableCraftContext(predicates);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (int i = 0; i < this.predicates.length; ++i) {
            json.addProperty(String.valueOf(i), this.predicates[i].toString());
        }
        return json;
    }

    @Override
    public ArrayList<class_5250> info(EntityPlayerMPFake fakePlayer) {
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        class_1799 craftOutput = ItemStackPredicate.getCraftOutput(this.predicates, 3, fakePlayer);
        class_2561 itemText = craftOutput.method_7960() ? TextUtils.translate("carpet.command.item.item", new Object[0]) : craftOutput.method_7909().method_7848();
        list.add(TextUtils.translate("carpet.commands.playerAction.info.craft.result", fakePlayer.method_5476(), itemText));
        this.addCraftRecipe(list, craftOutput);
        class_1703 class_17032 = fakePlayer.field_7512;
        if (class_17032 instanceof class_1714) {
            class_1714 currentScreenHandler = (class_1714)class_17032;
            list.add(TextUtils.translate("carpet.commands.playerAction.info.craft.state", fakePlayer.method_5476()));
            this.addCraftGridState(currentScreenHandler, list);
        } else {
            list.add(TextUtils.translate("carpet.commands.playerAction.info.craft.no_crafting_table", fakePlayer.method_5476(), class_1802.field_8465.method_7848()));
        }
        return list;
    }

    private void addCraftRecipe(ArrayList<class_5250> list, class_1799 craftOutput) {
        list.add(new TextBuilder().indentation().append(this.predicates[0].getInitialUpperCase()).blank().append(this.predicates[1].getInitialUpperCase()).blank().append(this.predicates[2].getInitialUpperCase()).toLine());
        TextBuilder builder = new TextBuilder().indentation().append(this.predicates[3].getInitialUpperCase()).blank().append(this.predicates[4].getInitialUpperCase()).blank().append(this.predicates[5].getInitialUpperCase());
        if (!craftOutput.method_7960()) {
            builder.appendString(" -> ").append((class_2561)AbstractActionContext.getWithCountHoverText(craftOutput));
        }
        list.add(builder.toLine());
        list.add(new TextBuilder().indentation().append(this.predicates[6].getInitialUpperCase()).blank().append(this.predicates[7].getInitialUpperCase()).blank().append(this.predicates[8].getInitialUpperCase()).toLine());
    }

    private void addCraftGridState(class_1714 currentScreenHandler, ArrayList<class_5250> list) {
        list.add(TextUtils.appendAll("    ", CraftingTableCraftContext.getWithCountHoverText(currentScreenHandler.method_7611(1).method_7677()), " ", CraftingTableCraftContext.getWithCountHoverText(currentScreenHandler.method_7611(2).method_7677()), " ", CraftingTableCraftContext.getWithCountHoverText(currentScreenHandler.method_7611(3).method_7677())));
        list.add(TextUtils.appendAll("    ", CraftingTableCraftContext.getWithCountHoverText(currentScreenHandler.method_7611(4).method_7677()), " ", CraftingTableCraftContext.getWithCountHoverText(currentScreenHandler.method_7611(5).method_7677()), " ", CraftingTableCraftContext.getWithCountHoverText(currentScreenHandler.method_7611(6).method_7677()), " -> ", CraftingTableCraftContext.getWithCountHoverText(currentScreenHandler.method_7611(0).method_7677())));
        list.add(TextUtils.appendAll("    ", CraftingTableCraftContext.getWithCountHoverText(currentScreenHandler.method_7611(7).method_7677()), " ", CraftingTableCraftContext.getWithCountHoverText(currentScreenHandler.method_7611(8).method_7677()), " ", CraftingTableCraftContext.getWithCountHoverText(currentScreenHandler.method_7611(9).method_7677())));
    }

    public ItemStackPredicate[] getPredicates() {
        return this.predicates;
    }
}

