/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action.context;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerActionManager;
import org.carpetorgaddition.periodic.fakeplayer.action.context.AbstractActionContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.BreakBedrockContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.CleanContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.CraftingTableCraftContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.FarmContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.FillContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.FishingContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.InventoryCraftContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.RenameContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.SortingContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.StonecuttingContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.StopContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.TradeContext;
import org.carpetorgaddition.util.GenericFetcherUtils;
import org.carpetorgaddition.util.wheel.TextBuilder;

public class FakePlayerActionSerial {
    private final FakePlayerAction action;
    private final AbstractActionContext context;
    public static final FakePlayerActionSerial NO_ACTION = new FakePlayerActionSerial();

    private FakePlayerActionSerial() {
        this.action = FakePlayerAction.STOP;
        this.context = StopContext.STOP;
    }

    public FakePlayerActionSerial(EntityPlayerMPFake fakePlayer) {
        FakePlayerActionManager actionManager = GenericFetcherUtils.getFakePlayerActionManager(fakePlayer);
        this.action = actionManager.getAction();
        this.context = actionManager.getActionContext();
    }

    public FakePlayerActionSerial(JsonObject json) {
        for (FakePlayerAction value : FakePlayerAction.values()) {
            String serializedName = value.getSerializedName();
            if (!json.has(serializedName)) continue;
            if (value.isHidden()) {
                this.action = FakePlayerAction.STOP;
                this.context = StopContext.STOP;
            } else {
                this.action = value;
                JsonObject jsonObject = json.get(serializedName).getAsJsonObject();
                this.context = switch (value) {
                    default -> throw new MatchException(null, null);
                    case FakePlayerAction.STOP -> StopContext.STOP;
                    case FakePlayerAction.SORTING -> SortingContext.load(jsonObject);
                    case FakePlayerAction.CLEAN -> CleanContext.load(jsonObject);
                    case FakePlayerAction.FILL -> FillContext.load(jsonObject);
                    case FakePlayerAction.CRAFTING_TABLE_CRAFT -> CraftingTableCraftContext.load(jsonObject);
                    case FakePlayerAction.INVENTORY_CRAFTING -> InventoryCraftContext.load(jsonObject);
                    case FakePlayerAction.RENAME -> RenameContext.load(jsonObject);
                    case FakePlayerAction.STONECUTTING -> StonecuttingContext.load(jsonObject);
                    case FakePlayerAction.TRADE -> TradeContext.load(jsonObject);
                    case FakePlayerAction.FISHING -> new FishingContext();
                    case FakePlayerAction.FARM -> new FarmContext();
                    case FakePlayerAction.BEDROCK -> new BreakBedrockContext(jsonObject);
                };
            }
            return;
        }
        CarpetOrgAddition.LOGGER.warn("\u4ecejson\u4e2d\u53cd\u5e8f\u5217\u5316\u73a9\u5bb6\u52a8\u4f5c\u5931\u8d25");
        this.action = FakePlayerAction.STOP;
        this.context = StopContext.STOP;
    }

    public void startAction(EntityPlayerMPFake fakePlayer) {
        if (this == NO_ACTION) {
            return;
        }
        FakePlayerActionManager actionManager = GenericFetcherUtils.getFakePlayerActionManager(fakePlayer);
        actionManager.setAction(this.action, this.context);
    }

    public boolean hasAction() {
        return this != NO_ACTION && this.action != FakePlayerAction.STOP;
    }

    public class_2561 toText() {
        TextBuilder builder = new TextBuilder();
        builder.appendTranslate("carpet.commands.playerManager.info.action", new Object[0]).newLine().indentation().append((class_2561)this.action.getDisplayName());
        return builder.toLine();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.action.isHidden()) {
            json.add(FakePlayerAction.STOP.getSerializedName(), (JsonElement)StopContext.STOP.toJson());
        } else {
            String action = this.action.getSerializedName();
            json.add(action, (JsonElement)this.context.toJson());
        }
        return json;
    }
}

