/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action.context;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.carpetorgaddition.periodic.fakeplayer.action.context.AbstractActionContext;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.wheel.ItemStackPredicate;
import org.carpetorgaddition.util.wheel.TextBuilder;

public class InventoryCraftContext
extends AbstractActionContext {
    private final ItemStackPredicate[] predicates = new ItemStackPredicate[4];

    public InventoryCraftContext(ItemStackPredicate[] predicates) {
        System.arraycopy(predicates, 0, this.predicates, 0, this.predicates.length);
    }

    public static InventoryCraftContext load(JsonObject json) {
        ItemStackPredicate[] itemStackPredicates = new ItemStackPredicate[4];
        for (int i = 0; i < itemStackPredicates.length; ++i) {
            String item = json.get(String.valueOf(i)).getAsString();
            itemStackPredicates[i] = ItemStackPredicate.load(item);
        }
        return new InventoryCraftContext(itemStackPredicates);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (int i = 0; i < this.predicates.length; ++i) {
            json.addProperty(String.valueOf(i), this.predicates[i].toString());
        }
        return json;
    }

    @Override
    public ArrayList<class_5250> info(EntityPlayerMPFake fakePlayer) {
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        class_2561 playerName = fakePlayer.method_5476();
        class_1799 craftOutput = ItemStackPredicate.getCraftOutput(this.predicates, 2, fakePlayer);
        class_2561 itemText = craftOutput.method_7960() ? TextUtils.translate("carpet.command.item.item", new Object[0]) : craftOutput.method_7909().method_7848();
        list.add(TextUtils.translate("carpet.commands.playerAction.info.craft.result", playerName, itemText));
        this.addCraftRecipe(list, craftOutput);
        list.add(TextUtils.translate("carpet.commands.playerAction.info.craft.state", playerName));
        class_1723 playerScreenHandler = fakePlayer.field_7498;
        this.addCraftGridState(list, playerScreenHandler);
        return list;
    }

    private void addCraftRecipe(ArrayList<class_5250> list, class_1799 craftOutput) {
        list.add(new TextBuilder().indentation().append(this.predicates[0].getInitialUpperCase()).blank().append(this.predicates[1].getInitialUpperCase()).toLine());
        TextBuilder builder = new TextBuilder().indentation().append(this.predicates[2].getInitialUpperCase()).blank().append(this.predicates[3].getInitialUpperCase());
        if (!craftOutput.method_7960()) {
            builder.appendString(" -> ").append((class_2561)AbstractActionContext.getWithCountHoverText(craftOutput));
        }
        list.add(builder.toLine());
    }

    private void addCraftGridState(ArrayList<class_5250> list, class_1723 playerScreenHandler) {
        list.add(TextUtils.appendAll("    ", InventoryCraftContext.getWithCountHoverText(playerScreenHandler.method_7611(1).method_7677()), " ", InventoryCraftContext.getWithCountHoverText(playerScreenHandler.method_7611(2).method_7677())));
        list.add(TextUtils.appendAll("    ", InventoryCraftContext.getWithCountHoverText(playerScreenHandler.method_7611(3).method_7677()), " ", InventoryCraftContext.getWithCountHoverText(playerScreenHandler.method_7611(4).method_7677()), " -> ", InventoryCraftContext.getWithCountHoverText(playerScreenHandler.method_7611(0).method_7677())));
    }

    public ItemStackPredicate[] getPredicates() {
        return this.predicates;
    }
}

