/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action.context;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.class_1703;
import net.minecraft.class_1728;
import net.minecraft.class_1914;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableInt;
import org.carpetorgaddition.periodic.fakeplayer.action.context.AbstractActionContext;
import org.carpetorgaddition.util.TextUtils;

public class TradeContext
extends AbstractActionContext {
    private static final String INDEX = "index";
    private static final String VOID_TRADE = "void_trade";
    private final int index;
    private final boolean voidTrade;
    private final MutableInt timer = new MutableInt();

    public TradeContext(int index, boolean voidTrade) {
        this.index = index;
        this.voidTrade = voidTrade;
        this.timer.setValue(1);
    }

    public static TradeContext load(JsonObject json) {
        int index = json.get(INDEX).getAsInt();
        boolean voidTrade = json.get(VOID_TRADE).getAsBoolean();
        return new TradeContext(index, voidTrade);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty(INDEX, (Number)this.index);
        json.addProperty(VOID_TRADE, Boolean.valueOf(this.voidTrade));
        return json;
    }

    @Override
    public ArrayList<class_5250> info(EntityPlayerMPFake fakePlayer) {
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        list.add(TextUtils.translate("carpet.commands.playerAction.info.trade.item", fakePlayer.method_5476(), this.index + 1));
        class_1703 class_17032 = fakePlayer.field_7512;
        if (class_17032 instanceof class_1728) {
            class_1728 merchantScreenHandler = (class_1728)class_17032;
            class_1914 tradeOffer = (class_1914)merchantScreenHandler.method_17438().get(this.index);
            list.add(TextUtils.appendAll("    ", TradeContext.getWithCountHoverText(tradeOffer.method_19272()), " ", TradeContext.getWithCountHoverText(tradeOffer.method_8247()), " -> ", TradeContext.getWithCountHoverText(tradeOffer.method_8250())));
            if (tradeOffer.method_8255()) {
                list.add(TextUtils.translate("carpet.commands.playerAction.info.trade.disabled", new Object[0]));
                return list;
            }
            list.add(TextUtils.translate("carpet.commands.playerAction.info.trade.state", new Object[0]));
            list.add(TextUtils.appendAll("    ", TradeContext.getWithCountHoverText(merchantScreenHandler.method_7611(0).method_7677()), " ", TradeContext.getWithCountHoverText(merchantScreenHandler.method_7611(1).method_7677()), " -> ", TradeContext.getWithCountHoverText(merchantScreenHandler.method_7611(2).method_7677())));
        } else {
            list.add(TextUtils.translate("carpet.commands.playerAction.info.trade.no_villager", fakePlayer.method_5476()));
        }
        return list;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isVoidTrade() {
        return this.voidTrade;
    }

    public MutableInt getTimer() {
        return this.timer;
    }
}

