/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.navigator;

import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.carpetorgaddition.network.s2c.WaypointUpdateS2CPacket;
import org.carpetorgaddition.periodic.navigator.AbstractNavigator;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.util.constant.TextConstants;
import org.carpetorgaddition.util.wheel.Waypoint;
import org.jetbrains.annotations.NotNull;

public class WaypointNavigator
extends AbstractNavigator {
    private final Waypoint waypoint;
    private final String waypointDimension;

    public WaypointNavigator(@NotNull class_3222 player, Waypoint waypoint) {
        super(player);
        this.waypoint = waypoint;
        if (this.waypoint.getBlockPos() == null) {
            throw new NullPointerException();
        }
        this.waypointDimension = waypoint.getDimension();
    }

    @Override
    public void tick() {
        if (this.terminate()) {
            this.clear();
            return;
        }
        class_2338 blockPos = this.waypoint.getBlockPos();
        class_2338 playerBlockPos = this.player.method_24515();
        String playerDimension = WorldUtils.getDimensionId(this.player.method_37908());
        if (playerDimension.equals(this.waypointDimension)) {
            class_5250 text = this.getHUDText(blockPos.method_46558(), (class_2561)this.getIn(blockPos), (class_2561)WaypointNavigator.getDistance(playerBlockPos, blockPos));
            MessageUtils.sendMessageToHud((class_1657)this.player, (class_2561)text);
            this.syncWaypoint(new WaypointUpdateS2CPacket(blockPos.method_46558(), this.waypointDimension));
        } else {
            class_2338 anotherBlockPos = this.waypoint.getAnotherBlockPos();
            if ((playerDimension.equals("minecraft:overworld") && this.waypointDimension.equals("minecraft:the_nether") || playerDimension.equals("minecraft:the_nether") && this.waypointDimension.equals("minecraft:overworld")) && anotherBlockPos != null) {
                class_5250 in = TextUtils.translate("carpet.commands.navigate.hud.in", this.waypoint.getName(), TextUtils.toItalic(TextConstants.simpleBlockPos(blockPos)));
                class_5250 text = this.getHUDText(anotherBlockPos.method_46558(), (class_2561)in, (class_2561)WaypointNavigator.getDistance(playerBlockPos, anotherBlockPos));
                MessageUtils.sendMessageToHud((class_1657)this.player, (class_2561)text);
                this.syncWaypoint(new WaypointUpdateS2CPacket(anotherBlockPos.method_46558(), playerDimension));
            } else {
                class_2561 dimensionName = WorldUtils.getDimensionName((class_1937)WorldUtils.getWorld(this.player.method_5682(), this.waypoint.getDimension()));
                class_5250 in = TextUtils.translate("carpet.commands.navigate.hud.in", this.waypoint.getName(), TextUtils.appendAll(dimensionName, TextConstants.simpleBlockPos(blockPos)));
                MessageUtils.sendMessageToHud((class_1657)this.player, (class_2561)in);
            }
        }
    }

    @Override
    public boolean terminate() {
        if (Objects.equals(WorldUtils.getDimensionId(this.player.method_37908()), this.waypointDimension) && MathUtils.getBlockIntegerDistance(this.player.method_24515(), this.waypoint.getBlockPos()) <= 8) {
            MessageUtils.sendMessageToHud((class_1657)this.player, (class_2561)TextUtils.translate("carpet.commands.navigate.hud.reach", new Object[0]));
            this.clear();
            return true;
        }
        return false;
    }

    @Override
    public WaypointNavigator copy(class_3222 player) {
        if (this.waypoint == null || this.waypoint.getBlockPos() == null) {
            return null;
        }
        return new WaypointNavigator(player, this.waypoint);
    }

    @NotNull
    private class_5250 getIn(class_2338 blockPos) {
        return TextUtils.translate("carpet.commands.navigate.hud.in", this.waypoint.getName(), TextConstants.simpleBlockPos(blockPos));
    }

    @NotNull
    private static class_5250 getDistance(class_2338 playerBlockPos, class_2338 blockPos) {
        return TextUtils.translate("carpet.commands.navigate.hud.distance", MathUtils.getBlockIntegerDistance(playerBlockPos, blockPos));
    }
}

