/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.findtask;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_5250;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.FinderCommand;
import org.carpetorgaddition.periodic.task.ServerTask;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.inventory.SimulatePlayerInventory;
import org.carpetorgaddition.util.wheel.ItemStackPredicate;
import org.carpetorgaddition.util.wheel.ItemStackStatistics;

public class OfflinePlayerFindTask
extends ServerTask {
    private final AtomicInteger threadCount = new AtomicInteger();
    private final AtomicInteger itemCount = new AtomicInteger();
    private final AtomicBoolean shulkerBox = new AtomicBoolean(false);
    private final CommandContext<class_2168> context;
    private final class_3312 userCache;
    protected final class_3222 player;
    private final File[] files;
    private final ItemStackPredicate predicate;
    private State taksState = State.START;
    private final ReentrantLock lock = new ReentrantLock();
    private final ArrayList<Result> list = new ArrayList();

    public OfflinePlayerFindTask(CommandContext<class_2168> context, class_3312 userCache, class_3222 player, File[] files) {
        this.context = context;
        this.predicate = new ItemStackPredicate(context, "itemStack");
        this.userCache = userCache;
        this.player = player;
        this.files = files;
    }

    @Override
    protected void tick() {
        switch (this.taksState.ordinal()) {
            case 0: {
                for (File file : this.files) {
                    if (!file.getName().endsWith(".dat")) continue;
                    this.createVirtualThread(file);
                }
                this.taksState = State.RUNTIME;
                break;
            }
            case 1: {
                if (this.threadCount.get() != 0) break;
                this.taksState = State.FEEDBACK;
                break;
            }
            case 2: {
                this.sendFeedback();
                this.taksState = State.STOP;
                break;
            }
        }
    }

    private void createVirtualThread(File file) {
        this.threadCount.getAndIncrement();
        Thread.ofVirtual().start(() -> {
            try {
                this.findItem(file);
            }
            finally {
                this.threadCount.getAndDecrement();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findItem(File file) {
        Optional optional;
        String uuid = file.getName().split("\\.")[0];
        try {
            optional = this.userCache.method_14512(UUID.fromString(uuid));
        }
        catch (IllegalArgumentException e) {
            CarpetOrgAddition.LOGGER.warn("\u65e0\u6cd5\u6839\u636e\u6587\u4ef6\u540d{}\u89e3\u6790UUID", (Object)file.getName(), (Object)e);
            return;
        }
        if (optional.isPresent()) {
            class_2487 nbt;
            GameProfile gameProfile = (GameProfile)optional.get();
            if (this.player.field_13995.method_3760().method_14566(gameProfile.getName()) != null) {
                return;
            }
            try {
                nbt = class_2507.method_30613((Path)file.toPath(), (class_2505)class_2505.method_53898());
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.warn("\u65e0\u6cd5\u4ece\u6587\u4ef6\u8bfb\u53d6\u73a9\u5bb6\u6570\u636e\uff1a", (Throwable)e);
                return;
            }
            class_1263 inventory = this.getInventory(nbt);
            ItemStackStatistics statistics = new ItemStackStatistics(this.predicate);
            statistics.statistics(inventory);
            if (statistics.getSum() == 0) {
                return;
            }
            this.itemCount.addAndGet(statistics.getSum());
            if (statistics.hasNestingItem()) {
                this.shulkerBox.set(true);
            }
            Result result = new Result(gameProfile, statistics);
            try {
                this.lock.lock();
                this.list.add(result);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected class_1263 getInventory(class_2487 nbt) {
        return SimulatePlayerInventory.of(nbt, this.player.method_5682());
    }

    private void sendFeedback() {
        class_5250 count;
        if (this.list.isEmpty()) {
            MessageUtils.sendMessage(this.context, "carpet.commands.finder.item.offline_player.not_found", this.getInventoryName(), this.predicate.toText());
            return;
        }
        this.list.sort((o1, o2) -> o2.statistics().getSum() - o1.statistics().getSum());
        class_5250 hoverPrompt = TextUtils.translate("carpet.commands.finder.item.offline_player.prompt", this.getInventoryName());
        if (this.predicate.canConvertItem()) {
            count = FinderCommand.showCount(this.predicate.asItem().method_7854(), this.itemCount.get(), this.shulkerBox.get());
        } else {
            class_5250 text = TextUtils.createText(Integer.toString(this.itemCount.get()));
            if (this.shulkerBox.get()) {
                text = TextUtils.toItalic(text);
            }
            count = text;
        }
        class_5250 message = this.list.size() > CarpetOrgAdditionSettings.finderCommandMaxFeedbackCount ? TextUtils.translate("carpet.commands.finder.item.offline_player.limit", this.list.size(), this.getInventoryName(), count, this.predicate.toText(), CarpetOrgAdditionSettings.finderCommandMaxFeedbackCount) : TextUtils.translate("carpet.commands.finder.item.offline_player", this.list.size(), this.getInventoryName(), count, this.predicate.toText());
        MessageUtils.sendMessage((class_2168)this.context.getSource(), (class_2561)TextUtils.hoverText((class_2561)message, (class_2561)hoverPrompt));
        for (int i = 0; i < Math.min(this.list.size(), CarpetOrgAdditionSettings.finderCommandMaxFeedbackCount); ++i) {
            Result result = this.list.get(i);
            this.sendEveryFeedback(result);
        }
    }

    private void sendEveryFeedback(Result result) {
        class_5250 playerName = TextUtils.createText(result.gameProfile.getName());
        playerName = TextUtils.hoverText((class_2561)playerName, (class_2561)TextUtils.createText("UUID:" + result.gameProfile.getId().toString()));
        playerName = TextUtils.setColor(playerName, class_124.field_1080);
        class_2561 count = result.statistics().getCountText();
        MessageUtils.sendMessage(this.context, "carpet.commands.finder.item.offline_player.each", playerName, this.getInventoryName(), count);
    }

    protected class_2561 getInventoryName() {
        return TextUtils.translate("container.inventory", new Object[0]);
    }

    @Override
    protected boolean stopped() {
        return this.taksState == State.STOP;
    }

    @Override
    public String getLogName() {
        return "\u4ece\u79bb\u7ebf\u73a9\u5bb6\u7269\u54c1\u680f\u5bfb\u627e\u7269\u54c1";
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            return Objects.equals(this.player, ((OfflinePlayerFindTask)o).player);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.player);
    }

    private static enum State {
        START,
        RUNTIME,
        FEEDBACK,
        STOP;

    }

    private record Result(GameProfile gameProfile, ItemStackStatistics statistics) {
    }
}

