/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.translate;

import carpet.CarpetSettings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.carpetorgaddition.exception.UnableToTranslateException;
import org.jetbrains.annotations.Nullable;

public class Translate {
    private static final HashMap<String, Map<String, String>> TRANSLATE = new HashMap();

    public static Map<String, String> getTranslate() {
        String translateJson;
        if (TRANSLATE.containsKey(CarpetSettings.language)) {
            return TRANSLATE.get(CarpetSettings.language);
        }
        ClassLoader classLoader = Translate.class.getClassLoader();
        try {
            String path = "assets/carpet-org-addition/lang/%s.json".formatted(CarpetSettings.language);
            InputStream resourceAsStream = classLoader.getResourceAsStream(path);
            if (resourceAsStream == null) {
                if (TRANSLATE.containsKey("en_us")) {
                    Map<String, String> enUs = TRANSLATE.get("en_us");
                    TRANSLATE.put(CarpetSettings.language, enUs);
                    return enUs;
                }
                resourceAsStream = classLoader.getResourceAsStream("assets/carpet-org-addition/lang/en_us.json");
            }
            translateJson = IOUtils.toString((InputStream)Objects.requireNonNull(resourceAsStream), (Charset)StandardCharsets.UTF_8);
            resourceAsStream.close();
        }
        catch (IOException | NullPointerException e) {
            throw new UnableToTranslateException("\u672a\u80fd\u6210\u529f\u8bfb\u53d6\u7ffb\u8bd1\u6587\u4ef6", e);
        }
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
        Map translate = (Map)gson.fromJson(translateJson, new TypeToken<Map<String, String>>(){}.getType());
        TRANSLATE.put(CarpetSettings.language, translate);
        return translate;
    }

    @Nullable
    public static String getTranslateValue(String key) {
        Map<String, String> translate = Translate.getTranslate();
        return translate.get(key);
    }
}

