/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class IOUtils {
    public static final String JSON_EXTENSION = ".json";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private IOUtils() {
    }

    public static BufferedReader toReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));
    }

    public static BufferedWriter toWriter(File file) throws IOException {
        return new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8));
    }

    public static void saveJson(File file, JsonObject json) throws IOException {
        String jsonString = GSON.toJson((Object)json, JsonObject.class);
        try (BufferedWriter writer = IOUtils.toWriter(file);){
            writer.write(jsonString);
        }
    }

    public static JsonObject loadJson(File file) throws IOException {
        BufferedReader reader;
        try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            return jsonObject;
        }
    }

    public static boolean createFileIfNotExists(File file) {
        if (file.isFile()) {
            return true;
        }
        File parent = file.getParentFile();
        if (parent.isDirectory() || parent.mkdirs()) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean jsonHasElement(JsonObject json, String ... elements) {
        for (String element : elements) {
            if (json.has(element)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static <T> T getJsonElement(JsonObject json, String key, T defaultValue, Class<T> type) {
        JsonElement element = json.get(key);
        if (element == null) {
            return defaultValue;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return type.cast(element.getAsBoolean());
        }
        if (Number.class.isAssignableFrom(type)) {
            return type.cast(element.getAsNumber());
        }
        if (type == String.class) {
            return type.cast(element.getAsString());
        }
        if (JsonObject.class.isAssignableFrom(type)) {
            return type.cast(element.getAsJsonObject());
        }
        if (JsonArray.class.isAssignableFrom(type)) {
            return type.cast(element.getAsJsonArray());
        }
        throw new IllegalArgumentException();
    }

    public static String removeExtension(String fileName) {
        if (fileName.endsWith(JSON_EXTENSION)) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }
}

