/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2480;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.carpetorgaddition.util.inventory.ImmutableInventory;
import org.carpetorgaddition.util.wheel.ContainerDeepCopy;
import org.jetbrains.annotations.CheckReturnValue;

public class InventoryUtils {
    private InventoryUtils() {
    }

    @CheckReturnValue
    public static class_1799 pickItemFromShulkerBox(class_1799 shulkerBox, Predicate<class_1799> predicate) {
        if (InventoryUtils.isEmptyShulkerBox(shulkerBox)) {
            return class_1799.field_8037;
        }
        InventoryUtils.deepCopyContainer(shulkerBox);
        class_9288 component = (class_9288)shulkerBox.method_57824(class_9334.field_49622);
        for (class_1799 itemStack : component.method_59714()) {
            if (!predicate.test(itemStack)) continue;
            class_1799 copy = itemStack.method_7972();
            itemStack.method_7939(0);
            InventoryUtils.ifItIsEmptyRemoveIt(itemStack);
            return copy;
        }
        return class_1799.field_8037;
    }

    @CheckReturnValue
    public static class_1799 pickItemFromShulkerBox(class_1799 shulkerBox, Predicate<class_1799> predicate, int count) {
        if (count <= 0) {
            return class_1799.field_8037;
        }
        InventoryUtils.deepCopyContainer(shulkerBox);
        class_9288 component = (class_9288)shulkerBox.method_57825(class_9334.field_49622, (Object)class_9288.field_49334);
        class_1799 itemStack = class_1799.field_8037;
        for (class_1799 stack : component.method_59714()) {
            if (itemStack.method_7960()) {
                if (predicate.test(stack)) {
                    itemStack = stack.method_7971(count);
                    count = Math.min(itemStack.method_7914(), count) - itemStack.method_7947();
                }
            } else if (class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) {
                class_1799 split = stack.method_7971(count);
                count -= split.method_7947();
                itemStack.method_7933(split.method_7947());
            }
            if (count == 0) break;
            if (count >= 0) continue;
            throw new IllegalStateException();
        }
        return itemStack;
    }

    public static class_1799 shulkerBoxConsumer(class_1799 shulkerBox, Predicate<class_1799> predicate, Consumer<class_1799> consumer) {
        if (InventoryUtils.isEmptyShulkerBox(shulkerBox)) {
            return class_1799.field_8037;
        }
        class_9288 component = (class_9288)shulkerBox.method_57824(class_9334.field_49622);
        for (class_1799 stack : component.method_59714()) {
            if (!predicate.test(stack)) continue;
            class_1799 copyStack = stack.method_7972();
            consumer.accept(stack);
            return copyStack;
        }
        return class_1799.field_8037;
    }

    private static void ifItIsEmptyRemoveIt(class_1799 shulkerBox) {
        if (InventoryUtils.isEmptyShulkerBox(shulkerBox)) {
            shulkerBox.method_57379(class_9334.field_49622, (Object)class_9288.field_49334);
        }
    }

    public static boolean isEmptyShulkerBox(class_1799 shulkerBox) {
        if (shulkerBox.method_7947() != 1) {
            return true;
        }
        class_9288 component = (class_9288)shulkerBox.method_57824(class_9334.field_49622);
        if (component == null) {
            return true;
        }
        return !component.method_59714().iterator().hasNext();
    }

    public static ImmutableInventory getInventory(class_1799 shulkerBox) {
        if (InventoryUtils.isEmptyShulkerBox(shulkerBox)) {
            return ImmutableInventory.EMPTY;
        }
        class_9288 component = (class_9288)shulkerBox.method_57824(class_9334.field_49622);
        return new ImmutableInventory(component.method_59712().toList());
    }

    public static void deepCopyContainer(class_1799 shulkerBox) {
        class_9288 component = (class_9288)shulkerBox.method_57824(class_9334.field_49622);
        if (component == null) {
            return;
        }
        class_9288 copy = ((ContainerDeepCopy)component).copy();
        shulkerBox.method_57379(class_9334.field_49622, (Object)copy);
    }

    public static boolean isShulkerBoxItem(class_1799 shulkerBox) {
        if (shulkerBox.method_31574(class_1802.field_8545)) {
            return true;
        }
        class_1792 class_17922 = shulkerBox.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return blockItem.method_7711() instanceof class_2480;
        }
        return false;
    }

    public static void assertEmptyStack(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return;
        }
        throw new IllegalStateException();
    }

    public static void assertEmptyStack(class_1799 itemStack, Supplier<String> message) {
        if (itemStack.method_7960()) {
            return;
        }
        throw new IllegalStateException(message.get());
    }
}

