/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.constant;

import java.time.LocalDateTime;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.rule.value.CanHighlightBlockPos;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.jetbrains.annotations.Nullable;

public class TextConstants {
    public static final class_2561 OVERWORLD = TextUtils.translate("carpet.command.dimension.overworld", new Object[0]);
    public static final class_2561 THE_NETHER = TextUtils.translate("carpet.command.dimension.the_nether", new Object[0]);
    public static final class_2561 THE_END = TextUtils.translate("carpet.command.dimension.the_end", new Object[0]);
    public static final class_2561 TRUE = TextUtils.translate("carpet.command.boolean.true", new Object[0]);
    public static final class_2561 FALSE = TextUtils.translate("carpet.command.boolean.false", new Object[0]);
    public static final class_2561 CLICK_HERE = TextUtils.translate("carpet.command.text.click.here", new Object[0]);
    public static final class_2561 ITEM = TextUtils.translate("carpet.command.item.item", new Object[0]);

    public static class_2561 getBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static class_5250 blockPos(class_2338 blockPos, @Nullable class_124 color) {
        class_5250 pos = TextConstants.simpleBlockPos(blockPos);
        pos.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, WorldUtils.toPosString(blockPos))));
        pos.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtils.translate("chat.copy.click", new Object[0]))));
        if (color != null) {
            pos.method_27694(style -> style.method_10977(color));
        }
        return switch (CarpetOrgAdditionSettings.canHighlightBlockPos) {
            default -> throw new MatchException(null, null);
            case CanHighlightBlockPos.FALSE -> pos;
            case CanHighlightBlockPos.OMMC -> {
                class_5250 highlight = TextUtils.createText(" [H]");
                TextUtils.command(highlight, "/highlightWaypoint " + WorldUtils.toPosString(blockPos), (class_2561)TextUtils.translate("ommc.highlight_waypoint.tooltip", new Object[0]), color, false);
                yield TextUtils.appendAll(pos, highlight);
            }
            case CanHighlightBlockPos.DEFAULT -> {
                class_5250 highlight = TextUtils.createText(" [H]");
                TextUtils.command(highlight, "/highlight " + WorldUtils.toPosString(blockPos), (class_2561)TextUtils.translate("carpet.client.commands.highlight", new Object[0]), color, false);
                yield TextUtils.appendAll(pos, highlight);
            }
        };
    }

    public static class_5250 simpleBlockPos(class_2338 blockPos) {
        return class_2564.method_10885((class_2561)class_2561.method_43469((String)"chat.coordinates", (Object[])new Object[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()}));
    }

    public static class_5250 clickInput(String command) {
        return TextUtils.translate("carpet.command.text.click.input", command);
    }

    public static class_5250 clickRun(String command) {
        class_5250 run = CLICK_HERE.method_27661();
        class_5250 hoverText = TextUtils.translate("carpet.command.text.click.run", command);
        return TextUtils.command(run, command, (class_2561)hoverText, class_124.field_1075, false);
    }

    public static class_5250 itemCount(int count, int maxCount) {
        int group = count / maxCount;
        int remainder = count % maxCount;
        class_5250 text = TextUtils.createText(String.valueOf(count));
        if (group == 0) {
            return TextUtils.hoverText((class_2561)text, (class_2561)TextUtils.translate("carpet.command.item.remainder", remainder));
        }
        if (remainder == 0) {
            return TextUtils.hoverText((class_2561)text, (class_2561)TextUtils.translate("carpet.command.item.group", group));
        }
        return TextUtils.hoverText((class_2561)text, (class_2561)TextUtils.translate("carpet.command.item.count", group, remainder));
    }

    public static class_5250 inventory(class_2561 base, class_1263 inventory) {
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            list.add(TextUtils.appendAll(itemStack.method_7964(), "*", String.valueOf(itemStack.method_7947())));
        }
        return TextUtils.hoverText(base, (class_2561)TextUtils.appendList(list));
    }

    public static class_5250 tickToTime(long tick) {
        if (tick < 20L) {
            return TextUtils.translate("carpet.command.time.tick", tick);
        }
        if (tick < 1200L) {
            return TextUtils.translate("carpet.command.time.second", tick / 20L);
        }
        if (tick < 72000L && (tick % 1200L == 0L || tick / 20L % 60L == 0L)) {
            return TextUtils.translate("carpet.command.time.minute", tick / 1200L);
        }
        if (tick < 72000L) {
            return TextUtils.translate("carpet.command.time.minute_second", tick / 1200L, tick / 20L % 60L);
        }
        if (tick % 72000L == 0L || tick / 20L / 60L % 60L == 0L) {
            return TextUtils.translate("carpet.command.time.hour", tick / 72000L);
        }
        return TextUtils.translate("carpet.command.time.hour_minute", tick / 72000L, tick / 20L / 60L % 60L);
    }

    public static class_5250 tickToRealTime(long offset) {
        LocalDateTime time = LocalDateTime.now().plusSeconds(offset / 20L);
        return TextUtils.translate("carpet.command.time.format", time.getYear(), time.getMonth().ordinal() + 1, time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond());
    }
}

