/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import carpet.CarpetServer;
import carpet.api.settings.SettingsManager;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.util.IOUtils;

public class ConfigManager {
    public static final String CONFIG_PATH = "./config/%s".formatted(CarpetOrgAddition.MOD_NAME_LOWER_CASE);
    private static final File SETTINGS_MANAGER_CONFIG = new File(CONFIG_PATH, "settings_manager.json");

    public static void initSettingsManagerConfigs() {
        if (SETTINGS_MANAGER_CONFIG.isFile()) {
            return;
        }
        if (IOUtils.createFileIfNotExists(SETTINGS_MANAGER_CONFIG)) {
            JsonObject json = new JsonObject();
            json.addProperty("custom_settings_manager", Boolean.valueOf(false));
            json.addProperty("identifier", "carpet-org-addition");
            json.addProperty("fancy_name", CarpetOrgAddition.MOD_NAME);
            try {
                IOUtils.saveJson(SETTINGS_MANAGER_CONFIG, json);
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.error("\u521d\u59cb\u5316{}\u914d\u7f6e\u65f6\u51fa\u73b0\u610f\u5916\u9519\u8bef", (Object)CarpetOrgAddition.MOD_NAME, (Object)e);
            }
        }
    }

    public static SettingsManager getSettingManager() {
        JsonObject json;
        try {
            json = IOUtils.loadJson(SETTINGS_MANAGER_CONFIG);
        }
        catch (IOException e) {
            CarpetOrgAddition.LOGGER.error("\u65e0\u6cd5\u6b63\u786e\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6{}\uff0c\u6b63\u5728\u4f7f\u7528\u9ed8\u8ba4\u89c4\u5219\u7ba1\u7406\u5668", (Object)SETTINGS_MANAGER_CONFIG.getName(), (Object)e);
            return CarpetServer.settingsManager;
        }
        try {
            if (json.get("custom_settings_manager").getAsBoolean()) {
                String identifier = json.get("identifier").getAsString();
                if ("carpet".equals(identifier)) {
                    return CarpetServer.settingsManager;
                }
                String fancyName = json.get("fancy_name").getAsString();
                return new SettingsManager(CarpetOrgAddition.VERSION, identifier, fancyName);
            }
        }
        catch (RuntimeException e) {
            CarpetOrgAddition.LOGGER.error("\u65e0\u6cd5\u6b63\u786e\u89e3\u6790json\u6587\u4ef6\uff0c\u6b63\u5728\u4f7f\u7528\u9ed8\u8ba4\u89c4\u5219\u7ba1\u7406\u5668", (Throwable)e);
        }
        return CarpetServer.settingsManager;
    }
}

