/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.wheel.Counter;
import org.carpetorgaddition.util.wheel.TextBuilder;

public class ItemStackStatistics {
    private int sum;
    private final Predicate<class_1799> predicate;
    private final Counter<class_1792> counter = new Counter();
    private final HashSet<class_1792> nestingItem = new HashSet();

    public ItemStackStatistics(Predicate<class_1799> predicate) {
        this.predicate = predicate;
    }

    public void statistics(class_1263 inventory) {
        this.statistics(inventory, false);
    }

    public void statistics(class_1263 inventory, boolean isNestingInventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            this.tally(inventory.method_5438(i), isNestingInventory);
        }
    }

    public void statistics(Iterable<class_1799> iterable, boolean isNestingInventory) {
        iterable.forEach(itemStack -> this.tally((class_1799)itemStack, isNestingInventory));
    }

    private void statistics(class_1799 itemStack) {
        class_9288 container = (class_9288)itemStack.method_57824(class_9334.field_49622);
        if (container != null) {
            this.statistics(container.method_59714(), true);
            return;
        }
        class_9276 bundleContents = (class_9276)itemStack.method_57824(class_9334.field_49650);
        if (bundleContents != null) {
            this.statistics(bundleContents.method_57421(), true);
        }
    }

    private void tally(class_1799 itemStack, boolean nesting) {
        if (this.predicate.test(itemStack)) {
            class_1792 item = itemStack.method_7909();
            int count = itemStack.method_7947();
            this.counter.add(item, count);
            this.sum += count;
            if (nesting) {
                this.nestingItem.add(item);
            }
        } else {
            this.statistics(itemStack);
        }
    }

    public int getSum() {
        return this.sum;
    }

    public boolean hasNestingItem() {
        return !this.nestingItem.isEmpty();
    }

    public class_2561 getCountText() {
        TextBuilder builder = new TextBuilder();
        for (class_1792 item : this.counter) {
            class_5250 itemCount = this.itemCount(this.counter.getCount(item), item.method_7882());
            if (this.nestingItem.contains(item)) {
                class_5250 line = new TextBuilder().append(item.method_7848()).blank().append((class_2561)itemCount).toLine();
                builder.append((class_2561)TextUtils.toItalic(line));
            } else {
                builder.append(item.method_7848()).blank().append((class_2561)itemCount);
            }
            builder.newLine();
        }
        builder.removeLast();
        class_5250 text = TextUtils.createText(Integer.toString(this.getSum()));
        class_5250 result = TextUtils.hoverText((class_2561)text, (class_2561)builder.toLine());
        return this.nestingItem.isEmpty() ? result : TextUtils.toItalic(result);
    }

    private class_5250 itemCount(int count, int maxCount) {
        int group = count / maxCount;
        int remainder = count % maxCount;
        if (group == 0) {
            return TextUtils.translate("carpet.command.item.remainder", remainder);
        }
        if (remainder == 0) {
            return TextUtils.translate("carpet.command.item.group", group);
        }
        return TextUtils.translate("carpet.command.item.count", group, remainder);
    }
}

