/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7134;
import org.carpetorgaddition.util.GameUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.constant.TextConstants;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class Location {
    private LocationType locType = LocationType.OVERWORLD;
    private final String creatorPlayerName;
    private final String creatorTime;
    private String illustrate = null;
    private int overworld_x;
    private int overworld_y;
    private int overworld_z;
    private int the_nether_x;
    private int the_nether_y;
    private int the_nether_z;
    private int the_end_x;
    private int the_end_y;
    private int the_end_z;

    public Location(class_2338 blockPos, String dimensionId, class_3222 player) {
        this(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), dimensionId, player);
    }

    public Location(int posX, int posY, int posZ, String dimensionId, class_3222 player) {
        switch (dimensionId) {
            case "minecraft:overworld": {
                this.setOverworldPos(posX, posY, posZ);
                break;
            }
            case "minecraft:the_nether": {
                this.setTheNetherPos(posX, posY, posZ);
                break;
            }
            case "minecraft:the_end": {
                this.setTheEndPos(posX, posY, posZ);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.creatorPlayerName = player.method_5477().getString();
        this.creatorTime = GameUtils.getDateString();
    }

    public void setOverworldPos(class_2338 blockPos) {
        this.setOverworldPos(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public void setOverworldPos(int overworldPosX, int overworldPosY, int overworldPosZ) {
        this.overworld_x = overworldPosX;
        this.overworld_y = overworldPosY;
        this.overworld_z = overworldPosZ;
        this.locType = LocationType.OVERWORLD;
    }

    public void setTheNetherPos(class_2338 blockPos) {
        this.setTheNetherPos(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public void setTheNetherPos(int theNetherPosX, int theNetherPosY, int theNetherPosZ) {
        this.the_nether_x = theNetherPosX;
        this.the_nether_y = theNetherPosY;
        this.the_nether_z = theNetherPosZ;
        this.locType = LocationType.THE_NETHER;
    }

    public void setTheEndPos(class_2338 blockPos) {
        this.setTheEndPos(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public void setTheEndPos(int theEndPosX, int theEndPosY, int theEndPosZ) {
        this.the_end_x = theEndPosX;
        this.the_end_y = theEndPosY;
        this.the_end_z = theEndPosZ;
        this.locType = LocationType.THE_END;
    }

    public class_2338 getOverworldPos() {
        return new class_2338(this.overworld_x, this.overworld_y, this.overworld_z);
    }

    public class_2338 getTheNetherPos() {
        return new class_2338(this.the_nether_x, this.the_nether_y, this.the_nether_z);
    }

    public class_2338 getTheEndPos() {
        return new class_2338(this.the_end_x, this.the_end_y, this.the_end_z);
    }

    public static void saveLoc(File file, Location location, String fileName) throws IOException {
        Gson gson = new Gson();
        String json = gson.toJson((Object)location, Location.class);
        file.mkdirs();
        File newFile = new File(file, (String)(fileName.endsWith(".json") ? fileName : fileName + ".json"));
        newFile.createNewFile();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(newFile, StandardCharsets.UTF_8));){
            bw.write(json);
        }
    }

    public static Location loadLoc(File file, String fileName) throws IOException {
        StringBuilder sb;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        try (BufferedReader br = new BufferedReader(new FileReader(new File(file, (String)fileName), StandardCharsets.UTF_8));){
            String line;
            sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        Gson gson = new Gson();
        return (Location)gson.fromJson(sb.toString(), Location.class);
    }

    public class_5250 getText(String name) {
        class_5250 mutableText = null;
        switch (this.locType.ordinal()) {
            case 0: {
                mutableText = TextUtils.translate("carpet.commands.locations.text.overworld", TextConstants.blockPos(this.getOverworldPos(), class_124.field_1060));
                break;
            }
            case 1: {
                mutableText = TextUtils.translate("carpet.commands.locations.text.overworld_and_the_nether", TextConstants.blockPos(this.getOverworldPos(), class_124.field_1060), TextConstants.blockPos(this.getTheNetherPos(), class_124.field_1061));
                break;
            }
            case 2: {
                mutableText = TextUtils.translate("carpet.commands.locations.text.the_nether", TextConstants.blockPos(this.getTheNetherPos(), class_124.field_1061));
                break;
            }
            case 3: {
                mutableText = TextUtils.translate("carpet.commands.locations.text.the_nether_and_overworld", TextConstants.blockPos(this.getTheNetherPos(), class_124.field_1061), TextConstants.blockPos(this.getOverworldPos(), class_124.field_1060));
                break;
            }
            case 4: {
                mutableText = TextUtils.translate("carpet.commands.locations.text.the_end", TextConstants.blockPos(this.getTheEndPos(), class_124.field_1064));
            }
        }
        mutableText = this.illustrate != null ? TextUtils.hoverText(name, this.illustrate).method_10852((class_2561)mutableText) : class_2561.method_43470((String)name).method_10852(mutableText);
        return mutableText;
    }

    public void addAnotherPos(class_2338 blockPos) {
        switch (this.locType.ordinal()) {
            case 0: 
            case 1: {
                this.setTheNetherPos(blockPos);
                this.locType = LocationType.OVERWORLD_AND_THE_NETHER;
                break;
            }
            case 2: 
            case 3: {
                this.setOverworldPos(blockPos);
                this.locType = LocationType.THE_NETHER_AND_OVERWORLD;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void showInfo(class_2168 source, class_3222 player, String name) {
        MessageUtils.sendMessage(player, (class_2561)this.getText("[" + name + "]"));
        if (this.illustrate != null) {
            MessageUtils.sendMessage(source, "carpet.commands.locations.text.info.illustrate", this.illustrate);
        }
        MessageUtils.sendMessage(source, "carpet.commands.locations.text.info.creator_player_name", this.creatorPlayerName);
        MessageUtils.sendMessage(source, "carpet.commands.locations.text.info.creator_time", this.creatorTime);
        class_2960 value = player.method_37908().method_8597().comp_655();
        if (value.equals((Object)class_7134.field_37670) && (this.locType == LocationType.OVERWORLD || this.locType == LocationType.OVERWORLD_AND_THE_NETHER || this.locType == LocationType.THE_NETHER_AND_OVERWORLD)) {
            MessageUtils.sendMessage(source, "carpet.commands.locations.text.info.distance", (int)MathUtils.getBlockDistance(player.method_24515(), this.getOverworldPos()));
        } else if (value.equals((Object)class_7134.field_37671) && (this.locType == LocationType.THE_NETHER || this.locType == LocationType.THE_NETHER_AND_OVERWORLD || this.locType == LocationType.OVERWORLD_AND_THE_NETHER)) {
            MessageUtils.sendMessage(source, "carpet.commands.locations.text.info.distance", (int)MathUtils.getBlockDistance(player.method_24515(), this.getTheNetherPos()));
        } else if (value.equals((Object)class_7134.field_37672) && this.locType == LocationType.THE_END) {
            MessageUtils.sendMessage(source, "carpet.commands.locations.text.info.distance", (int)MathUtils.getBlockDistance(player.method_24515(), this.getTheEndPos()));
        }
    }

    public void setWayPoint(class_2338 blockPos) {
        switch (this.locType.ordinal()) {
            case 0: {
                this.setOverworldPos(blockPos);
                break;
            }
            case 1: {
                this.setOverworldPos(blockPos);
                this.locType = LocationType.OVERWORLD_AND_THE_NETHER;
                break;
            }
            case 2: {
                this.setTheNetherPos(blockPos);
                break;
            }
            case 3: {
                this.setTheNetherPos(blockPos);
                this.locType = LocationType.THE_NETHER_AND_OVERWORLD;
                break;
            }
            case 4: {
                this.setTheEndPos(blockPos);
            }
        }
    }

    public void setIllustrate(@Nullable String illustrate) {
        this.illustrate = illustrate;
    }

    public LocationType getLocType() {
        return this.locType;
    }

    public String getCreatorPlayerName() {
        return this.creatorPlayerName;
    }

    public String getIllustrate() {
        return this.illustrate;
    }

    public int getOverworld_x() {
        return this.overworld_x;
    }

    public int getOverworld_y() {
        return this.overworld_y;
    }

    public int getOverworld_z() {
        return this.overworld_z;
    }

    public int getThe_nether_x() {
        return this.the_nether_x;
    }

    public int getThe_nether_y() {
        return this.the_nether_y;
    }

    public int getThe_nether_z() {
        return this.the_nether_z;
    }

    public int getThe_end_x() {
        return this.the_end_x;
    }

    public int getThe_end_y() {
        return this.the_end_y;
    }

    public int getThe_end_z() {
        return this.the_end_z;
    }

    public static enum LocationType {
        OVERWORLD,
        OVERWORLD_AND_THE_NETHER,
        THE_NETHER,
        THE_NETHER_AND_OVERWORLD,
        THE_END;

    }
}

