/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import org.jetbrains.annotations.NotNull;

public class SelectionArea
implements Iterable<class_2338> {
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    public SelectionArea(class_1937 world, class_2338 sourcePos, int range) {
        this.minX = sourcePos.method_10263() - Math.abs(range);
        this.minY = world.method_31607();
        this.minZ = sourcePos.method_10260() - Math.abs(range);
        this.maxX = sourcePos.method_10263() + Math.abs(range);
        this.maxY = world.method_31600();
        this.maxZ = sourcePos.method_10260() + Math.abs(range);
    }

    public SelectionArea(class_2338 from, class_2338 to) {
        this.minX = Math.min(from.method_10263(), to.method_10263());
        this.minY = Math.min(from.method_10264(), to.method_10264());
        this.minZ = Math.min(from.method_10260(), to.method_10260());
        this.maxX = Math.max(from.method_10263(), to.method_10263());
        this.maxY = Math.max(from.method_10264(), to.method_10264());
        this.maxZ = Math.max(from.method_10260(), to.method_10260());
    }

    public SelectionArea(class_238 box) {
        this.minX = (int)box.field_1323;
        this.minY = (int)box.field_1322;
        this.minZ = (int)box.field_1321;
        this.maxX = (int)box.field_1320;
        this.maxY = (int)box.field_1325;
        this.maxZ = (int)box.field_1324;
    }

    public int size() {
        return (this.maxX - this.minX + 1) * (this.maxY - this.minY + 1) * (this.maxZ - this.minZ + 1);
    }

    public class_238 toBox() {
        return new class_238((double)this.minX, (double)this.minY, (double)this.minZ, (double)(this.maxX + 1), (double)(this.maxY + 1), (double)(this.maxZ + 1));
    }

    public boolean contains(class_2338 blockPos) {
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public class_2338 getMaxBlockPos() {
        return new class_2338(this.maxX, this.maxY, this.maxZ);
    }

    public class_2338 getMinBlockPos() {
        return new class_2338(this.minX, this.minY, this.minZ);
    }

    @Override
    @NotNull
    public Iterator<class_2338> iterator() {
        return new Iterator<class_2338>(){
            private int iterations = 0;
            private final int maxIterations = SelectionArea.this.size();
            private class_2338 currentPos;
            {
                this.currentPos = new class_2338(SelectionArea.this.minX, SelectionArea.this.minY, SelectionArea.this.minZ);
            }

            @Override
            public boolean hasNext() {
                return this.iterations < this.maxIterations;
            }

            @Override
            public class_2338 next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.iterations;
                class_2338 blockPos = this.currentPos;
                this.currentPos = new class_2338(this.currentPos.method_10263() + 1, this.currentPos.method_10264(), this.currentPos.method_10260());
                if (this.currentPos.method_10263() > SelectionArea.this.maxX) {
                    this.currentPos = new class_2338(SelectionArea.this.minX, this.currentPos.method_10264() + 1, this.currentPos.method_10260());
                    if (this.currentPos.method_10264() > SelectionArea.this.maxY) {
                        this.currentPos = new class_2338(SelectionArea.this.minX, SelectionArea.this.minY, this.currentPos.method_10260() + 1);
                        if (this.currentPos.method_10260() > SelectionArea.this.maxZ) {
                            return blockPos;
                        }
                    }
                }
                return blockPos;
            }
        };
    }
}

