/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.constant.TextConstants;
import org.carpetorgaddition.util.wheel.Location;
import org.carpetorgaddition.util.wheel.WorldFormat;

public class Waypoint {
    public static final String WAYPOINT = "waypoint";
    private class_2338 blockPos;
    private class_2338 anotherBlockPos;
    private final String dimension;
    private String illustrate;
    private final String creator;
    public final String name;

    public Waypoint(class_2338 blockPos, String name, String dimension, String playerName) {
        this.name = name;
        this.blockPos = blockPos;
        this.dimension = dimension;
        this.creator = playerName;
    }

    public Waypoint(Location location, String name) {
        this.name = name;
        this.creator = location.getCreatorPlayerName();
        switch (location.getLocType()) {
            case OVERWORLD: {
                this.dimension = "minecraft:overworld";
                this.blockPos = new class_2338(location.getOverworld_x(), location.getOverworld_y(), location.getOverworld_z());
                break;
            }
            case OVERWORLD_AND_THE_NETHER: {
                this.dimension = "minecraft:overworld";
                this.blockPos = new class_2338(location.getOverworld_x(), location.getOverworld_y(), location.getOverworld_z());
                this.anotherBlockPos = new class_2338(location.getThe_nether_x(), location.getThe_nether_y(), location.getThe_nether_z());
                break;
            }
            case THE_NETHER: {
                this.dimension = "minecraft:the_nether";
                this.blockPos = new class_2338(location.getThe_nether_x(), location.getThe_nether_y(), location.getThe_nether_z());
                break;
            }
            case THE_NETHER_AND_OVERWORLD: {
                this.dimension = "minecraft:the_nether";
                this.blockPos = new class_2338(location.getThe_nether_x(), location.getThe_nether_y(), location.getThe_nether_z());
                this.anotherBlockPos = new class_2338(location.getOverworld_x(), location.getOverworld_y(), location.getOverworld_z());
                break;
            }
            case THE_END: {
                this.dimension = "minecraft:the_end";
                this.blockPos = new class_2338(location.getThe_end_x(), location.getThe_end_y(), location.getThe_end_z());
                break;
            }
            default: {
                throw new IllegalStateException("\u672a\u77e5\u7684\u679a\u4e3e\u7c7b\u578b:" + String.valueOf((Object)location.getLocType()));
            }
        }
        if (location.getIllustrate() == null || location.getIllustrate().isEmpty()) {
            return;
        }
        this.illustrate = location.getIllustrate();
    }

    public static void replaceWaypoint(MinecraftServer server) {
        File file = Objects.requireNonNull(server).method_27050(class_5218.field_24188).resolve("locations").toFile();
        File flagFile = new File(file, "MOVED");
        if (flagFile.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    try {
                        Location location = Location.loadLoc(file, f.getName());
                        Waypoint waypoint = new Waypoint(location, f.getName());
                        waypoint.save(server);
                    }
                    catch (IOException e) {
                        CarpetOrgAddition.LOGGER.warn("\u8def\u5f84\u70b9[{}]\u79fb\u52a8\u5931\u8d25", (Object)IOUtils.removeExtension(f.getName()));
                    }
                }
            }
            try {
                flagFile.createNewFile();
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.warn("\u6807\u8bb0\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void save(MinecraftServer server) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("x", (Number)this.blockPos.method_10263());
        json.addProperty("y", (Number)this.blockPos.method_10264());
        json.addProperty("z", (Number)this.blockPos.method_10260());
        json.addProperty("dimension", this.dimension);
        json.addProperty("creator", this.creator);
        if (this.illustrate != null) {
            json.addProperty("illustrate", this.illustrate);
        }
        if (this.anotherBlockPos != null) {
            json.addProperty("another_x", (Number)this.anotherBlockPos.method_10263());
            json.addProperty("another_y", (Number)this.anotherBlockPos.method_10264());
            json.addProperty("another_z", (Number)this.anotherBlockPos.method_10260());
        }
        WorldFormat worldFormat = new WorldFormat(server, WAYPOINT, new String[0]);
        File file = worldFormat.file(this.name);
        IOUtils.saveJson(file, json);
    }

    public static Optional<Waypoint> load(MinecraftServer server, String name) throws IOException {
        WorldFormat worldFormat = new WorldFormat(server, WAYPOINT, new String[0]);
        File file = worldFormat.getFile(name);
        JsonObject json = IOUtils.loadJson(file);
        if (!IOUtils.jsonHasElement(json, "x", "y", "z")) {
            return Optional.empty();
        }
        class_2338 blockPos = new class_2338(json.get("x").getAsInt(), json.get("y").getAsInt(), json.get("z").getAsInt());
        String dimension = IOUtils.jsonHasElement(json, "dimension") ? json.get("dimension").getAsString() : "minecraft:overworld";
        String creator = IOUtils.jsonHasElement(json, "creator") ? json.get("creator").getAsString() : "#none";
        Waypoint waypoint = new Waypoint(blockPos, name, dimension, creator);
        if (IOUtils.jsonHasElement(json, "another_x", "another_z", "another_z")) {
            waypoint.setAnotherBlockPos(new class_2338(json.get("another_x").getAsInt(), json.get("another_y").getAsInt(), json.get("another_z").getAsInt()));
        }
        if (IOUtils.jsonHasElement(json, "illustrate")) {
            waypoint.setIllustrate(json.get("illustrate").getAsString());
        }
        return Optional.of(waypoint);
    }

    public void show(class_2168 source) {
        class_5250 text = switch (this.dimension) {
            case "minecraft:overworld" -> {
                if (this.anotherBlockPos == null) {
                    yield TextUtils.translate("carpet.commands.locations.show.overworld", this.formatName(), TextConstants.blockPos(this.blockPos, class_124.field_1060));
                }
                yield TextUtils.translate("carpet.commands.locations.show.overworld_and_the_nether", this.formatName(), TextConstants.blockPos(this.blockPos, class_124.field_1060), TextConstants.blockPos(this.anotherBlockPos, class_124.field_1061));
            }
            case "minecraft:the_nether" -> {
                if (this.anotherBlockPos == null) {
                    yield TextUtils.translate("carpet.commands.locations.show.the_nether", this.formatName(), TextConstants.blockPos(this.blockPos, class_124.field_1061));
                }
                yield TextUtils.translate("carpet.commands.locations.show.the_nether_and_overworld", this.formatName(), TextConstants.blockPos(this.blockPos, class_124.field_1061), TextConstants.blockPos(this.anotherBlockPos, class_124.field_1060));
            }
            case "minecraft:the_end" -> TextUtils.translate("carpet.commands.locations.show.the_end", this.formatName(), TextConstants.blockPos(this.blockPos, class_124.field_1064));
            default -> TextUtils.translate("carpet.commands.locations.show.custom_dimension", this.formatName(), this.dimension, TextConstants.blockPos(this.blockPos, class_124.field_1060));
        };
        MessageUtils.sendMessage(source, (class_2561)text);
    }

    private class_2561 formatName() {
        String name = "[" + this.name.split("\\.")[0] + "]";
        if (this.illustrate == null) {
            return TextUtils.createText(name);
        }
        return TextUtils.hoverText(name, this.illustrate);
    }

    public void setAnotherBlockPos(class_2338 anotherBlockPos) {
        this.anotherBlockPos = anotherBlockPos;
    }

    public void setIllustrate(String illustrate) {
        if (illustrate == null || illustrate.isEmpty()) {
            this.illustrate = null;
            return;
        }
        this.illustrate = illustrate;
    }

    public void setBlockPos(class_2338 blockPos) {
        this.blockPos = blockPos;
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public class_2338 getAnotherBlockPos() {
        return this.anotherBlockPos;
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getName() {
        return this.name;
    }

    public boolean canAddAnother() {
        return this.dimension.equals("minecraft:overworld") || this.dimension.equals("minecraft:the_nether");
    }
}

