/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.jetbrains.annotations.Nullable;

public class WorldFormat {
    public static final Predicate<File> JSON_EXTENSIONS = file -> file.getName().endsWith(".json");
    private final File modFileDirectory;

    public WorldFormat(MinecraftServer server, @Nullable String directory, String ... directories) {
        Path path = server.method_27050(class_5218.field_24188).resolve(CarpetOrgAddition.MOD_NAME_LOWER_CASE);
        if (directory != null) {
            path = path.resolve(directory);
        }
        for (String name : directories) {
            path = path.resolve(name);
        }
        this.modFileDirectory = path.toFile();
        if (this.modFileDirectory.isDirectory() || this.modFileDirectory.mkdirs()) {
            return;
        }
        CarpetOrgAddition.LOGGER.error("{}\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25", (Object)this.modFileDirectory);
    }

    public File file(String fileName) {
        return new File(this.modFileDirectory, WorldFormat.suppFileName(fileName));
    }

    public File getFile(String fileName) {
        fileName = WorldFormat.suppFileName(fileName);
        return new File(this.modFileDirectory, fileName);
    }

    private static String suppFileName(String fileName) {
        if (fileName.split("\\.").length == 1) {
            return fileName + ".json";
        }
        return fileName;
    }

    @Deprecated(forRemoval=true)
    public HashSet<File> listFiles() {
        File[] files = this.modFileDirectory.listFiles();
        if (files == null) {
            return new HashSet<File>();
        }
        return new HashSet<File>(Arrays.asList(files));
    }

    public List<File> toImmutableFileList() {
        File[] files = this.modFileDirectory.listFiles();
        if (files == null) {
            return List.of();
        }
        return Stream.of(files).sorted(Comparator.comparing(file -> file.getName().toLowerCase())).toList();
    }

    public List<File> toImmutableFileList(Predicate<File> filter) {
        File[] files = this.modFileDirectory.listFiles();
        if (files == null) {
            return List.of();
        }
        return Stream.of(files).filter(filter).sorted(Comparator.comparing(file -> file.getName().toLowerCase())).toList();
    }

    public boolean fileExists(String fileName) {
        fileName = WorldFormat.suppFileName(fileName);
        File file = this.file(fileName);
        return file.exists();
    }

    public String toString() {
        return this.modFileDirectory.toString();
    }
}

