/*
 * Decompiled with CFR 0.152.
 */
package org.docs.rule;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carpetorgaddition.rule.Hidden;
import org.carpetorgaddition.rule.Removed;
import org.docs.rule.RuleInformation;
import org.jetbrains.annotations.Nullable;

public class RuleDocument {
    private final LinkedHashSet<String> rules = new LinkedHashSet();
    private final JsonObject json;

    public static void main(String[] args) throws IOException, NoSuchFieldException, ClassNotFoundException {
        String time = DateTimeFormatter.ofPattern("yyMMddHHmmss").format(LocalDateTime.now());
        FileInputStream fileInputStream = new FileInputStream("docs/rules.md");
        Files.copy(fileInputStream, Path.of("docs/backups/rules/" + time + ".md", new String[0]), new CopyOption[0]);
        RuleDocument ruleDocument = new RuleDocument();
        BufferedWriter writer = new BufferedWriter(new FileWriter("docs/rules.md"));
        writer.write("## \u6240\u6709\u89c4\u5219");
        writer.newLine();
        writer.newLine();
        writer.write("**\u63d0\u793a\uff1a\u53ef\u4ee5\u4f7f\u7528`Ctrl+F`\u5feb\u901f\u67e5\u627e\u81ea\u5df1\u60f3\u8981\u7684\u89c4\u5219**");
        writer.newLine();
        writer.newLine();
        for (String rule : ruleDocument.rules) {
            RuleInformation ruleInfo = ruleDocument.readClass(rule);
            if (ruleInfo == null) continue;
            writer.write(ruleInfo.toString());
            writer.newLine();
        }
        writer.close();
    }

    RuleDocument() throws FileNotFoundException {
        BufferedReader reader = new BufferedReader(new FileReader("src/main/resources/assets/carpet-org-addition/lang/zh_cn.json"));
        Gson gson = new Gson();
        this.json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
        Set entries = this.json.entrySet();
        for (Map.Entry entry : entries) {
            List<String> list = Arrays.stream(((String)entry.getKey()).split("\\.")).toList();
            if (!this.isRule(list)) continue;
            this.rules.add(list.get(2));
        }
    }

    private boolean isRule(List<String> list) {
        if ("carpet".equals(list.get(0)) && "rule".equals(list.get(1))) {
            return !"message".equals(list.get(2)) && !"validate".equals(list.get(2));
        }
        return false;
    }

    @Nullable
    RuleInformation readClass(String rule) throws ClassNotFoundException, NoSuchFieldException {
        Class<?> clazz = Class.forName("org.carpetorgaddition.CarpetOrgAdditionSettings");
        Field field = clazz.getField(rule);
        if (field.isAnnotationPresent(Removed.class) || field.isAnnotationPresent(Hidden.class)) {
            return null;
        }
        return new RuleInformation(field, this.readRuleName(rule), this.readRuleDesc(rule), this.readRuleExtra(rule));
    }

    private String readRuleName(String rule) {
        return this.json.get("carpet.rule." + rule + ".name").getAsString();
    }

    private String readRuleDesc(String rule) {
        return this.json.get("carpet.rule." + rule + ".desc").getAsString();
    }

    private String[] readRuleExtra(String rule) {
        String extra;
        int number = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (this.json.has(extra = "carpet.rule." + rule + ".extra." + number)) {
            list.add(this.json.get(extra).getAsString());
            ++number;
        }
        return list.toArray(new String[0]);
    }
}

