/*
 * Decompiled with CFR 0.152.
 */
package org.docs.rule;

import carpet.api.settings.Rule;
import java.lang.reflect.Field;
import java.util.StringJoiner;

class RuleInformation {
    private final Field field;
    private final String name;
    private final String docs;
    private final String[] extra;
    private final String[] categories;
    private final String[] options;

    RuleInformation(Field field, String name, String docs, String[] extra) {
        this.field = field;
        this.name = name;
        this.docs = docs;
        this.extra = extra;
        Rule annotation = field.getAnnotation(Rule.class);
        if (annotation == null) {
            throw new IllegalArgumentException();
        }
        this.categories = annotation.categories();
        this.options = annotation.options();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("### ").append(this.name).append("(").append(this.field.getName()).append(")\n");
        sb.append("\n");
        sb.append(this.docs).append(this.hasExtra() ? "<br/>\n" : "\n");
        if (this.hasExtra()) {
            for (String extra : this.extra) {
                sb.append("_").append(extra).append("_<br/>\n");
            }
            sb.append("\n");
        } else {
            sb.append("\n");
        }
        sb.append("- \u7c7b\u578b\uff1a`").append(this.getArgumentType()).append("`\n");
        sb.append("- \u9ed8\u8ba4\u503c\uff1a`").append(this.getDefaultValue()).append("`\n");
        if (this.options.length > 0) {
            StringJoiner sj = new StringJoiner("\uff0c", "- \u53c2\u8003\u9009\u9879\uff1a", "\n");
            for (String option : this.options) {
                sj.add("`" + option + "`");
            }
            sb.append(sj);
        } else if (this.isBoolean()) {
            sb.append("- \u53c2\u8003\u9009\u9879\uff1a`true`\uff0c`false`\n");
        }
        sb.append(this.getCategory());
        return sb.toString();
    }

    private boolean isBoolean() {
        return Boolean.TYPE.isAssignableFrom(this.field.getType()) || Boolean.class.isAssignableFrom(this.field.getType());
    }

    private boolean hasExtra() {
        return this.extra.length > 0;
    }

    private String getArgumentType() {
        Class<?> type = this.field.getType();
        if (String.class.isAssignableFrom(type)) {
            return "\u5b57\u7b26\u4e32";
        }
        if (Byte.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
            return "\u6574\u6570";
        }
        if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
            return "\u957f\u6574\u6570";
        }
        if (Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
            return "\u5c0f\u6570";
        }
        if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
            return "\u5e03\u5c14\u503c";
        }
        if (Character.TYPE.isAssignableFrom(type) || Character.class.isAssignableFrom(type)) {
            return "\u5b57\u7b26";
        }
        if (Enum.class.isAssignableFrom(type)) {
            return "\u679a\u4e3e";
        }
        throw new RuntimeException(this.field.getType().getName());
    }

    private String getDefaultValue() {
        try {
            return this.field.get(null).toString().toLowerCase();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private String getCategory() {
        StringJoiner stringJoiner = new StringJoiner("\uff0c", "- \u5206\u7c7b\uff1a", "\n");
        String[] stringArray = this.categories;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String category;
            stringJoiner.add("`" + (switch (category = stringArray[i]) {
                case "Org" -> "Org";
                case "bugfix" -> "\u6f0f\u6d1e\u4fee\u590d";
                case "survival" -> "\u751f\u5b58";
                case "creative" -> "\u521b\u9020";
                case "experimental" -> "\u8bd5\u9a8c\u6027";
                case "optimization" -> "\u4f18\u5316";
                case "feature" -> "\u7279\u6027";
                case "command" -> "\u547d\u4ee4";
                case "tnt" -> "TNT";
                case "dispenser" -> "\u53d1\u5c04\u5668";
                case "scarpet" -> "Scarpet\u811a\u672c\u8bed\u8a00";
                case "client" -> "\u5ba2\u6237\u7aef";
                default -> category;
            }) + "`");
        }
        return stringJoiner.toString();
    }
}

