/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.prism.text;

import com.anthonyhilyard.prism.events.client.RenderTickEvent;
import com.anthonyhilyard.prism.util.ColorUtil;
import com.anthonyhilyard.prism.util.IColor;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_3532;
import net.minecraft.class_5251;
import net.minecraft.class_9779;

public final class DynamicColor
extends class_5251
implements IColor {
    private final List<IColor> values = Lists.newArrayList();
    private float duration;
    private int currentIndex;
    private float timer;

    public DynamicColor(IColor color) {
        this(color, color.getName());
    }

    public DynamicColor(IColor color, String name) {
        this(List.of(color), 0.0f, name);
    }

    public DynamicColor(List<IColor> values, float duration) {
        this(values, duration, null);
    }

    public DynamicColor(List<IColor> values, float duration, String name) {
        super(values.get(0).getIntValue(), name);
        this.values.addAll(values);
        float f = this.duration = values.size() > 0 ? duration / (float)values.size() : duration;
        if (this.isAnimated()) {
            RenderTickEvent.START.register(this::onRenderTick);
        }
    }

    public static DynamicColor fromRgb(int value) {
        if (Integer.compareUnsigned(value, 0xFFFFFF) >= 0) {
            return DynamicColor.fromARGB(value >> 24 & 0xFF, value >> 16 & 0xFF, value >> 8 & 0xFF, value >> 0 & 0xFF);
        }
        return DynamicColor.fromRGB(value >> 16 & 0xFF, value >> 8 & 0xFF, value >> 0 & 0xFF);
    }

    public static DynamicColor fromRGB(float red, float green, float blue) {
        return DynamicColor.fromARGB(1.0f, red, green, blue);
    }

    public static DynamicColor fromRGB(int red, int green, int blue) {
        return DynamicColor.fromARGB(255, red, green, blue);
    }

    public static DynamicColor fromARGB(float alpha, float red, float green, float blue) {
        return DynamicColor.fromARGB((int)(alpha * 255.0f), (int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f));
    }

    public static DynamicColor fromARGB(final int alpha, final int red, final int green, final int blue) {
        return new DynamicColor(new IColor(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public int getIntValue() {
                return ColorUtil.combineARGB(alpha, red, green, blue);
            }

            @Override
            public boolean isAnimated() {
                return false;
            }
        }, null);
    }

    public static DynamicColor fromHSV(float hue, float saturation, float value) {
        return DynamicColor.fromAHSV(1.0f, hue, saturation, value);
    }

    public static DynamicColor fromHSV(int hue, int saturation, int value) {
        return DynamicColor.fromAHSV(255, hue, saturation, value);
    }

    public static DynamicColor fromAHSV(float alpha, float hue, float saturation, float value) {
        return DynamicColor.fromAHSV((int)(alpha * 255.0f + 0.5f), (int)(hue * 255.0f + 0.5f), (int)(saturation * 255.0f + 0.5f), (int)(value * 255.0f + 0.5f));
    }

    public static DynamicColor fromAHSV(final int alpha, final int hue, final int saturation, final int value) {
        return new DynamicColor(new IColor(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public int getIntValue() {
                return ColorUtil.AHSVtoARGB(alpha, hue, saturation, value);
            }

            @Override
            public boolean isAnimated() {
                return false;
            }
        }, null);
    }

    public static DynamicColor fromColor(IColor color) {
        return new DynamicColor(color);
    }

    public int alpha() {
        return this.getIntValue() >> 24 & 0xFF;
    }

    public int red() {
        return this.getIntValue() >> 16 & 0xFF;
    }

    public int green() {
        return this.getIntValue() >> 8 & 0xFF;
    }

    public int blue() {
        return this.getIntValue() >> 0 & 0xFF;
    }

    public int hue() {
        return (int)(ColorUtil.RGBtoHSV(this.red(), this.green(), this.blue())[0] * 360.0f);
    }

    public int saturation() {
        return (int)(ColorUtil.RGBtoHSV(this.red(), this.green(), this.blue())[1] * 255.0f);
    }

    public int value() {
        return (int)(ColorUtil.RGBtoHSV(this.red(), this.green(), this.blue())[2] * 255.0f);
    }

    public void addColor(IColor color) {
        this.values.add(color);
    }

    public void clearColors() {
        this.values.clear();
        this.currentIndex = 0;
    }

    public void setDuration(float duration) {
        this.duration = Math.max(duration, 0.0f);
        if (this.isAnimated()) {
            RenderTickEvent.START.register(this::onRenderTick);
        }
    }

    @Override
    public boolean isAnimated() {
        return this.values.size() > 1 && this.duration > 0.0f;
    }

    public int method_27716() {
        return this.getIntValue();
    }

    @Override
    public int getIntValue() {
        if (this.values.isEmpty()) {
            return 0;
        }
        if (this.values.size() > 1) {
            int nextIndex = (this.currentIndex + 1) % this.values.size();
            int currentValue = this.values.get(this.currentIndex).getIntValue();
            int nextValue = this.values.get(nextIndex).getIntValue();
            int alpha = (int)class_3532.method_16439((float)(this.timer / this.duration), (float)(currentValue >> 24 & 0xFF), (float)(nextValue >> 24 & 0xFF));
            int red = (int)class_3532.method_16439((float)(this.timer / this.duration), (float)(currentValue >> 16 & 0xFF), (float)(nextValue >> 16 & 0xFF));
            int green = (int)class_3532.method_16439((float)(this.timer / this.duration), (float)(currentValue >> 8 & 0xFF), (float)(nextValue >> 8 & 0xFF));
            int blue = (int)class_3532.method_16439((float)(this.timer / this.duration), (float)(currentValue >> 0 & 0xFF), (float)(nextValue >> 0 & 0xFF));
            return ColorUtil.combineARGB(alpha, red, green, blue);
        }
        return this.values.get(0).getIntValue();
    }

    public String toString() {
        if (this.values.size() == 1) {
            return this.field_24365 != null ? this.field_24365 : String.format("#%08X", this.method_27716());
        }
        StringBuilder result = new StringBuilder();
        result.append("([");
        for (IColor value : this.values) {
            result.append(value.getName() != null ? value.getName() : String.format("#%08X", value.getIntValue()));
            result.append(", ");
        }
        result.delete(result.length() - 2, result.length() - 1);
        result.append("], ");
        result.append(this.duration);
        result.append("s)");
        return result.toString();
    }

    public void onRenderTick(class_9779 tracker) {
        this.timer += tracker.method_60638() / 50.0f;
        if (this.timer >= this.duration) {
            this.currentIndex = (this.currentIndex + 1) % this.values.size();
            this.timer -= this.duration;
        }
    }

    @Override
    public String getName() {
        return this.field_24365;
    }
}

