/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.api.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1060;
import net.minecraft.class_276;
import net.minecraft.class_3300;
import net.minecraft.class_4587;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.api.ICreativeConfig;
import team.creative.creativecore.common.util.type.Color;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.VisualHandler;

public abstract class VisualType
implements ICreativeConfig {
    private static List<VisualType> types = new ArrayList<VisualType>();
    @CreativeConfig
    public boolean disabled = false;
    private boolean isEffectedByWater = true;
    @CreativeConfig
    @CreativeConfig.DecimalRange(max=1.0, min=0.0)
    public float opacity = 1.0f;
    public final String name;
    public final VisualCategory cat;

    public static Collection<VisualType> getTypes() {
        return types;
    }

    public VisualType(String name, VisualCategory cat) {
        this.name = name;
        this.cat = cat;
        types.add(this);
    }

    public VisualType setIgnoreWater() {
        this.isEffectedByWater = false;
        return this;
    }

    public boolean isAffectedByWater() {
        return this.cat.isAffectedByWater() && this.isEffectedByWater;
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void loadResources(class_3300 var1);

    @Environment(value=EnvType.CLIENT)
    public abstract void render(class_4587 var1, VisualHandler var2, Visual var3, class_1060 var4, int var5, int var6, float var7);

    public void configured(Side side) {
    }

    @Environment(value=EnvType.CLIENT)
    public int getVariantAmount() {
        return 1;
    }

    public Color getColor() {
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public void resize(class_276 buffer) {
    }

    public boolean canRotate() {
        return true;
    }

    public boolean isVisible(VisualHandler handler, Visual visual) {
        return visual.getOpacity() > 0.0f;
    }

    public boolean scaleVariants() {
        return false;
    }

    public double randomScale(Random rand) {
        return 1.0;
    }

    public int getWidth(int screenWidth, int screenHeight) {
        return screenWidth;
    }

    public int getHeight(int screenWidth, int screenHeight) {
        return screenHeight;
    }
}

