/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.api.type;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1060;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.render.EVRenderer;
import team.creative.enhancedvisuals.client.render.TextureCache;

public abstract class VisualTypeTexture
extends VisualType {
    private static final float DEFAULT_PARTICLE_SIZE = 0.15f;
    @CreativeConfig
    public int animationSpeed;
    public String domain;
    @Environment(value=EnvType.CLIENT)
    public TextureCache[] resources;
    @Environment(value=EnvType.CLIENT)
    public Dimension dimension;
    public float ratio;

    public VisualTypeTexture(VisualCategory category, String name, String domain, int animationSpeed) {
        super(name, category);
        this.domain = domain;
        this.animationSpeed = animationSpeed;
    }

    public VisualTypeTexture(VisualCategory category, String name, int animationSpeed) {
        this(category, name, null, animationSpeed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Environment(value=EnvType.CLIENT)
    public void loadResources(class_3300 manager) {
        String baseLocation = "visuals/" + this.cat.name() + "/" + this.name + "/" + this.name;
        ArrayList<TextureCache> caches = new ArrayList<TextureCache>();
        int i = 0;
        TextureCache resource = null;
        String domain = this.domain == null ? "enhancedvisuals" : this.domain;
        try {
            while ((resource = TextureCache.parse(manager, domain, baseLocation + i)) != null) {
                Optional re;
                if (i == 0 && (re = manager.method_14486(resource.getFirst())).isPresent()) {
                    try (InputStream input = ((class_3298)re.orElseThrow()).method_14482();){
                        BufferedImage image = ImageIO.read(input);
                        this.dimension = new Dimension(image.getWidth(), image.getHeight());
                        this.ratio = (float)this.dimension.width / (float)this.dimension.height;
                    }
                }
                caches.add(resource);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.resources = caches.toArray(new TextureCache[0]);
        if (this.resources.length == 0) {
            EnhancedVisuals.LOGGER.warn("Could not find any resources for '" + this.name + "'!");
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int getVariantAmount() {
        return this.resources.length;
    }

    @Environment(value=EnvType.CLIENT)
    public class_2960 getResource(Visual visual) {
        if (this.animationSpeed > 0) {
            long time = Math.abs(System.nanoTime() / 3000000L / (long)this.animationSpeed);
            return this.resources[(int)(time % (long)this.resources.length)].getResource();
        }
        return this.resources[visual.variant].getResource();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_4587 pose, VisualHandler handler, Visual visual, class_1060 manager, int screenWidth, int screenHeight, float partialTicks) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getResource(visual));
        RenderSystem.setShader(EVRenderer::getPositionTexColorSmoothShader);
        Matrix4f last = pose.method_23760().method_23761();
        int red = visual.color != null ? (int)visual.color.getRed() : 255;
        int green = visual.color != null ? (int)visual.color.getGreen() : 255;
        int blue = visual.color != null ? (int)visual.color.getBlue() : 255;
        float z = -90.0f;
        int width = visual.getWidth(screenWidth);
        int height = visual.getHeight(screenHeight);
        float opacity = visual.getOpacity();
        class_287 renderer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        renderer.method_22918(last, 0.0f, (float)height, z).method_22913(0.0f, 1.0f).method_1336(red, green, blue, (int)(opacity * 255.0f));
        renderer.method_22918(last, (float)width, (float)height, z).method_22913(1.0f, 1.0f).method_1336(red, green, blue, (int)(opacity * 255.0f));
        renderer.method_22918(last, (float)width, 0.0f, z).method_22913(1.0f, 0.0f).method_1336(red, green, blue, (int)(opacity * 255.0f));
        renderer.method_22918(last, 0.0f, 0.0f, z).method_22913(0.0f, 0.0f).method_1336(red, green, blue, (int)(opacity * 255.0f));
        class_286.method_43433((class_9801)renderer.method_60800());
    }

    @Override
    public int getWidth(int screenWidth, int screenHeight) {
        return (int)((float)screenHeight * 0.15f * this.ratio);
    }

    @Override
    public int getHeight(int screenWidth, int screenHeight) {
        return (int)((float)screenHeight * 0.15f);
    }
}

