/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1927;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8956;
import net.minecraft.class_9238;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.premade.IntMinMax;
import team.creative.creativecore.common.config.premade.curve.Curve;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.creativecore.common.config.premade.curve.IntCurve;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeBlur;
import team.creative.enhancedvisuals.api.type.VisualTypeParticle;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.client.sound.SoundMuteHandler;

public class ExplosionHandler
extends VisualHandler {
    @CreativeConfig
    public VisualType dust = new VisualTypeParticle("dust");
    @CreativeConfig
    public IntMinMax dustDuration = new IntMinMax(500, 1000);
    @CreativeConfig
    public IntCurve dustAmount = new IntCurve(0, 0, 20, 30);
    @CreativeConfig
    public float maxExplosionVolume = 0.5f;
    @CreativeConfig
    public IntCurve explosionSoundTime = new IntCurve(0, 50, 20, 200);
    @CreativeConfig
    public VisualType blur = new VisualTypeBlur("blur");
    @CreativeConfig
    public DecimalCurve maxBlur = new DecimalCurve(0.0, 50.0, 10.0, 100.0);
    @CreativeConfig
    public IntCurve explosionBlurTime = new IntCurve(0, 10, 20, 20);
    @CreativeConfig
    public boolean ignoreBreeze = true;
    @CreativeConfig
    public boolean ignoreMace = true;
    @CreativeConfig
    public boolean ignoreSelfWindCharge = true;
    private class_6880<class_1887> windBurst;

    private boolean isMace(class_5455 access, class_1799 stack) {
        if (this.windBurst == null) {
            this.windBurst = access.method_46762(class_7924.field_41265).method_46747(class_1893.field_50159);
        }
        return stack.method_7909() == class_1802.field_49814 && stack.method_58657().method_57536(this.windBurst) > 0;
    }

    public void onExploded(class_1657 player, class_243 pos, float size, class_1927.class_4179 blockInteraction, @Nullable class_1297 source, @Nullable Class sourceClass) {
        double d14;
        class_8956 w;
        if (this.ignoreBreeze && sourceClass != null && class_9238.class.isAssignableFrom(sourceClass)) {
            return;
        }
        if (this.ignoreSelfWindCharge && source instanceof class_8956 && (w = (class_8956)source).method_24921() == player) {
            return;
        }
        if (this.ignoreMace && source == null && blockInteraction == class_1927.class_4179.field_47331 && (this.isMace(player.method_56673(), player.method_6047()) || this.isMace(player.method_56673(), player.method_6079()))) {
            return;
        }
        float f3 = size * 2.0f;
        double d12 = Math.sqrt(player.method_5707(pos)) / (double)f3;
        double d10 = (1.0 - d12) * (d14 = (double)class_1927.method_17752((class_243)pos, (class_1297)player));
        float damage = (int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0);
        if (damage > 0.0f) {
            VisualManager.addParticlesFadeOut(this.dust, (VisualHandler)this, (int)this.dustAmount.valueAt((double)damage), this.dustDuration, true);
            DecimalCurve explosionSoundVolume = new DecimalCurve(0.0, (double)this.maxExplosionVolume, this.explosionSoundTime.valueAt((double)damage), 0.0);
            DecimalCurve explosionSoundMuteVolume = new DecimalCurve(0.0, 1.0, this.explosionSoundTime.valueAt((double)damage), 0.0);
            if (SoundMuteHandler.startMuting(explosionSoundMuteVolume)) {
                this.playSoundFadeOut(class_2960.method_43902((String)"enhancedvisuals", (String)"ringing"), null, explosionSoundVolume);
            }
            VisualManager.addVisualFadeOut(this.blur, (VisualHandler)this, (Curve)new DecimalCurve(0.0, this.maxBlur.valueAt((double)damage), (double)((int)this.explosionBlurTime.valueAt((double)damage)), 0.0));
        }
    }
}

