/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3675;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.client.ItemEntityRendering;
import team.creative.itemphysic.common.CommonPhysic;
import team.creative.itemphysic.common.packet.DropPacket;
import team.creative.itemphysic.common.packet.PickupPacket;
import team.creative.itemphysic.mixin.EntityAccessor;

@Environment(value=EnvType.CLIENT)
public class ItemPhysicClient {
    public static final class_304 PICKUP = new class_304("key.pickup.item", class_3675.field_16237.method_1444(), "key.categories.gameplay");
    public static final class_310 mc = class_310.method_1551();
    public static int throwCharge;
    public static long lastTickTime;
    private static final double RANDOM_Y_OFFSET_SCALE = 0.007957747154594767;

    public static void init() {
        ICreativeLoader loader = CreativeCore.loader();
        loader.registerKeybind(() -> PICKUP);
        loader.registerClientTick(ItemPhysicClient::gameTick);
        loader.registerClientRenderGui(ItemPhysicClient::renderTick);
        CreativeCoreClient.registerClientConfig((String)"itemphysic");
    }

    public static int getChargeStage() {
        return Math.min(1 + throwCharge / ItemPhysic.CONFIG.throwConfig.stageChargeTime, ItemPhysic.CONFIG.throwConfig.maxStages);
    }

    public static void gameTick() {
        if (ItemPhysicClient.mc.field_1724 != null && !ItemPhysicClient.mc.field_1724.method_6047().method_7960() && ItemPhysic.CONFIG.throwConfig.enabled) {
            if (ItemPhysicClient.mc.field_1690.field_1869.method_1434()) {
                ++throwCharge;
            } else {
                if (throwCharge > 0) {
                    boolean dropAll = class_437.method_25441();
                    ItemPhysic.NETWORK.sendToServer((CreativePacket)new DropPacket(class_437.method_25441(), ItemPhysicClient.getChargeStage()));
                    if (ItemPhysicClient.mc.field_1724.method_31548().method_5434(ItemPhysicClient.mc.field_1724.method_31548().field_7545, dropAll && !ItemPhysicClient.mc.field_1724.method_31548().method_7391().method_7960() ? ItemPhysicClient.mc.field_1724.method_31548().method_7391().method_7947() : 1) != class_1799.field_8037) {
                        ItemPhysicClient.mc.field_1724.method_6104(class_1268.field_5808);
                    }
                }
                throwCharge = 0;
            }
        }
    }

    public static void renderTick(Object object) {
        lastTickTime = System.nanoTime();
        if (ItemPhysicClient.mc.field_1755 == null) {
            ItemPhysicClient.renderTooltip((class_332)object);
        }
    }

    public static void renderTooltip(class_332 graphics) {
        if (mc != null && ItemPhysicClient.mc.field_1724 != null && !mc.method_1493()) {
            class_239 result;
            if (ItemPhysic.CONFIG.pickup.customPickup && (result = ItemPhysicClient.getEntityItem((class_1657)ItemPhysicClient.mc.field_1724)) != null && result.method_17783() == class_239.class_240.field_1331) {
                class_1542 entity;
                if (PICKUP.method_1434()) {
                    ItemPhysicClient.onPlayerInteractClient((class_1937)ItemPhysicClient.mc.field_1687, (class_1657)ItemPhysicClient.mc.field_1724, false);
                }
                if ((entity = (class_1542)((class_3966)result).method_17782()) != null && ItemPhysic.CONFIG.rendering.showPickupTooltip) {
                    int space = 2;
                    ArrayList<Object> list = new ArrayList<Object>();
                    try {
                        if (ItemPhysic.CONFIG.rendering.showPickupTooltipExtended) {
                            list.addAll(entity.method_6983().method_7950(class_1792.class_9635.method_59528((class_1937)ItemPhysicClient.mc.field_1687), (class_1657)ItemPhysicClient.mc.field_1724, (class_1836)class_1836.field_41070));
                        } else {
                            list.add((class_2561)entity.method_6983().method_7950(class_1792.class_9635.method_59528((class_1937)ItemPhysicClient.mc.field_1687), (class_1657)ItemPhysicClient.mc.field_1724, (class_1836)class_1836.field_41070).get(0));
                        }
                    }
                    catch (Exception e) {
                        list = new ArrayList();
                        list.add(class_2561.method_43470((String)"ERRORED"));
                    }
                    if (ItemPhysic.CONFIG.rendering.showPickupTooltipKeybind) {
                        list.add(class_2561.method_43469((String)"item.tooltip.pickup.keybind", (Object[])new Object[]{PICKUP.method_1415() ? ItemPhysicClient.mc.field_1690.field_1904.method_16007() : PICKUP.method_16007()}));
                    }
                    int width = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        String text = ((class_2561)list.get(i)).getString();
                        width = Math.max(width, ItemPhysicClient.mc.field_1772.method_1727(text) + 10);
                    }
                    int n = list.size();
                    Objects.requireNonNull(ItemPhysicClient.mc.field_1772);
                    int height = n * (9 + space) / 2;
                    RenderSystem.disableBlend();
                    for (int i = 0; i < list.size(); ++i) {
                        String text = ((class_2561)list.get(i)).getString();
                        class_327 class_3272 = ItemPhysicClient.mc.field_1772;
                        class_2561 class_25612 = (class_2561)list.get(i);
                        int n2 = mc.method_22683().method_4486() / 2 - ItemPhysicClient.mc.field_1772.method_1727(text) / 2 + ItemPhysic.CONFIG.rendering.tooltipOffsetX;
                        int n3 = mc.method_22683().method_4502() / 2 - height;
                        Objects.requireNonNull(ItemPhysicClient.mc.field_1772);
                        graphics.method_27535(class_3272, class_25612, n2, n3 + (9 + space) * i + ItemPhysic.CONFIG.rendering.tooltipOffsetY, 0xFCFCFC);
                    }
                }
            }
            if (ItemPhysic.CONFIG.throwConfig.enabled && !ItemPhysic.CONFIG.rendering.disableThrowHUD && throwCharge > 0) {
                ItemPhysicClient.mc.field_1724.method_7353((class_2561)class_2561.method_43469((String)"item.throw", (Object[])new Object[]{ItemPhysicClient.getChargeStage()}), true);
            }
        }
    }

    public static boolean render(class_1542 entity, float entityYaw, float partialTicks, class_4587 pose, class_4597 buffer, int packedLight, class_918 itemRenderer, class_5819 rand) {
        boolean applyEffects;
        class_243 motionMultiplier;
        if (entity.method_6985() == 0 || ((ItemEntityRendering)entity).skipRendering() || ItemPhysic.CONFIG.rendering.vanillaRendering) {
            return false;
        }
        pose.method_22903();
        class_1799 itemstack = entity.method_6983();
        rand.method_43052(itemstack.method_7960() ? 187L : (long)(class_1792.method_7880((class_1792)itemstack.method_7909()) + itemstack.method_7919()));
        class_1087 bakedmodel = itemRenderer.method_4019(itemstack, entity.method_37908(), (class_1309)null, entity.method_5628());
        boolean flag = bakedmodel.method_4712();
        int j = ItemPhysicClient.getModelCount(itemstack);
        float rotateBy = (float)(System.nanoTime() - lastTickTime) / 2.0E8f * ItemPhysic.CONFIG.rendering.rotateSpeed;
        if (mc.method_1493()) {
            rotateBy = 0.0f;
        }
        if ((motionMultiplier = ((EntityAccessor)entity).getStuckSpeedMultiplier()) != null && motionMultiplier.method_1027() > 0.0) {
            rotateBy = (float)((double)rotateBy * (motionMultiplier.field_1352 * 0.2));
        }
        pose.method_22907(class_7833.field_40714.rotation(1.5707964f));
        pose.method_22907(class_7833.field_40718.rotation(entity.method_36454()));
        boolean bl = applyEffects = entity.method_6985() != 0 && (flag || ItemPhysicClient.mc.field_1690 != null);
        if (applyEffects) {
            if (flag) {
                if (!entity.method_24828()) {
                    rotateBy *= 2.0f;
                    class_3611 fluid = CommonPhysic.getFluid(entity);
                    if (fluid == null) {
                        fluid = CommonPhysic.getFluid(entity, true);
                    }
                    if (fluid != null) {
                        rotateBy /= 1.0f + CommonPhysic.getViscosity(fluid, entity.method_37908());
                    }
                    entity.method_36457(entity.method_36455() + rotateBy);
                } else if (ItemPhysic.CONFIG.rendering.oldRotation) {
                    for (int side = 0; side < 4; ++side) {
                        double rotation = side * 90;
                        double range = 5.0;
                        if (!((double)entity.method_36455() > rotation - range) || !((double)entity.method_36455() < rotation + range)) continue;
                        entity.method_36457((float)rotation);
                    }
                    if (entity.method_36455() != 0.0f && entity.method_36455() != 90.0f && entity.method_36455() != 180.0f && entity.method_36455() != 270.0f) {
                        double Abstand0 = Math.abs(entity.method_36455());
                        double Abstand90 = Math.abs(entity.method_36455() - 90.0f);
                        double Abstand180 = Math.abs(entity.method_36455() - 180.0f);
                        double Abstand270 = Math.abs(entity.method_36455() - 270.0f);
                        if (Abstand0 <= Abstand90 && Abstand0 <= Abstand180 && Abstand0 <= Abstand270) {
                            if (entity.method_36455() < 0.0f) {
                                entity.method_36457(entity.method_36455() + rotateBy);
                            } else {
                                entity.method_36457(entity.method_36455() - rotateBy);
                            }
                        }
                        if (Abstand90 < Abstand0 && Abstand90 <= Abstand180 && Abstand90 <= Abstand270) {
                            if (entity.method_36455() - 90.0f < 0.0f) {
                                entity.method_36457(entity.method_36455() + rotateBy);
                            } else {
                                entity.method_36457(entity.method_36455() - rotateBy);
                            }
                        }
                        if (Abstand180 < Abstand90 && Abstand180 < Abstand0 && Abstand180 <= Abstand270) {
                            if (entity.method_36455() - 180.0f < 0.0f) {
                                entity.method_36457(entity.method_36455() + rotateBy);
                            } else {
                                entity.method_36457(entity.method_36455() - rotateBy);
                            }
                        }
                        if (Abstand270 < Abstand90 && Abstand270 < Abstand180 && Abstand270 < Abstand0) {
                            if (entity.method_36455() - 270.0f < 0.0f) {
                                entity.method_36457(entity.method_36455() + rotateBy);
                            } else {
                                entity.method_36457(entity.method_36455() - rotateBy);
                            }
                        }
                    }
                }
            } else if (!(entity == null || Double.isNaN(entity.method_23317()) || Double.isNaN(entity.method_23318()) || Double.isNaN(entity.method_23321()) || entity.method_37908() == null)) {
                if (entity.method_24828()) {
                    if (!flag) {
                        entity.method_36457(0.0f);
                    }
                } else {
                    rotateBy *= 2.0f;
                    class_3611 fluid = CommonPhysic.getFluid(entity);
                    if (fluid != null) {
                        rotateBy /= 1.0f + CommonPhysic.getViscosity(fluid, entity.method_37908());
                    }
                    entity.method_36457(entity.method_36455() + rotateBy);
                }
            }
            if (flag) {
                pose.method_22904(0.0, -0.2, -0.08);
            } else if (ItemPhysic.CONFIG.rendering.blockRequireOffset.is(entity.method_37908().method_8320(entity.method_24515())) || ItemPhysic.CONFIG.rendering.blockBelowRequireOffset.is(entity.method_37908().method_8320(entity.method_24515().method_10074()))) {
                pose.method_22904(0.0, 0.0, -0.14 - (double)entity.field_7203 * 0.007957747154594767);
            } else {
                pose.method_22904(0.0, 0.0, -0.04 - (double)entity.field_7203 * 0.007957747154594767);
            }
            double height = 0.2;
            if (flag) {
                pose.method_22904(0.0, height, 0.0);
            }
            pose.method_22907(class_7833.field_40716.rotation(entity.method_36455()));
            if (flag) {
                pose.method_22904(0.0, -height, 0.0);
            }
        }
        if (!flag) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f;
            float f8 = -0.0f * (float)(j - 1) * 0.5f;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f;
            pose.method_46416(f7, f8, f9);
        }
        for (int k = 0; k < j; ++k) {
            pose.method_22903();
            if (k > 0 && flag) {
                float f11 = (rand.method_43057() * 2.0f - 1.0f) * 0.15f;
                float f13 = (rand.method_43057() * 2.0f - 1.0f) * 0.15f;
                float f10 = (rand.method_43057() * 2.0f - 1.0f) * 0.15f;
                pose.method_46416(f11, f13, f10);
            }
            itemRenderer.method_23179(itemstack, class_811.field_4318, false, pose, buffer, packedLight, class_4608.field_21444, bakedmodel);
            pose.method_22909();
            if (flag) continue;
            pose.method_22904(0.0, 0.0, 0.09375);
        }
        pose.method_22909();
        return true;
    }

    public static int getModelCount(class_1799 stack) {
        if (stack.method_7947() > 48) {
            return 5;
        }
        if (stack.method_7947() > 32) {
            return 4;
        }
        if (stack.method_7947() > 16) {
            return 3;
        }
        if (stack.method_7947() > 1) {
            return 2;
        }
        return 1;
    }

    public static boolean onPlayerInteractClient(class_1937 level, class_1657 player, boolean rightClick) {
        class_239 result = ItemPhysicClient.getEntityItem((class_1657)ItemPhysicClient.mc.field_1724);
        if (result != null && result.method_17783() == class_239.class_240.field_1331) {
            class_1542 entity = (class_1542)((class_3966)result).method_17782();
            if (level.field_9236 && entity != null) {
                player.method_6104(class_1268.field_5808);
                ItemPhysic.NETWORK.sendToServer((CreativePacket)new PickupPacket(entity.method_5667(), rightClick));
                return true;
            }
        }
        return false;
    }

    public static boolean onPlayerInteract(class_1657 player) {
        if (ItemPhysic.CONFIG.pickup.customPickup) {
            if (!PICKUP.method_1415()) {
                return false;
            }
            return ItemPhysicClient.onPlayerInteractClient(player.method_37908(), player, true);
        }
        return false;
    }

    public static class_239 getEntityItem(class_1657 player) {
        double distance = CommonPhysic.getReachDistance(player);
        float partialTicks = mc.method_60646().method_60637(false);
        class_243 position = player.method_5836(partialTicks);
        class_243 view = player.method_5828(partialTicks);
        if (ItemPhysicClient.mc.field_1765 != null && ItemPhysicClient.mc.field_1765.method_17783() != class_239.class_240.field_1333) {
            distance = Math.min(ItemPhysicClient.mc.field_1765.method_17784().method_1022(position), distance);
        }
        return CommonPhysic.getEntityItem(player, position, position.method_1031(view.field_1352 * distance, view.field_1351 * distance, view.field_1350 * distance));
    }
}

