/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.server.ItemEntityExtender;
import team.creative.itemphysic.server.ItemPhysicServer;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin
extends class_1297
implements ItemEntityExtender {
    @Shadow
    public int field_7201;
    @Unique
    private boolean swim;
    @Unique
    private boolean burn;

    private ItemEntityMixin(class_1299<?> p_19870_, class_1937 p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, cancellable=true)
    public void hurtInject(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callback) {
        if (!ItemPhysicServer.hurt((class_1542)this, source, amount)) {
            callback.setReturnValue((Object)false);
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        return ItemPhysicServer.interact((class_1542)this, player, hand);
    }

    protected void method_5623(double height, boolean fall, class_2680 state, class_2338 pos) {
        ItemPhysicServer.checkFallDamage((class_1542)this, height, fall, state, pos);
        super.method_5623(height, fall, state, pos);
    }

    public boolean method_5692(class_6862<class_3611> fluid, double p_204033_) {
        return ItemPhysicServer.updateFluidHeightAndDoFluidPushing((class_1542)this, fluid, p_204033_);
    }

    @Inject(method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void playerTouchInject(class_1657 player, CallbackInfo info) {
        if (ItemPhysicServer.playerTouch((class_1542)this, player)) {
            info.cancel();
        }
    }

    @Inject(method={"fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void fireImmuneInject(CallbackInfoReturnable<Boolean> info) {
        if (ItemPhysicServer.fireImmune((class_1542)this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInWater()Z")}, require=1)
    public void updatePre(CallbackInfo info) {
        ItemPhysicServer.updatePre((class_1542)this, this.field_5974);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInWater()Z"), require=1)
    public boolean isInWaterRedirect(class_1542 entity) {
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInLava()Z"), require=1)
    public boolean isInLavaRedirect(class_1542 entity) {
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;applyGravity()V"), require=1)
    public void isNoGravityRedirect(class_1542 entity) {
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=0)}, require=1)
    public void update(CallbackInfo info) {
        ItemPhysicServer.update((class_1542)this);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"), require=2)
    public void setDeltaMovementRedirect(class_1542 entity, class_243 vec) {
    }

    @Inject(method={"onSyncedDataUpdated(Lnet/minecraft/network/syncher/EntityDataAccessor;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;setEntityRepresentation(Lnet/minecraft/world/entity/Entity;)V")}, require=1)
    private void onSyncedDataUpdated(class_2940<?> accessor, CallbackInfo callback) {
        this.swim = ItemPhysic.CONFIG.general.swimmingItems.canPass(((class_1542)this).method_6983());
        this.burn = ItemPhysic.CONFIG.general.burningItems.canPass(((class_1542)this).method_6983());
    }

    @Override
    public boolean canBurn() {
        return this.burn;
    }

    @Override
    public boolean canSwim() {
        return this.swim;
    }
}

