/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.enhancedgroups.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.OptionalArgument;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.enhancedgroups.EnhancedGroups;
import de.maxhenkel.enhancedgroups.config.PersistentGroup;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

@RequiresPermission(value="enhancedgroups.autojoingroup")
@Command(value={"autojoingroup"})
public class AutoJoinGroupCommands {
    public static final String AUTOJOINGROUP_COMMAND = "autojoingroup";

    @Command(value={"set"})
    public int set(CommandContext<class_2168> context, @Name(value="group_name") String groupName, @OptionalArgument @Name(value="password") String password) throws CommandSyntaxException {
        PersistentGroup persistentGroup = EnhancedGroups.PERSISTENT_GROUP_STORE.getGroup(groupName);
        if (persistentGroup == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Group not found or not persistent"));
            return 0;
        }
        return AutoJoinGroupCommands.autoJoin(context, persistentGroup.getId(), password);
    }

    @Command(value={"set"})
    public int set(CommandContext<class_2168> context, @Name(value="id") UUID groupId, @OptionalArgument @Name(value="password") String password) throws CommandSyntaxException {
        return AutoJoinGroupCommands.autoJoin(context, groupId, password);
    }

    @Command(value={"remove"})
    public int remove(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        EnhancedGroups.AUTO_JOIN_GROUP_STORE.removePlayerGroup(player.method_5667());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Auto join successfully removed"), false);
        return 1;
    }

    public static int autoJoin(CommandContext<class_2168> context, UUID groupId, @Nullable String password) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PersistentGroup group = EnhancedGroups.PERSISTENT_GROUP_STORE.getGroup(groupId);
        if (group == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Group not found or not persistent"));
            return 0;
        }
        if (!(group.getPassword() == null || password != null && password.equals(group.getPassword()))) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Wrong password"));
            return 0;
        }
        EnhancedGroups.AUTO_JOIN_GROUP_STORE.setPlayerGroup(player.method_5667(), group.getId());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"You will now automatically connect to group '%s' when joining".formatted(group.getName())), false);
        if (EnhancedGroups.AUTO_JOIN_GROUP_STORE.getGlobalGroupForced()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Note: Global auto join is currently enforced, meaning that your custom auto join won't have any effect"));
        }
        return 1;
    }
}

