/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.enhancedgroups.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.OptionalArgument;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.enhancedgroups.EnhancedGroups;
import de.maxhenkel.enhancedgroups.EnhancedGroupsVoicechatPlugin;
import de.maxhenkel.enhancedgroups.config.PersistentGroup;
import de.maxhenkel.voicechat.api.Group;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;

@RequiresPermission(value="enhancedgroups.persistentgroup")
@Command(value={"persistentgroup"})
public class PersistentGroupCommands {
    public static final String PERSISTENTGROUP_COMMAND = "persistentgroup";

    @Command(value={"add"})
    public int add(CommandContext<class_2168> context, @Name(value="name") String name, @Name(value="type") Optional<Group.Type> groupType, @Name(value="hidden") Optional<Boolean> hidden, @OptionalArgument @Name(value="password") String password) {
        if (name.isBlank()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Name cannot be blank"));
            return 1;
        }
        if (EnhancedGroupsVoicechatPlugin.SERVER_API == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Voice chat not connected"));
            return 1;
        }
        Group.Type type = groupType.orElse(Group.Type.NORMAL);
        Group vcGroup = EnhancedGroupsVoicechatPlugin.SERVER_API.groupBuilder().setPersistent(true).setName(name).setPassword(password).setType(type).setHidden(hidden.orElse(false).booleanValue()).build();
        PersistentGroup persistentGroup = new PersistentGroup(name, password, PersistentGroup.Type.fromGroupType(type), hidden.orElse(false));
        EnhancedGroups.PERSISTENT_GROUP_STORE.addGroup(persistentGroup);
        EnhancedGroups.PERSISTENT_GROUP_STORE.addCached(vcGroup.getId(), persistentGroup);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Successfully created persistent group " + name)), false);
        return 1;
    }

    @Command(value={"remove"})
    public int remove(CommandContext<class_2168> context, @Name(value="name") String name) {
        PersistentGroup group = EnhancedGroups.PERSISTENT_GROUP_STORE.getGroup(name);
        if (group == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Group not found or not persistent"));
            return 0;
        }
        return PersistentGroupCommands.removePersistentGroup(context, group);
    }

    @Command(value={"remove"})
    public int remove(CommandContext<class_2168> context, @Name(value="id") UUID id) {
        PersistentGroup group = EnhancedGroups.PERSISTENT_GROUP_STORE.getGroup(id);
        if (group == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Group not found or not persistent"));
            return 0;
        }
        return PersistentGroupCommands.removePersistentGroup(context, group);
    }

    public static int removePersistentGroup(CommandContext<class_2168> commandSource, PersistentGroup persistentGroup) {
        if (EnhancedGroupsVoicechatPlugin.SERVER_API == null) {
            ((class_2168)commandSource.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Voice chat not connected"));
            return 0;
        }
        UUID voicechatId = EnhancedGroups.PERSISTENT_GROUP_STORE.getVoicechatId(persistentGroup.getId());
        if (voicechatId == null) {
            ((class_2168)commandSource.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Group not found or not persistent"));
            return 0;
        }
        Group group = EnhancedGroupsVoicechatPlugin.SERVER_API.getGroup(voicechatId);
        if (group == null) {
            ((class_2168)commandSource.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Group not found"));
            return 0;
        }
        boolean removed = EnhancedGroupsVoicechatPlugin.SERVER_API.removeGroup(voicechatId);
        if (removed) {
            EnhancedGroups.PERSISTENT_GROUP_STORE.removeGroup(persistentGroup);
            ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43470((String)"Removed group %s".formatted(group.getName())), false);
            return 1;
        }
        ((class_2168)commandSource.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Could not remove group %s".formatted(group.getName())));
        return 0;
    }

    @Command(value={"list"})
    public int list(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (EnhancedGroupsVoicechatPlugin.SERVER_API == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Voice chat not connected"));
            return 1;
        }
        List<PersistentGroup> groups = EnhancedGroups.PERSISTENT_GROUP_STORE.getGroups();
        if (groups.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"There are no persistent groups"), false);
        }
        for (PersistentGroup group : EnhancedGroups.PERSISTENT_GROUP_STORE.getGroups()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)group.getName()).method_27693(" ").method_10852((class_2561)class_2564.method_10885((class_2561)class_2561.method_43470((String)"Remove")).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/persistentgroup remove " + String.valueOf(group.getId()))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to remove group"))).method_27706(class_124.field_1060))).method_27693(" ").method_10852((class_2561)class_2564.method_10885((class_2561)class_2561.method_43470((String)"Auto Join")).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/autojoingroup set " + String.valueOf(group.getId()))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to automatically connect to the group when joining"))).method_27706(class_124.field_1060))).method_27693(" ").method_10852((class_2561)class_2564.method_10885((class_2561)class_2561.method_43470((String)"Copy ID")).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, group.getId().toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to copy group ID"))).method_27706(class_124.field_1060))), false);
        }
        return groups.size();
    }
}

