/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.enhancedgroups.config;

import de.maxhenkel.voicechat.api.Group;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

public class PersistentGroup {
    private final String name;
    @Nullable
    private final String password;
    private final Type type;
    private final boolean hidden;
    @Nullable
    private UUID id;

    public PersistentGroup(String name, @Nullable String password, Type type, boolean hidden, @Nullable UUID id) {
        this.name = name;
        this.password = password;
        this.type = type;
        this.hidden = hidden;
        this.id = Objects.requireNonNullElseGet(id, UUID::randomUUID);
    }

    public PersistentGroup(String name, @Nullable String password, Type type, boolean hidden) {
        this(name, password, type, hidden, null);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public static enum Type {
        NORMAL(Group.Type.NORMAL),
        OPEN(Group.Type.OPEN),
        ISOLATED(Group.Type.ISOLATED);

        private Group.Type type;

        private Type(Group.Type type) {
            this.type = type;
        }

        public Group.Type getType() {
            return this.type;
        }

        public static Type fromGroupType(Group.Type type) {
            for (Type t : Type.values()) {
                if (t.getType() != type) continue;
                return t;
            }
            return NORMAL;
        }
    }
}

