/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import eu.pb4.cctpatch.impl.config.PatchConfig;
import eu.pb4.cctpatch.impl.poly.PolymerSetup;
import eu.pb4.cctpatch.impl.poly.font.Fonts;
import eu.pb4.cctpatch.impl.poly.model.TurtleModel;
import eu.pb4.cctpatch.impl.poly.textures.GuiTextures;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_5253;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputerCraftPolymerPatch
implements ModInitializer {
    public static final String MOD_ID = "cc-tweaked-polymer-patch";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cc-tweaked-polymer-patch");
    public static MinecraftServer server;

    public void onInitialize() {
        Fonts.TERMINAL_FONT.hashCode();
        GuiTextures.ADVANCED_COMPUTER.hashCode();
        TurtleModel.CRAFTING_MODEL.left();
        PatchConfig.instance.hashCode();
        PolymerResourcePackUtils.addModAssets((String)"computercraft");
        PolymerResourcePackUtils.addModAssets((String)MOD_ID);
        ServerLifecycleEvents.SERVER_STARTING.register(server1 -> {
            server = server1;
            for (TurtleOverlay x : server1.method_30611().method_30530(TurtleOverlay.REGISTRY)) {
                TurtleModel.registerOverlay(x.model());
            }
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server1 -> {
            server = null;
        });
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((a, b, c) -> PatchConfig.loadOrCreateConfig());
        TurtleModel.registerOverlay(TurtleModel.ELF_OVERLAY_MODEL);
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(builder -> builder.addWriteConverter((path, data) -> {
            try {
                int id;
                if (path.startsWith("assets/computercraft/models/block/turtle_colour.json")) {
                    JsonObject json = JsonParser.parseString((String)new String((byte[])data, StandardCharsets.UTF_8)).getAsJsonObject();
                    JsonArray elements = json.getAsJsonArray("elements");
                    for (JsonElement el : elements) {
                        JsonObject faces = el.getAsJsonObject().getAsJsonObject("faces");
                        for (String key : faces.keySet()) {
                            JsonObject val = faces.get(key).getAsJsonObject();
                            if (val.get("tintindex") == null) continue;
                            val.addProperty("tintindex", (Number)1);
                        }
                    }
                    return json.toString().getBytes(StandardCharsets.UTF_8);
                }
                if (path.startsWith("assets/computercraft/models/") && path.endsWith(".json")) {
                    JsonObject json = JsonParser.parseString((String)new String((byte[])data, StandardCharsets.UTF_8)).getAsJsonObject();
                    if (json.get("loader") != null && json.get("model") != null) {
                        JsonObject obj = new JsonObject();
                        obj.add("parent", json.get("model"));
                        return obj.toString().getBytes(StandardCharsets.UTF_8);
                    }
                } else if (path.startsWith("assets/computercraft/textures/block/monitor_") && path.endsWith(".png") && (id = Integer.parseInt(path.split("[_.]")[2])) > 15 && id < 32) {
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream((byte[])data));
                    for (int x = 0; x < image.getWidth(); ++x) {
                        for (int y = 0; y < image.getHeight(); ++y) {
                            if (class_5253.class_5254.method_27762((int)image.getRGB(x, y)) != 0) continue;
                            image.setRGB(x, y, -15658735);
                        }
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)image, "png", out);
                    return out.toByteArray();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return data;
        }));
        PolymerSetup.setup();
    }
}

