/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.config;

import com.google.gson.annotations.SerializedName;
import eu.pb4.cctpatch.impl.ComputerCraftPolymerPatch;
import eu.pb4.cctpatch.impl.config.BaseGson;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.loader.api.FabricLoader;

public final class PatchConfig {
    public static PatchConfig instance = PatchConfig.loadOrCreateConfig();
    @SerializedName(value="display_pocket_computer_screen_in_hand")
    public boolean displayPocketComputerScreenInHand = true;

    public static PatchConfig loadOrCreateConfig() {
        try {
            Path configFile = FabricLoader.getInstance().getConfigDir().resolve("cc-tweaked-polymer-patch.json");
            PatchConfig config = Files.exists(configFile, new LinkOption[0]) ? (PatchConfig)BaseGson.GSON.fromJson(Files.readString(configFile, StandardCharsets.UTF_8), PatchConfig.class) : new PatchConfig();
            PatchConfig.saveConfig(config);
            instance = config;
            return instance;
        }
        catch (IOException exception) {
            ComputerCraftPolymerPatch.LOGGER.error("Something went wrong while reading the config!", (Throwable)exception);
            instance = new PatchConfig();
            return instance;
        }
    }

    public static void saveConfig(PatchConfig config) {
        Path configFile = FabricLoader.getInstance().getConfigDir().resolve("cc-tweaked-polymer-patch.json");
        try {
            Files.writeString(configFile, (CharSequence)BaseGson.GSON.toJson((Object)config), StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (Exception e) {
            ComputerCraftPolymerPatch.LOGGER.error("Something went wrong while saving the config!", (Throwable)e);
        }
    }
}

