/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly;

import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import eu.pb4.cctpatch.impl.config.PatchConfig;
import eu.pb4.cctpatch.impl.poly.TerminalRenderer;
import eu.pb4.cctpatch.impl.poly.ext.TerminalExt;
import eu.pb4.cctpatch.impl.poly.render.ImageView;
import eu.pb4.cctpatch.impl.poly.textures.ComputerTexture;
import eu.pb4.cctpatch.impl.poly.textures.GuiTextures;
import eu.pb4.cctpatch.impl.poly.textures.RepeatingCanvas;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.core.PlayerCanvas;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableObject;

public class PocketComputerRenderer {
    private final PocketServerComputer computer;
    private class_3222 player;
    private PlayerCanvas canvas;

    public PocketComputerRenderer(PocketServerComputer pocketServerComputer) {
        this.computer = pocketServerComputer;
    }

    public void onRemoved(class_1297 entity) {
        if (this.canvas != null) {
            this.canvas.destroy();
            this.canvas = null;
        }
        this.player = null;
    }

    public void tick(class_1297 entity) {
        class_3222 player;
        MutableObject mut = new MutableObject();
        if (PatchConfig.instance.displayPocketComputerScreenInHand && entity instanceof class_3222 && this.findStack(player = (class_3222)entity, (MutableObject<class_1799>)mut)) {
            if (this.canvas == null) {
                this.player = player;
                this.canvas = DrawableCanvas.create();
                this.drawInitial();
                this.canvas.addPlayer(player);
                int slot = mut.getValue() == player.method_6047() ? player.method_31548().field_7545 : 40;
                player.field_13987.method_14364((class_2596)new class_2653(-2, 0, slot, (class_1799)mut.getValue()));
            } else if (this.player != player) {
                this.canvas.removePlayer(this.player);
                this.canvas.addPlayer(player);
                this.player = player;
            }
            this.drawUpdate();
            this.canvas.sendUpdates();
        } else if (this.canvas != null) {
            this.canvas.destroy();
            this.canvas = null;
            this.player = null;
        }
    }

    private boolean findStack(class_3222 player, MutableObject<class_1799> mut) {
        if (player.method_6047().method_7909() instanceof PocketComputerItem && PocketComputerItem.getServerComputer((MinecraftServer)player.field_13995, (class_1799)player.method_6047()) == this.computer) {
            if (mut != null) {
                mut.setValue((Object)player.method_6047());
            }
            return true;
        }
        if (player.method_6079().method_7909() instanceof PocketComputerItem && PocketComputerItem.getServerComputer((MinecraftServer)player.field_13995, (class_1799)player.method_6079()) == this.computer) {
            if (mut != null) {
                mut.setValue((Object)player.method_6079());
            }
            return true;
        }
        return false;
    }

    private void drawInitial() {
        TerminalRenderer terminal = TerminalExt.of((ServerComputer)this.computer).getMiniRenderer();
        int termX = 64 - terminal.renderedWidth() / 2;
        int termY = 64 - terminal.renderedHeight() / 2;
        ComputerTexture compText = switch (this.computer.getFamily()) {
            default -> throw new MatchException(null, null);
            case ComputerFamily.NORMAL -> GuiTextures.COMPUTER;
            case ComputerFamily.ADVANCED -> GuiTextures.ADVANCED_COMPUTER;
            case ComputerFamily.COMMAND -> GuiTextures.COMMAND_COMPUTER;
        };
        new ImageView(termX, termY - compText.top().getHeight(), new RepeatingCanvas((DrawableCanvas)compText.top(), terminal.renderedWidth(), compText.top().getHeight())).render((DrawableCanvas)this.canvas, 0L, 0, 0);
        new ImageView(termX, termY + terminal.renderedHeight(), new RepeatingCanvas((DrawableCanvas)compText.bottom(), terminal.renderedWidth(), compText.bottom().getHeight())).render((DrawableCanvas)this.canvas, 0L, 0, 0);
        new ImageView(termX - compText.leftSide().getWidth(), termY, new RepeatingCanvas((DrawableCanvas)compText.leftSide(), compText.leftSide().getWidth(), terminal.renderedHeight())).render((DrawableCanvas)this.canvas, 0L, 0, 0);
        new ImageView(termX + terminal.renderedWidth(), termY, new RepeatingCanvas((DrawableCanvas)compText.rightSide(), compText.rightSide().getWidth(), terminal.renderedHeight())).render((DrawableCanvas)this.canvas, 0L, 0, 0);
        new ImageView(termX - compText.leftTop().getWidth(), termY - compText.leftTop().getHeight(), (DrawableCanvas)compText.leftTop()).render((DrawableCanvas)this.canvas, 0L, 0, 0);
        new ImageView(termX + terminal.renderedWidth(), termY - compText.rightTop().getHeight(), (DrawableCanvas)compText.rightTop()).render((DrawableCanvas)this.canvas, 0L, 0, 0);
        new ImageView(termX - compText.leftBottom().getWidth(), termY + terminal.renderedHeight(), (DrawableCanvas)compText.leftBottom()).render((DrawableCanvas)this.canvas, 0L, 0, 0);
        new ImageView(termX + terminal.renderedWidth(), termY + terminal.renderedHeight(), (DrawableCanvas)compText.rightBottom()).render((DrawableCanvas)this.canvas, 0L, 0, 0);
    }

    private void drawUpdate() {
        DrawableCanvas image = TerminalExt.of((ServerComputer)this.computer).getMiniRenderer().getImage(this.player.method_37908().method_8510());
        CanvasUtils.draw((DrawableCanvas)this.canvas, (int)((128 - image.getWidth()) / 2), (int)((128 - image.getHeight()) / 2), (DrawableCanvas)image);
    }

    public void updateValues(class_1297 entity) {
        class_3222 player;
        if (!(PatchConfig.instance.displayPocketComputerScreenInHand && entity instanceof class_3222 && this.findStack(player = (class_3222)entity, null) || this.canvas == null)) {
            this.canvas.destroy();
            this.canvas = null;
            this.player = null;
        }
    }

    public int id() {
        return this.canvas != null ? this.canvas.getId() : 0;
    }
}

