/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly;

import dan200.computercraft.core.terminal.Palette;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.core.util.Colour;
import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import net.minecraft.class_5253;

public class TerminalRenderer {
    private final int fontWidth;
    private final int fontHeight;
    private final Terminal terminal;
    private final int size;
    private final CanvasFont font;
    private long lastCanvasUpdate = -1L;
    private CanvasImage canvasImage;

    public TerminalRenderer(Terminal terminal, CanvasFont font, int fontWidth, int fontHeight, int size) {
        this.fontWidth = fontWidth;
        this.fontHeight = fontHeight;
        this.font = font;
        this.size = size;
        this.terminal = terminal;
    }

    public void init(int width, int height) {
        this.canvasImage = new CanvasImage(width * this.fontWidth, height * this.fontHeight);
        this.lastCanvasUpdate = -1L;
    }

    public void setColor(boolean colour) {
    }

    public DrawableCanvas getImage(long tick) {
        if (this.lastCanvasUpdate < tick) {
            CanvasUtils.clear((DrawableCanvas)this.canvasImage, (CanvasColor)CanvasColor.BLACK_LOWEST);
            Palette palette = this.terminal.getPalette();
            for (int y = 0; y < this.terminal.getHeight(); ++y) {
                TextBuffer line = this.terminal.getLine(y);
                TextBuffer bgColor = this.terminal.getBackgroundColourLine(y);
                TextBuffer color = this.terminal.getTextColourLine(y);
                for (int x = 0; x < this.terminal.getWidth(); ++x) {
                    CanvasUtils.fill((DrawableCanvas)this.canvasImage, (int)(x * this.fontWidth), (int)(y * this.fontHeight), (int)(x * this.fontWidth + this.fontWidth), (int)(y * this.fontHeight + this.fontHeight), (CanvasColor)TerminalRenderer.getColor(bgColor.charAt(x), Colour.BLACK, palette));
                    this.font.drawGlyph((DrawableCanvas)this.canvasImage, (int)line.charAt(x), x * this.fontWidth, y * this.fontHeight, (double)this.size, 0, TerminalRenderer.getColor(color.charAt(x), Colour.BLACK, palette));
                }
            }
            if (this.terminal.getCursorBlink() && tick % 20L > 10L) {
                CanvasUtils.fill((DrawableCanvas)this.canvasImage, (int)(this.terminal.getCursorX() * this.fontWidth), (int)(this.terminal.getCursorY() * this.fontHeight), (int)(this.terminal.getCursorX() * this.fontWidth + this.fontWidth), (int)(this.terminal.getCursorY() * this.fontHeight + this.fontHeight), (CanvasColor)CanvasColor.WHITE_GRAY_HIGH);
            }
            this.lastCanvasUpdate = tick;
        }
        return this.canvasImage;
    }

    public static CanvasColor getColor(char c, Colour def, Palette palette) {
        byte[] x = palette.getRenderColours(15 - Terminal.getColour((char)c, (Colour)def));
        return CanvasUtils.findClosestColor((int)class_5253.class_5254.method_27764((int)0, (int)Byte.toUnsignedInt(x[0]), (int)Byte.toUnsignedInt(x[1]), (int)Byte.toUnsignedInt(x[2])));
    }

    public int renderedWidth() {
        return this.canvasImage.getWidth();
    }

    public int renderedHeight() {
        return this.canvasImage.getHeight();
    }

    public int fontHeight() {
        return this.fontHeight;
    }

    public int fontWidth() {
        return this.fontWidth;
    }
}

