/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly.font;

import eu.pb4.mapcanvas.api.font.BitmapFontBuilder;
import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.api.font.DefaultFonts;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class Fonts {
    public static final int FONT_HEIGHT = 9;
    public static final int FONT_WIDTH = 6;
    public static final int MINI_FONT_HEIGHT = 6;
    public static final int MINI_FONT_WIDTH = 4;
    public static final CanvasFont MINI_TERMINAL_FONT;
    public static final CanvasFont TERMINAL_FONT;
    public static final CanvasFont TERMINAL_BACKGROUND_FONT;

    private static void buildFontCC(Path texturePath, BitmapFontBuilder builder, BitmapFontBuilder builderBack, int fontHeight, int fontWidth) throws IOException {
        BufferedImage image = ImageIO.read(Files.newInputStream(texturePath, new OpenOption[0]));
        for (int i = 0; i < 256; ++i) {
            int column = i % 16;
            int row = i / 16;
            int xStart = column * (fontWidth + 2);
            int yStart = row * (fontHeight + 2);
            BitmapFontBuilder.Glyph glyph = BitmapFontBuilder.Glyph.of((int)fontWidth, (int)fontHeight).logicalHeight(fontHeight).charWidth(fontWidth);
            BitmapFontBuilder.Glyph glyphBack = BitmapFontBuilder.Glyph.of((int)fontWidth, (int)fontHeight).logicalHeight(fontHeight).charWidth(fontWidth);
            for (int x = 0; x < fontWidth; ++x) {
                for (int y = 0; y < fontHeight; ++y) {
                    if (image.getRGB(xStart + x, yStart + y) != 0) {
                        glyph.set(x, y);
                    }
                    if (image.getRGB(xStart + x + 128, yStart + y) == 0) continue;
                    glyphBack.set(x, y);
                }
            }
            builder.put(i, glyph);
            builderBack.put(i, glyphBack);
        }
    }

    private static void buildFontZoo(Path texturePath, BitmapFontBuilder builder, int fontHeight, int fontWidth, byte[] set) throws IOException {
        BufferedImage image = ImageIO.read(Files.newInputStream(texturePath, new OpenOption[0]));
        for (int i = 0; i < 256; ++i) {
            int column = i % 32;
            int row = i / 32;
            int xStart = column * fontWidth;
            int yStart = row * fontHeight;
            BitmapFontBuilder.Glyph glyph = BitmapFontBuilder.Glyph.of((int)fontWidth, (int)fontHeight).logicalHeight(fontHeight).charWidth(fontWidth);
            for (int x = 0; x < fontWidth; ++x) {
                for (int y = 0; y < fontHeight; ++y) {
                    if (image.getRGB(xStart + x, yStart + y) != -1) continue;
                    glyph.set(x, y);
                }
            }
            builder.put(Byte.toUnsignedInt(set[i]), glyph);
        }
    }

    static {
        CanvasFont fontBack;
        CanvasFont font;
        CanvasFont fontSmall;
        Path texturePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("computercraft").get()).findPath("assets/computercraft/textures/gui/term_font.png").get();
        Path texturePathZoo = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("cc-tweaked-polymer-patch").get()).findPath("map/openzoo/4x6.png").get();
        BitmapFontBuilder.Glyph emptyGlyph = BitmapFontBuilder.Glyph.of((int)1, (int)1);
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            b[i] = (byte)i;
        }
        try {
            BitmapFontBuilder builderSmall = BitmapFontBuilder.create();
            BitmapFontBuilder builder = BitmapFontBuilder.create();
            BitmapFontBuilder builderBack = BitmapFontBuilder.create();
            Fonts.buildFontCC(texturePath, builder, builderBack, 9, 6);
            Fonts.buildFontZoo(texturePathZoo, builderSmall, 6, 4, b);
            fontSmall = builderSmall.defaultGlyph(emptyGlyph).build();
            font = builder.defaultGlyph(emptyGlyph).build();
            fontBack = builderBack.defaultGlyph(emptyGlyph).build();
        }
        catch (Throwable e) {
            e.printStackTrace();
            font = DefaultFonts.VANILLA;
            fontSmall = DefaultFonts.VANILLA;
            fontBack = BitmapFontBuilder.create().defaultGlyph(emptyGlyph).build();
        }
        TERMINAL_FONT = font;
        TERMINAL_BACKGROUND_FONT = fontBack;
        MINI_TERMINAL_FONT = fontSmall;
    }
}

