/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly.gui;

import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.computer.menu.ServerInputState;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import eu.pb4.cctpatch.impl.poly.TerminalRenderer;
import eu.pb4.cctpatch.impl.poly.ext.ServerInputStateExt;
import eu.pb4.cctpatch.impl.poly.ext.TerminalExt;
import eu.pb4.cctpatch.impl.poly.gui.MapGui;
import eu.pb4.cctpatch.impl.poly.render.ImageButton;
import eu.pb4.cctpatch.impl.poly.render.ImageView;
import eu.pb4.cctpatch.impl.poly.render.KeyboardView;
import eu.pb4.cctpatch.impl.poly.render.TerminalView;
import eu.pb4.cctpatch.impl.poly.render.TurtleInventoryView;
import eu.pb4.cctpatch.impl.poly.textures.ComputerTexture;
import eu.pb4.cctpatch.impl.poly.textures.GuiTextures;
import eu.pb4.cctpatch.impl.poly.textures.RepeatingCanvas;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.sgui.api.gui.HotbarGui;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2846;
import net.minecraft.class_3222;
import net.minecraft.class_7439;
import net.minecraft.class_7597;
import org.jetbrains.annotations.Nullable;

public final class ComputerGui
extends MapGui {
    private static final class_2596<class_2602> ADDITIONAL_SUGGESTIONS_PACKET;
    private static final class_2596<class_2602> ADDITIONAL_SUGGESTIONS_REMOVE_PACKET;
    private static final Map<String, BiConsumer<ComputerGui, String>> ACTIONS;
    public final ImageButton closeButton;
    public final ImageButton terminateButton;
    public final ServerInputState<AbstractComputerMenu> input;
    public final KeyboardView keyboard;
    public final AbstractComputerMenu wrapped;
    private final ServerComputer computer;
    public String currentInput = "";
    public IntSet keysToReleaseNextTick = new IntArraySet();

    public ComputerGui(class_3222 player, AbstractComputerMenu menu) {
        super(player);
        ComputerTexture compText;
        this.wrapped = menu;
        this.input = (ServerInputState)this.wrapped.getInput();
        this.computer = this.wrapped.getComputer();
        TerminalRenderer terminal = TerminalExt.of(this.wrapped.getComputer()).getRenderer();
        int centerX = this.canvas.getWidth() / 2;
        int centerY = this.canvas.getHeight() / 2 - 48;
        boolean turtle = this.wrapped instanceof TurtleMenu;
        int termX = centerX - terminal.renderedWidth() / 2;
        int termY = centerY - terminal.renderedHeight() / 2;
        if (turtle) {
            termX -= 36;
        }
        TerminalView terminalView = new TerminalView(termX, termY, terminal, (ServerInputHandler)this.input);
        terminalView.zIndex = 2;
        this.renderer.add(terminalView);
        switch (this.computer.getFamily()) {
            default: {
                throw new MatchException(null, null);
            }
            case NORMAL: {
                ComputerTexture computerTexture = GuiTextures.COMPUTER;
                break;
            }
            case ADVANCED: {
                ComputerTexture computerTexture = GuiTextures.ADVANCED_COMPUTER;
                break;
            }
            case COMMAND: {
                ComputerTexture computerTexture = compText = GuiTextures.COMMAND_COMPUTER;
            }
        }
        if (turtle) {
            int xi = termX + terminal.renderedWidth() + 32;
            int yi = termY - 28;
            TurtleInventoryView inv = new TurtleInventoryView(xi, yi, this, (TurtleMenu)this.wrapped);
            this.renderer.add(inv);
            this.renderer.add(new ImageView(xi, yi - compText.top().getHeight(), new RepeatingCanvas((DrawableCanvas)compText.top(), inv.width(), compText.top().getHeight())));
            this.renderer.add(new ImageView(xi, yi + inv.height(), new RepeatingCanvas((DrawableCanvas)compText.bottom(), inv.width(), compText.bottom().getHeight())));
            this.renderer.add(new ImageView(xi - compText.leftSide().getWidth(), yi, new RepeatingCanvas((DrawableCanvas)compText.leftSide(), compText.leftSide().getWidth(), inv.height())));
            this.renderer.add(new ImageView(xi + inv.width(), yi, new RepeatingCanvas((DrawableCanvas)compText.rightSide(), compText.rightSide().getWidth(), inv.height())));
            this.renderer.add(new ImageView(xi - compText.leftTop().getWidth(), yi - compText.leftTop().getHeight(), (DrawableCanvas)compText.leftTop()));
            this.renderer.add(new ImageView(xi + inv.width(), yi - compText.rightTop().getHeight(), (DrawableCanvas)compText.rightTop()));
            this.renderer.add(new ImageView(xi - compText.leftBottom().getWidth(), yi + inv.height(), (DrawableCanvas)compText.leftBottom()));
            this.renderer.add(new ImageView(xi + inv.width(), yi + inv.height(), (DrawableCanvas)compText.rightBottom()));
        }
        int sideX = termX - compText.sideButtonPlateSide().getWidth() - compText.leftSide().getWidth() + 3;
        ImageView sideTop = new ImageView(sideX - 3, termY + 8, (DrawableCanvas)compText.sideButtonPlateTop());
        sideTop.zIndex = -1;
        this.renderer.add(sideTop);
        int sideY = termY + 8 + compText.sideButtonPlateTop().getHeight();
        int size = 0;
        this.closeButton = new ImageButton(sideX, sideY + size, GuiTextures.SHUTDOWN_ICON, (x, y, t) -> {
            if (this.wrapped.isOn()) {
                this.wrapped.getComputer().shutdown();
            } else {
                this.wrapped.getComputer().turnOn();
            }
        });
        this.closeButton.zIndex = 2;
        this.renderer.add(this.closeButton);
        this.terminateButton = new ImageButton(sideX, sideY + (size += this.closeButton.height() + 2), GuiTextures.TERMINATE, (x, y, t) -> this.wrapped.getComputer().queueEvent("terminate"));
        this.terminateButton.zIndex = 2;
        this.renderer.add(this.terminateButton);
        size += this.terminateButton.height() + 2;
        ImageView side = new ImageView(sideX - 3, sideY, new RepeatingCanvas((DrawableCanvas)compText.sideButtonPlateSide(), compText.sideButtonPlateSide().getWidth(), size -= 2));
        side.zIndex = -1;
        this.renderer.add(side);
        ImageView sideBottom = new ImageView(sideX - 3, sideY + size, (DrawableCanvas)compText.sideButtonPlateBottom());
        sideBottom.zIndex = -1;
        this.renderer.add(sideBottom);
        this.renderer.add(new ImageView(termX, termY - compText.top().getHeight(), new RepeatingCanvas((DrawableCanvas)compText.top(), terminal.renderedWidth(), compText.top().getHeight())));
        this.renderer.add(new ImageView(termX, termY + terminal.renderedHeight(), new RepeatingCanvas((DrawableCanvas)compText.bottom(), terminal.renderedWidth(), compText.bottom().getHeight())));
        this.renderer.add(new ImageView(termX - compText.leftSide().getWidth(), termY, new RepeatingCanvas((DrawableCanvas)compText.leftSide(), compText.leftSide().getWidth(), terminal.renderedHeight())));
        this.renderer.add(new ImageView(termX + terminal.renderedWidth(), termY, new RepeatingCanvas((DrawableCanvas)compText.rightSide(), compText.rightSide().getWidth(), terminal.renderedHeight())));
        this.renderer.add(new ImageView(termX - compText.leftTop().getWidth(), termY - compText.leftTop().getHeight(), (DrawableCanvas)compText.leftTop()));
        this.renderer.add(new ImageView(termX + terminal.renderedWidth(), termY - compText.rightTop().getHeight(), (DrawableCanvas)compText.rightTop()));
        this.renderer.add(new ImageView(termX - compText.leftBottom().getWidth(), termY + terminal.renderedHeight(), (DrawableCanvas)compText.leftBottom()));
        this.renderer.add(new ImageView(termX + terminal.renderedWidth(), termY + terminal.renderedHeight(), (DrawableCanvas)compText.rightBottom()));
        this.renderer.add(terminalView);
        this.keyboard = new KeyboardView(centerX - KeyboardView.KEYBOARD_WIDTH / 2, terminalView.y + terminalView.height() + 16, this);
        this.renderer.add(this.keyboard);
        this.render();
        player.field_13987.method_14364(ADDITIONAL_SUGGESTIONS_PACKET);
        for (int i = 0; i < 9; ++i) {
            this.setSlot(i, new class_1799((class_1935)class_1802.field_8600));
        }
        this.open();
    }

    public static void open(class_3222 player, AbstractComputerMenu menu) {
        if (player.method_24828()) {
            new ComputerGui(player, menu);
        }
    }

    private static BiConsumer<ComputerGui, String> pressKey(int key) {
        return (gui, arg) -> {
            int i;
            try {
                i = Integer.parseInt(arg);
            }
            catch (Exception e) {
                i = 1;
            }
            for (int a = 0; a < i; ++a) {
                gui.input.keyDown(key, false);
            }
            gui.keysToReleaseNextTick.add(key);
        };
    }

    private static BiConsumer<ComputerGui, String> holdKey(int key) {
        return (gui, arg) -> {
            if (!ServerInputStateExt.of(gui.input).isKeyDown(key)) {
                gui.input.keyDown(key, true);
            } else {
                gui.input.keyUp(key);
            }
        };
    }

    @Override
    public void render() {
        this.closeButton.texture = this.computer.isOn() ? GuiTextures.SHUTDOWN_ACTIVE : GuiTextures.SHUTDOWN_ICON;
        super.render();
    }

    @Override
    public void onTick() {
        if (this.wrapped.method_7597((class_1657)this.player)) {
            this.render();
            super.onTick();
        } else {
            this.close();
        }
        for (Integer key : this.keysToReleaseNextTick) {
            this.input.keyUp(key.intValue());
        }
        this.keysToReleaseNextTick.clear();
    }

    @Override
    public void onClose() {
        this.player.field_13987.method_14364(ADDITIONAL_SUGGESTIONS_REMOVE_PACKET);
        super.onClose();
    }

    @Override
    public void onChatInput(String message) {
        if (message.startsWith(";")) {
            for (String line : message.substring(1).split(";")) {
                String[] args = line.split(" ", 2);
                BiConsumer<ComputerGui, String> action = ACTIONS.get(args[0]);
                if (action == null) continue;
                action.accept(this, args.length != 2 ? "" : args[1]);
            }
        } else {
            if (!message.startsWith("/")) {
                for (int character : message.codePoints().toArray()) {
                    if ((character < 32 || character > 126) && (character < 160 || character > 255)) continue;
                    this.input.queueEvent("char", new Object[]{Character.toString(character)});
                }
            }
            this.input.keyDown(257, false);
            this.keysToReleaseNextTick.add(257);
            this.currentInput = "";
        }
    }

    @Override
    public void onCommandInput(String command) {
        this.input.keyDown(257, false);
        this.keysToReleaseNextTick.add(257);
        this.currentInput = "";
    }

    @Override
    public void onCommandSuggestion(int id, String fullCommand) {
        String old = this.currentInput;
        StringBuilder commandBuilder = new StringBuilder();
        for (int character : fullCommand.substring(1).codePoints().toArray()) {
            if ((character < 32 || character > 126) && (character < 160 || character > 255)) continue;
            commandBuilder.append(Character.toChars(character));
        }
        String command = commandBuilder.toString();
        if (!old.equals(command)) {
            int i;
            for (i = 0; i < old.length() && command.length() > i && command.charAt(i) == old.charAt(i); ++i) {
            }
            ServerInputStateExt inputExt = ServerInputStateExt.of(this.input);
            for (int tmp = i; tmp < old.length(); ++tmp) {
                if (!this.keysToReleaseNextTick.contains(259) && !inputExt.isKeyDown(259)) {
                    this.input.keyDown(259, false);
                    this.keysToReleaseNextTick.add(259);
                    continue;
                }
                this.input.queueEvent("key", new Object[]{259, false});
            }
            while (i < command.length()) {
                this.pressButton(command.charAt(i));
                ++i;
            }
            this.currentInput = command;
        }
    }

    public void pressButton(char character) {
        if (character >= ' ' && character <= '~' || character >= '\u00a0' && character <= '\u00ff') {
            KeyboardView.Key key = (KeyboardView.Key)KeyboardView.CHAR_TO_KEY.get(character);
            if (key != null) {
                this.input.keyDown(key.key(), false);
                this.keysToReleaseNextTick.add(key.key());
            }
            if (key.upperCase() == character && key.lowerCase() != character && !this.keysToReleaseNextTick.contains(340) && !ServerInputStateExt.of(this.input).isKeyDown(340)) {
                this.input.keyDown(340, false);
                this.keysToReleaseNextTick.add(340);
            }
            this.input.queueEvent("char", new Object[]{Character.toString(character)});
        }
    }

    @Override
    public boolean onClickEntity(int entityId, HotbarGui.EntityInteraction type, boolean isSneaking, @Nullable class_243 interactionPos) {
        return super.onClickEntity(entityId, type, isSneaking, interactionPos);
    }

    @Override
    public void onPlayerAction(class_2846.class_2847 action, class_2350 direction, class_2338 pos) {
        if (action == class_2846.class_2847.field_12970) {
            this.close();
        }
    }

    static {
        ACTIONS = new HashMap<String, BiConsumer<ComputerGui, String>>();
        for (int i = 0; i < 12; ++i) {
            ACTIONS.put("f" + (i + 1), ComputerGui.pressKey(290 + i));
        }
        ACTIONS.put("enter", ComputerGui.pressKey(257));
        ACTIONS.put("backspace", ComputerGui.pressKey(259));
        ACTIONS.put("bsp", ComputerGui.pressKey(259));
        ACTIONS.put("back", ComputerGui.pressKey(259));
        ACTIONS.put("esc", ComputerGui.pressKey(256));
        ACTIONS.put("ctrl", ComputerGui.pressKey(341));
        ACTIONS.put("shift", ComputerGui.pressKey(340));
        ACTIONS.put("shift_hold", ComputerGui.holdKey(340));
        ACTIONS.put("tab", ComputerGui.pressKey(258));
        ACTIONS.put("up", ComputerGui.pressKey(265));
        ACTIONS.put("down", ComputerGui.pressKey(264));
        ACTIONS.put("left", ComputerGui.pressKey(263));
        ACTIONS.put("right", ComputerGui.pressKey(262));
        ACTIONS.put("close", (gui, arg) -> gui.close());
        ACTIONS.put("exit", (gui, arg) -> gui.close());
        ACTIONS.put("quit", (gui, arg) -> gui.close());
        ACTIONS.put("press", (gui, arg) -> {
            if (arg != null && !arg.isEmpty()) {
                String[] stringArray;
                char character = arg.charAt(0);
                if (arg.length() == 1) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = arg;
                } else {
                    stringArray = arg.split(" ", 2);
                }
                String[] args = stringArray;
                try {
                    if (args[0].length() > 1) {
                        character = (char)Integer.parseInt(arg);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                int count = 1;
                try {
                    count = Math.min(Integer.parseInt(args[1]), 255);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                for (int i = 0; i < count; ++i) {
                    gui.pressButton(character);
                }
            }
        });
        ACTIONS.put("moveview", (gui, arg) -> {
            try {
                String[] args = arg.split(" ");
                double z = args.length > 0 && !args[0].isEmpty() ? Math.min(Math.max(Double.parseDouble(args[0]), 1.0), 8.0) : 1.0;
                double x = args.length > 1 && !args[1].isEmpty() ? Math.min(Math.max(Double.parseDouble(args[1]), -8.0), 8.0) : 0.0;
                gui.setDistance(new class_243(x, 0.0, z));
            }
            catch (Exception e) {
                gui.player.field_13987.method_14364((class_2596)new class_7439((class_2561)class_2561.method_43473(), true));
            }
        });
        ACTIONS.put("view", ACTIONS.get("moveview"));
        List list = ACTIONS.keySet().stream().map(x -> ";" + x).collect(Collectors.toList());
        ADDITIONAL_SUGGESTIONS_PACKET = new class_7597(class_7597.class_7598.field_39801, list);
        ADDITIONAL_SUGGESTIONS_REMOVE_PACKET = new class_7597(class_7597.class_7598.field_39802, list);
    }
}

