/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly.gui;

import com.google.common.base.Predicates;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import eu.pb4.cctpatch.impl.poly.render.CanvasRenderer;
import eu.pb4.cctpatch.impl.poly.render.ImageButton;
import eu.pb4.cctpatch.impl.poly.render.ScreenElement;
import eu.pb4.cctpatch.impl.poly.textures.GuiTextures;
import eu.pb4.cctpatch.mixin.ServerPlayNetworkHandlerAccessor;
import eu.pb4.mapcanvas.api.core.CanvasIcon;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import eu.pb4.mapcanvas.api.core.CombinedPlayerCanvas;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.core.PlayerCanvas;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import eu.pb4.mapcanvas.api.utils.VirtualDisplay;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.BlockDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.SimpleEntityElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import eu.pb4.sgui.api.gui.HotbarGui;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_21;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2641;
import net.minecraft.class_2668;
import net.minecraft.class_2684;
import net.minecraft.class_2708;
import net.minecraft.class_2709;
import net.minecraft.class_2734;
import net.minecraft.class_2739;
import net.minecraft.class_2767;
import net.minecraft.class_2846;
import net.minecraft.class_2848;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_7439;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MapGui
extends HotbarGui {
    private static final class_2960 DISTANCE_STORAGE_ID = class_2960.method_60655((String)"cct-patch", (String)"view_shift");
    private static final class_243 DEFAULT_SHIFT = new class_243(0.0, 0.0, 1.0);
    private static final class_2596<?> COMMAND_PACKET;
    public final CombinedPlayerCanvas canvas;
    public final VirtualDisplay virtualDisplay;
    public final CanvasRenderer renderer;
    public final class_2338 pos;
    @Nullable
    public final CanvasIcon cursor;
    @Nullable
    public final ItemDisplayElement cursor2;
    public final DisplayElement cameraPoint;
    public final ElementHolder holder = new ElementHolder();
    private final class_2338 zeroPos;
    public float xRot;
    public float yRot;
    public int cursorX;
    public int cursorY;
    public int mouseMoves;
    private boolean blockWeather;

    public MapGui(class_3222 player) {
        super(player);
        class_2338 pos;
        this.pos = pos = player.method_24515().method_33096(2048);
        class_2350 dir = class_2350.field_11043;
        this.canvas = DrawableCanvas.create((int)5, (int)3);
        this.zeroPos = pos.method_10093(dir).method_10079(dir.method_10170(), 2).method_10084();
        this.virtualDisplay = VirtualDisplay.of((PlayerCanvas)this.canvas, (class_2338)this.zeroPos, (class_2350)dir, (int)0, (boolean)true);
        this.renderer = CanvasRenderer.of((DrawableCanvas)new CanvasImage(this.canvas.getWidth(), this.canvas.getHeight()));
        this.renderer.add(new ImageButton(560, 32, GuiTextures.CLOSE_ICON, (a, b, c) -> this.close()));
        this.canvas.addPlayer(player);
        this.virtualDisplay.addPlayer(player);
        this.holder.setAttachment((HolderAttachment)new SelfHolder());
        this.holder.startWatching(player);
        this.cameraPoint = new BlockDisplayElement();
        class_2520 x = PlayerDataApi.getGlobalDataFor((class_3222)this.player, (class_2960)DISTANCE_STORAGE_ID);
        this.setDistance(x != null ? class_243.field_38277.decode((DynamicOps)class_2509.field_11560, (Object)x).result().map(Pair::getFirst).orElse(DEFAULT_SHIFT) : DEFAULT_SHIFT);
        this.holder.addElement((VirtualElement)this.cameraPoint);
        SimpleEntityElement horse = new SimpleEntityElement(class_1299.field_6139);
        horse.setInvisible(true);
        horse.setOffset(new class_243(0.0, 10.0, 0.0));
        horse.setYaw(0.0f);
        horse.setPitch(0.0f);
        this.holder.addElement((VirtualElement)horse);
        this.cursorX = this.canvas.getWidth();
        this.cursorY = this.canvas.getHeight();
        this.cursor = this.canvas.createIcon(class_21.field_85, true, this.cursorX, this.cursorY, (byte)14, null);
        this.cursor2 = null;
        player.field_13987.method_14364((class_2596)VirtualEntityUtils.createSetCameraEntityPacket((int)this.cameraPoint.getEntityId()));
        this.xRot = player.method_36455();
        this.yRot = player.method_36454();
        player.field_13987.method_14364((class_2596)VirtualEntityUtils.createRidePacket((int)horse.getEntityId(), (IntList)IntList.of((int)player.method_5628())));
        player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)class_1934.field_9219.method_8379()));
        player.field_13987.method_14364((class_2596)new class_2684.class_2687(player.method_5628(), 0, 0, player.method_24828()));
        player.field_13987.method_14364((class_2596)new class_2739(player.method_5628(), List.of(class_2945.class_7834.method_46360((class_2940)EntityTrackedData.POSE, (Object)class_4050.field_18076))));
        player.field_13987.method_14364(COMMAND_PACKET);
        this.player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25647, 0.0f));
        this.player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25652, 0.0f));
        this.player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25653, 0.0f));
        this.blockWeather = true;
        for (int i = 0; i < 9; ++i) {
            this.setSlot(i, new class_1799((class_1935)class_1802.field_8449));
        }
        player.field_13987.method_14364((class_2596)new class_7439((class_2561)class_2561.method_43469((String)"text.cctpatch.exit", (Object[])new Object[]{"Ctrl", class_2561.method_43472((String)"key.drop")}).method_27692(class_124.field_1061), true));
    }

    public void render() {
        this.renderer.render(this.player.method_37908().method_8510(), this.cursorX / 2, this.cursorY / 2);
        CanvasUtils.draw((DrawableCanvas)this.canvas, (int)0, (int)0, (DrawableCanvas)this.renderer.canvas());
        this.canvas.sendUpdates();
    }

    public void onTick() {
        this.holder.tick();
        ((ServerPlayNetworkHandlerAccessor)this.player.field_13987).setVehicleFloatingTicks(0);
        ((ServerPlayNetworkHandlerAccessor)this.player.field_13987).setFloatingTicks(0);
        this.render();
    }

    public void onClose() {
        if (this.cursor != null) {
            this.cursor.remove();
        }
        this.blockWeather = false;
        this.virtualDisplay.removePlayer(this.player);
        this.virtualDisplay.destroy();
        this.canvas.removePlayer(this.player);
        this.canvas.destroy();
        this.player.field_13995.method_3734().method_9241(this.player);
        this.holder.stopWatching(this.player);
        class_3218 world = this.player.method_51469();
        if (!world.method_8419()) {
            this.player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25647, 0.0f));
        } else {
            this.player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25646, 0.0f));
        }
        this.player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25652, world.method_8430(1.0f)));
        this.player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25653, world.method_8478(1.0f)));
        this.player.field_13987.method_14364((class_2596)new class_2734((class_1297)this.player));
        this.player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)this.player.field_13974.method_14257().method_8379()));
        this.player.field_13987.method_14364((class_2596)new class_2708(this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), this.player.method_36454(), this.player.method_36455(), EnumSet.noneOf(class_2709.class), 0));
        super.onClose();
    }

    public void onChatInput(String message) {
    }

    public void onCommandInput(String command) {
    }

    public void onCommandSuggestion(int id, String fullCommand) {
    }

    public void onCameraMove(float xRot, float yRot) {
        ++this.mouseMoves;
        if (this.mouseMoves < 4) {
            return;
        }
        this.xRot = xRot;
        this.yRot = yRot;
        this.cursorX += (int)((double)((double)xRot > 0.3 ? 6 : ((double)xRot < -0.3 ? -6 : 0)) * ((double)Math.abs(xRot) - 0.3));
        this.cursorY += (int)((double)((double)yRot > 0.3 ? 6 : ((double)yRot < -0.3 ? -6 : 0)) * ((double)Math.abs(yRot) - 0.3));
        this.cursorX = class_3532.method_15340((int)this.cursorX, (int)5, (int)(this.canvas.getWidth() * 2 - 5));
        this.cursorY = class_3532.method_15340((int)this.cursorY, (int)5, (int)(this.canvas.getHeight() * 2 - 5));
        if (this.cursor != null) {
            this.cursor.move(this.cursorX + 4, this.cursorY + 4, this.cursor.getRotation());
        }
        if (this.cursor2 != null) {
            this.cursor2.setTranslation((Vector3fc)new Vector3f((float)(-(this.cursorX + 4)) / 256.0f, (float)(-(this.cursorY + 4)) / 256.0f, 0.0f));
            this.cursor2.startInterpolationIfDirty();
            this.cursor2.tick();
        }
    }

    public boolean onClickEntity(int entityId, HotbarGui.EntityInteraction type, boolean isSneaking, @Nullable class_243 interactionPos) {
        if (type == HotbarGui.EntityInteraction.ATTACK) {
            this.renderer.click(this.cursorX / 2, this.cursorY / 2, ScreenElement.ClickType.LEFT_DOWN);
        } else {
            this.renderer.click(this.cursorX / 2, this.cursorY / 2, ScreenElement.ClickType.RIGHT_DOWN);
        }
        return super.onClickEntity(entityId, type, isSneaking, interactionPos);
    }

    public void setDistance(class_243 vec) {
        PlayerDataApi.setGlobalDataFor((class_3222)this.player, (class_2960)DISTANCE_STORAGE_ID, (class_2520)((class_2520)class_243.field_38277.encodeStart((DynamicOps)class_2509.field_11560, (Object)vec).result().get()));
        this.cameraPoint.setOffset(new class_243((double)(-this.canvas.getSectionsWidth()) / 2.0 - vec.field_1352, (double)(-this.canvas.getSectionsHeight()) / 2.0 + vec.field_1351, -0.8 - vec.field_1350));
        this.cameraPoint.tick();
    }

    public void onPlayerAction(class_2846.class_2847 action, class_2350 direction, class_2338 pos) {
        if (action == class_2846.class_2847.field_12970) {
            this.close();
        }
    }

    public void onPlayerInput(float deltaX, float deltaZ, boolean jumping, boolean shiftKeyDown) {
    }

    public void onPlayerCommand(int id, class_2848.class_2849 action, int data) {
    }

    public boolean preventPacket(class_2596<?> packet) {
        if (packet instanceof class_2668) {
            class_2668 state = (class_2668)packet;
            if (this.blockWeather) {
                return state.method_11491() == class_2668.field_25648 || state.method_11491() == class_2668.field_25652 || state.method_11491() == class_2668.field_25646 || state.method_11491() == class_2668.field_25653;
            }
        }
        if (packet instanceof class_2767) {
            class_2767 sound = (class_2767)packet;
            class_243 camera = this.holder.getPos().method_1019(this.cameraPoint.getOffset());
            if (camera.method_1028(sound.method_11890(), sound.method_11889(), sound.method_11893()) < 4096.0) {
                return false;
            }
            if (this.player.method_33571().method_1028(sound.method_11890(), sound.method_11889(), sound.method_11893()) < 4096.0) {
                class_243 pos = camera.method_1019(this.player.method_33571().method_1023(sound.method_11890(), sound.method_11889(), sound.method_11893()).method_1024(-this.player.method_36454() * ((float)Math.PI / 180)).method_1037(this.player.method_36455() * ((float)Math.PI / 180)));
                this.player.field_13987.method_14364((class_2596)new class_2767(sound.method_11894(), sound.method_11888(), pos.field_1352, pos.field_1351, pos.field_1350, sound.method_11891(), sound.method_11892(), sound.method_43236()));
            }
            return true;
        }
        return false;
    }

    static {
        RootCommandNode commandNode = new RootCommandNode();
        commandNode.addChild((CommandNode)new ArgumentCommandNode("command", (ArgumentType)StringArgumentType.greedyString(), null, (Predicate)Predicates.alwaysTrue(), null, null, true, (ctx, builder) -> null));
        COMMAND_PACKET = new class_2641(commandNode);
    }

    private class SelfHolder
    implements HolderAttachment {
        private SelfHolder() {
        }

        public ElementHolder holder() {
            return MapGui.this.holder;
        }

        public void destroy() {
        }

        public class_243 getPos() {
            return class_243.method_24954((class_2382)MapGui.this.zeroPos).method_1031(1.0, 1.0, 0.96875);
        }

        public class_3218 getWorld() {
            return MapGui.this.getPlayer().method_51469();
        }

        public void updateCurrentlyTracking(Collection<class_3244> currentlyTracking) {
        }

        public void updateTracking(class_3244 tracking) {
        }
    }
}

