/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly.gui;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.media.items.PrintoutItem;
import eu.pb4.cctpatch.impl.poly.font.Fonts;
import eu.pb4.cctpatch.impl.poly.gui.MapGui;
import eu.pb4.cctpatch.impl.poly.render.CenteredTextView;
import eu.pb4.cctpatch.impl.poly.render.ImageView;
import eu.pb4.cctpatch.impl.poly.render.TextButton;
import eu.pb4.cctpatch.impl.poly.textures.GuiTextures;
import eu.pb4.cctpatch.impl.poly.textures.RepeatingCanvas;
import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.DefaultFonts;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2846;
import net.minecraft.class_2848;
import net.minecraft.class_3222;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class PrintedPageGui
extends MapGui {
    private final CanvasImage[] pages;
    private final ImageView displayedPage;
    private final ImageView leftSide;
    private final ImageView rightSide;
    private final PrintoutData data;
    private int currentPage = 0;
    @Nullable
    private final CenteredTextView pageText;

    public PrintedPageGui(class_3222 player, class_1799 stack) {
        super(player);
        this.data = (PrintoutData)stack.method_57825((class_9331)ModRegistry.DataComponents.PRINTOUT.get(), (Object)PrintoutData.EMPTY);
        ArrayList<CanvasImage> list = new ArrayList<CanvasImage>();
        PrintoutItem.Type type = ((PrintoutItem)stack.method_7909()).getType();
        CanvasImage image = null;
        int pageWidth = 150;
        int pageHeight = 189;
        for (int y2 = 0; y2 < this.data.lines().size(); ++y2) {
            int lY = y2 % 21;
            if (lY == 0) {
                if (image != null) {
                    list.add(image);
                }
                image = new CanvasImage(pageWidth, pageHeight);
            }
            PrintoutData.Line line = (PrintoutData.Line)this.data.lines().get(y2);
            String text = line.text();
            String color = line.foreground();
            int textLength = Math.min(21, text.length());
            for (int x2 = 0; x2 < textLength; ++x2) {
                char character = text.charAt(x2);
                int charWidth = Fonts.TERMINAL_FONT.getGlyphWidth((int)character, 8.0, 0);
                Fonts.TERMINAL_FONT.drawGlyph((DrawableCanvas)image, (int)text.charAt(x2), x2 * 6 + (6 - charWidth) / 2, lY * 9, 8.0, 0, CanvasUtils.findClosestColor((int)Colour.fromInt((int)(15 - Terminal.getColour((char)color.charAt(x2), (Colour)Colour.BLACK))).getHex()));
            }
        }
        if (image != null) {
            list.add(image);
        }
        this.pages = list.toArray(new CanvasImage[0]);
        int centerX = this.canvas.getWidth() / 2;
        int centerY = this.canvas.getHeight() / 2 - 24;
        if (this.data.pages() > 1) {
            int ay = centerY + pageHeight / 2 + 32;
            this.pageText = new CenteredTextView(0, ay, this.renderer.canvas().getWidth(), this.currentPage + 1 + "/" + this.data.pages(), DefaultFonts.VANILLA, 16, CanvasColor.BLACK_HIGH);
            this.pageText.zIndex = 100;
            this.renderer.add(this.pageText);
            this.renderer.add(new TextButton(centerX - 48, ay, 20, 20, "\u00ab", DefaultFonts.VANILLA, 16, CanvasColor.BLACK_HIGH, (x, y, z) -> this.previousPage()));
            this.renderer.add(new TextButton(centerX + 48 - 19, ay, 20, 20, "\u00bb", DefaultFonts.VANILLA, 16, CanvasColor.BLACK_HIGH, (x, y, z) -> this.nextPage()));
        } else {
            this.pageText = null;
        }
        int bW = GuiTextures.PRINTED_PAGE.centerPage().getWidth();
        int bH = GuiTextures.PRINTED_PAGE.centerPage().getHeight();
        int bX = centerX - bW / 2;
        int bY = centerY - bH / 2;
        ImageView background = new ImageView(bX, bY, (DrawableCanvas)GuiTextures.PRINTED_PAGE.centerPage());
        background.zIndex = 8;
        this.renderer.add(background);
        int offset = type == PrintoutItem.Type.PAGE ? 0 : 8;
        this.leftSide = new ImageView(bX - offset, bY, (DrawableCanvas)GuiTextures.PRINTED_PAGE.leftPageSide());
        this.leftSide.zIndex = 9 - offset;
        this.renderer.add(this.leftSide);
        this.rightSide = new ImageView(bX + bW + offset - GuiTextures.PRINTED_PAGE.rightPageSide().getWidth(), bY, (DrawableCanvas)GuiTextures.PRINTED_PAGE.rightPageSide());
        this.rightSide.zIndex = 9 - offset;
        this.renderer.add(this.rightSide);
        if (type == PrintoutItem.Type.BOOK) {
            this.renderer.add(new ImageView(bX - 3, centerY - GuiTextures.PRINTED_PAGE.leatherRight().getHeight() / 2, new RepeatingCanvas((DrawableCanvas)GuiTextures.PRINTED_PAGE.leatherTop(), bW + 6, GuiTextures.PRINTED_PAGE.leatherTop().getHeight())));
            this.renderer.add(new ImageView(bX - 3, centerY + GuiTextures.PRINTED_PAGE.leatherLeft().getHeight() / 2 - GuiTextures.PRINTED_PAGE.leatherBottom().getHeight(), new RepeatingCanvas((DrawableCanvas)GuiTextures.PRINTED_PAGE.leatherBottom(), bW + 6, GuiTextures.PRINTED_PAGE.leatherBottom().getHeight())));
            this.renderer.add(new ImageView(bX - GuiTextures.PRINTED_PAGE.leatherLeft().getWidth() - 3, centerY - GuiTextures.PRINTED_PAGE.leatherLeft().getHeight() / 2, (DrawableCanvas)GuiTextures.PRINTED_PAGE.leatherLeft()));
            this.renderer.add(new ImageView(bX + bW + 3, centerY - GuiTextures.PRINTED_PAGE.leatherRight().getHeight() / 2, (DrawableCanvas)GuiTextures.PRINTED_PAGE.leatherRight()));
        }
        this.displayedPage = new ImageView(centerX - pageWidth / 2, centerY - pageHeight / 2, (DrawableCanvas)this.pages[0]);
        this.displayedPage.zIndex = 50;
        this.renderer.add(this.displayedPage);
        this.setPage(0);
        this.render();
        this.open();
    }

    private void nextPage() {
        int page = this.currentPage + 1;
        if (page >= this.data.pages()) {
            page = 0;
        }
        this.setPage(page);
    }

    private void previousPage() {
        int page = this.currentPage - 1;
        if (page < 0) {
            page = this.data.pages() - 1;
        }
        this.setPage(page);
    }

    private void setPage(int page) {
        this.displayedPage.image = this.pages[page];
        this.currentPage = page;
        if (this.pageText != null) {
            this.pageText.text = page + 1 + "/" + this.data.pages();
        }
    }

    @Override
    public void onPlayerAction(class_2846.class_2847 action, class_2350 direction, class_2338 pos) {
        if (action == class_2846.class_2847.field_12975) {
            this.previousPage();
            return;
        }
        super.onPlayerAction(action, direction, pos);
    }

    @Override
    public void onPlayerCommand(int id, class_2848.class_2849 action, int data) {
        if (action == class_2848.class_2849.field_12988) {
            this.nextPage();
        }
    }
}

