/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly.model;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.upgrades.TurtleCraftingTable;
import dan200.computercraft.shared.turtle.upgrades.TurtleSpeaker;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import dan200.computercraft.shared.util.Holiday;
import eu.pb4.cctpatch.mixin.TurtleModemAccessor;
import eu.pb4.factorytools.api.resourcepack.BaseItemProvider;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_9283;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class TurtleModel
extends BlockModel {
    public static final ModemModel NORMAL_MODEM_MODEL = ModemModel.of(class_2960.method_60655((String)"computercraft", (String)"block/turtle_modem_normal"));
    public static final ModemModel ADVANCED_MODEM_MODEL = ModemModel.of(class_2960.method_60655((String)"computercraft", (String)"block/turtle_modem_advanced"));
    public static final SidedModel SPEAKER_MODEL = SidedModel.of(class_2960.method_60655((String)"computercraft", (String)"block/turtle_speaker"));
    public static final SidedModel CRAFTING_MODEL = SidedModel.of(class_2960.method_60655((String)"computercraft", (String)"block/turtle_crafting_table"));
    public static final class_1799 COLORED_TURTLE_MODEL = BaseItemProvider.requestModel((class_1792)class_1802.field_8450, (class_2960)class_2960.method_60655((String)"computercraft", (String)"block/turtle_colour"));
    public static final class_2960 ELF_OVERLAY_MODEL = class_2960.method_60655((String)"computercraft", (String)"block/turtle_elf_overlay");
    private static final Map<class_2960, class_1799> OVERLAYS = new HashMap<class_2960, class_1799>();
    private final ItemDisplayElement base;
    private final ItemDisplayElement overlay;
    private final ItemDisplayElement overlay2;
    private final ItemDisplayElement leftAttachment;
    private final ItemDisplayElement rightAttachment;
    private float baseYaw;
    private ITurtleUpgrade leftUpgrade;
    private ITurtleUpgrade rightUpgrade;
    private class_243 lastPos;
    private int color = -1;
    private class_2960 overlayId;
    private class_2960 overlayId2;

    public static void registerOverlay(class_2960 identifier) {
        if (!OVERLAYS.containsKey(identifier)) {
            OVERLAYS.put(identifier, BaseItemProvider.requestModel((class_2960)identifier));
        }
    }

    public TurtleModel(class_2680 state, class_2338 pos) {
        this.lastPos = class_243.method_24953((class_2382)pos);
        this.baseYaw = ((class_2350)state.method_11654((class_2769)TurtleBlock.FACING)).method_10144();
        this.base = ItemDisplayElementUtil.createSimple((class_1799)ItemDisplayElementUtil.getModel((class_1792)state.method_26204().method_8389()));
        this.base.setTeleportDuration(1);
        this.base.setModelTransformation(class_811.field_4315);
        this.base.setYaw(this.baseYaw);
        this.overlay = ItemDisplayElementUtil.createSimple();
        this.overlay.setTeleportDuration(1);
        this.overlay.setModelTransformation(class_811.field_4315);
        this.overlay.setYaw(this.baseYaw);
        this.overlay2 = ItemDisplayElementUtil.createSimple();
        this.overlay2.setTeleportDuration(1);
        this.overlay2.setModelTransformation(class_811.field_4315);
        this.overlay2.setYaw(this.baseYaw);
        this.leftAttachment = ItemDisplayElementUtil.createSimple();
        this.leftAttachment.setInterpolationDuration(1);
        this.leftAttachment.setModelTransformation(class_811.field_4315);
        this.leftAttachment.setYaw(this.baseYaw);
        this.rightAttachment = ItemDisplayElementUtil.createSimple();
        this.rightAttachment.setInterpolationDuration(1);
        this.rightAttachment.setModelTransformation(class_811.field_4315);
        this.rightAttachment.setYaw(this.baseYaw);
        this.addElement((VirtualElement)this.base);
        this.addElement((VirtualElement)this.overlay);
        this.addElement((VirtualElement)this.overlay2);
        this.addElement((VirtualElement)this.leftAttachment);
        this.addElement((VirtualElement)this.rightAttachment);
    }

    protected void startWatchingExtraPackets(class_3244 player, Consumer<class_2596<class_2602>> packetConsumer) {
        super.startWatchingExtraPackets(player, packetConsumer);
        packetConsumer.accept((class_2596<class_2602>)VirtualEntityUtils.createRidePacket((int)this.base.getEntityId(), (IntList)IntList.of((int)this.leftAttachment.getEntityId(), (int)this.rightAttachment.getEntityId(), (int)this.overlay.getEntityId())));
    }

    protected void notifyElementsOfPositionUpdate(class_243 newPos, class_243 delta) {
    }

    public void setYaw(float yaw) {
        if (this.baseYaw == yaw) {
            return;
        }
        this.baseYaw = yaw;
        this.base.setYaw(this.baseYaw);
        this.overlay.setYaw(this.baseYaw);
        this.overlay2.setYaw(this.baseYaw);
        this.leftAttachment.setYaw(this.baseYaw);
        this.rightAttachment.setYaw(this.baseYaw);
    }

    public void setUpgrades(TurtleBrain brain, ITurtleUpgrade left, ITurtleUpgrade right) {
        if (this.leftUpgrade != left) {
            this.leftUpgrade = left;
            this.leftAttachment.setItem(this.getUpgradeModel(left, brain, TurtleSide.LEFT));
        }
        if (this.rightUpgrade != right) {
            this.rightUpgrade = right;
            this.rightAttachment.setItem(this.getUpgradeModel(right, brain, TurtleSide.RIGHT));
        }
    }

    private class_1799 getUpgradeModel(ITurtleUpgrade upgrade, TurtleBrain brain, TurtleSide turtleSide) {
        if (upgrade == null) {
            return class_1799.field_8037;
        }
        if (upgrade instanceof TurtleModemAccessor) {
            TurtleModemAccessor modem = (TurtleModemAccessor)upgrade;
            ModemModel type = modem.isAdvanced() ? ADVANCED_MODEM_MODEL : NORMAL_MODEM_MODEL;
            Optional x = brain.getUpgradeData(turtleSide).method_57845((class_9331)ModRegistry.DataComponents.ON.get());
            if (x != null && x.isPresent() && ((Boolean)x.get()).booleanValue()) {
                return type.onModel.get(turtleSide);
            }
            return type.offModel.get(turtleSide);
        }
        if (upgrade instanceof TurtleSpeaker) {
            return SPEAKER_MODEL.get(turtleSide);
        }
        if (upgrade instanceof TurtleCraftingTable) {
            return CRAFTING_MODEL.get(turtleSide);
        }
        return upgrade.getCraftingItem();
    }

    public void update(TurtleBrain turtleBrain) {
        class_243 pos = turtleBrain.getVisualPosition(1.0f);
        this.setYaw(turtleBrain.getVisualYaw(1.0f));
        if (!pos.equals((Object)this.lastPos)) {
            this.base.notifyMove(this.lastPos, pos, pos.method_1020(this.lastPos));
            this.lastPos = pos;
        }
        if (this.color != turtleBrain.getColour()) {
            this.color = turtleBrain.getColour();
            if (this.color == -1) {
                this.base.setItem(ItemDisplayElementUtil.getModel((class_1792)this.blockState().method_26204().method_8389()));
            } else {
                class_1799 model = COLORED_TURTLE_MODEL.method_7972();
                model.method_57379(class_9334.field_49615, (Object)new class_9283(class_9283.class_1782.field_7970, IntList.of((int)this.color), IntList.of(), false, false));
                this.base.setItem(model);
            }
        }
        class_6880 overlay = turtleBrain.getOverlay();
        class_2960 overlay2 = null;
        if ((overlay == null || ((TurtleOverlay)overlay.comp_349()).showElfOverlay()) && Holiday.getCurrent() == Holiday.CHRISTMAS) {
            overlay2 = ELF_OVERLAY_MODEL;
        }
        if (this.overlayId != null && overlay == null || overlay != null && !((TurtleOverlay)overlay.comp_349()).model().equals((Object)this.overlayId)) {
            this.overlayId = overlay != null ? ((TurtleOverlay)overlay.comp_349()).model() : null;
            this.overlay.setItem(OVERLAYS.getOrDefault(this.overlayId, class_1799.field_8037));
        }
        if (!Objects.equals(overlay2, this.overlayId2)) {
            this.overlayId2 = overlay2;
            this.overlay2.setItem(OVERLAYS.getOrDefault(this.overlayId2, class_1799.field_8037));
        }
        this.setUpgrades(turtleBrain, turtleBrain.getUpgrade(TurtleSide.LEFT), turtleBrain.getUpgrade(TurtleSide.RIGHT));
        Matrix4f mat = BlockModel.mat();
        for (TurtleSide side : TurtleSide.values()) {
            ITurtleUpgrade upgrade;
            ITurtleUpgrade iTurtleUpgrade = upgrade = side == TurtleSide.RIGHT ? this.rightUpgrade : this.leftUpgrade;
            if (upgrade == null) continue;
            float toolAngle = turtleBrain.getToolRenderAngle(side, 1.0f);
            mat.rotate((Quaternionfc)class_7833.field_40713.rotationDegrees(toolAngle));
            if (upgrade instanceof TurtleTool) {
                mat.rotateY(1.5707964f);
                mat.translate(0.0f, 0.0f, side == TurtleSide.RIGHT ? -0.40625f : 0.40625f);
            }
            ItemDisplayElement att = side == TurtleSide.RIGHT ? this.rightAttachment : this.leftAttachment;
            att.setTransformation(mat);
            mat.identity();
            if (!att.isTransformationDirty()) continue;
            att.startInterpolation();
        }
    }

    public record ModemModel(SidedModel onModel, SidedModel offModel) {
        public static ModemModel of(class_2960 identifier) {
            return new ModemModel(SidedModel.of(identifier.method_48331("_on")), SidedModel.of(identifier.method_48331("_off")));
        }
    }

    public record SidedModel(class_1799 left, class_1799 right) {
        public static SidedModel of(class_2960 identifier) {
            return new SidedModel(BaseItemProvider.requestModel((class_2960)identifier.method_48331("_left")), BaseItemProvider.requestModel((class_2960)identifier.method_48331("_right")));
        }

        public class_1799 get(TurtleSide side) {
            return side == TurtleSide.RIGHT ? this.right : this.left;
        }
    }
}

