/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly.model.generic;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.cctpatch.impl.poly.AutoModeledPolymerBlock;
import eu.pb4.cctpatch.impl.poly.model.generic.json.ModelVariant;
import eu.pb4.cctpatch.impl.poly.model.generic.json.MultiPartDefinition;
import eu.pb4.cctpatch.impl.poly.model.generic.json.StateDefinition;
import eu.pb4.factorytools.api.resourcepack.BaseItemProvider;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2715;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class BlockStateModelManager {
    private static final Map<class_2680, List<ModelGetter>> MAP = new HashMap<class_2680, List<ModelGetter>>();
    private static final Map<class_2960, class_1799> EXISTING_MODELS = new HashMap<class_2960, class_1799>();

    public static List<ModelGetter> get(class_2680 state) {
        return MAP.getOrDefault(state, List.of());
    }

    public static void addBlock(class_2960 identifier, class_2248 block) {
        if (!(block instanceof AutoModeledPolymerBlock)) {
            // empty if block
        }
        try {
            ArrayList<class_3545<List<class_2715>, List<ModelData>>> list;
            Path path = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("computercraft").get()).findPath("assets/" + identifier.method_12836() + "/blockstates/" + identifier.method_12832() + ".json").get();
            DataResult decoded = StateDefinition.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)Files.readString(path)));
            StateDefinition modelDef = (StateDefinition)((Pair)decoded.result().get()).getFirst();
            if (modelDef.variants().isPresent()) {
                list = new ArrayList<class_3545<List<class_2715>, List<ModelData>>>();
                BlockStateModelManager.parseVariants(block, modelDef.variants().get(), list);
                for (class_3545<class_2715, List<ModelData>> class_35452 : list) {
                    for (class_2680 state : block.method_9595().method_11662()) {
                        if (!((class_2715)class_35452.method_15442()).method_11760(state)) continue;
                        MAP.put(state, List.of(ModelGetter.of((List)class_35452.method_15441())));
                    }
                }
            }
            if (modelDef.multipart().isPresent()) {
                list = new ArrayList();
                BlockStateModelManager.parseMultipart(block, modelDef.multipart().get(), list);
                for (class_3545 class_35453 : list) {
                    block5: for (class_2680 state : block.method_9595().method_11662()) {
                        for (class_2715 pred : (List)class_35453.method_15442()) {
                            if (!pred.method_11760(state)) continue;
                            ArrayList<ModelGetter> objects = new ArrayList<ModelGetter>();
                            if (MAP.containsKey(state)) {
                                objects.addAll((Collection)MAP.get(state));
                            }
                            objects.add(ModelGetter.of((List)class_35453.method_15441()));
                            MAP.put(state, objects);
                            continue block5;
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void parseMultipart(class_2248 block, List<MultiPartDefinition> multiPartDefinition, ArrayList<class_3545<List<class_2715>, List<ModelData>>> list) {
        for (MultiPartDefinition part : multiPartDefinition) {
            class_2715 predicate;
            ArrayList<class_2715> preds = new ArrayList<class_2715>();
            if (part.when().or().isPresent()) {
                for (Map<String, String> x : part.when().or().get()) {
                    class_2715 predicate2 = class_2715.method_11758((class_2248)block);
                    BlockStateModelManager.applyWhenMultipart(predicate2, block, x);
                    preds.add(predicate2);
                }
            }
            if (part.when().and().isPresent()) {
                predicate = class_2715.method_11758((class_2248)block);
                for (Map<String, String> x : part.when().or().get()) {
                    BlockStateModelManager.applyWhenMultipart(predicate, block, x);
                }
                preds.add(predicate);
            }
            if (part.when().base().isPresent()) {
                predicate = class_2715.method_11758((class_2248)block);
                BlockStateModelManager.applyWhenMultipart(predicate, block, part.when().base().get());
                preds.add(predicate);
            }
            if (preds.isEmpty()) {
                preds.add(class_2715.method_11758((class_2248)block));
            }
            List<ModelData> modelData = BlockStateModelManager.parseBaseVariants(part.apply());
            list.add((class_3545<List<class_2715>, List<ModelData>>)new class_3545(preds, modelData));
        }
    }

    private static void applyWhenMultipart(class_2715 predicate, class_2248 block, Map<String, String> x) {
        for (Map.Entry<String, String> entry : x.entrySet()) {
            class_2769 prop = block.method_9595().method_11663(entry.getKey());
            if (prop == null) continue;
            Set<String> split = Set.of(entry.getValue().split("\\|"));
            predicate.method_11762(prop, y -> split.contains(prop.method_11901((Comparable)y)));
        }
    }

    private static void parseVariants(class_2248 block, Map<String, List<ModelVariant>> modelDef, ArrayList<class_3545<class_2715, List<ModelData>>> list) {
        block0: for (Map.Entry<String, List<ModelVariant>> pair : modelDef.entrySet()) {
            String[] stateMap = pair.getKey().split(",");
            class_2715 predicate = class_2715.method_11758((class_2248)block);
            for (String statePair : stateMap) {
                String[] split = statePair.split("=", 2);
                class_2769 prop = block.method_9595().method_11663(split[0]);
                if (prop == null) continue block0;
                predicate.method_11762(prop, x -> prop.method_11901((Comparable)x).equals(split[1]));
            }
            List<ModelData> modelData = BlockStateModelManager.parseBaseVariants(pair.getValue());
            list.add((class_3545<class_2715, List<ModelData>>)new class_3545((Object)predicate, modelData));
        }
    }

    private static List<ModelData> parseBaseVariants(List<ModelVariant> value) {
        ArrayList<ModelData> modelData = new ArrayList<ModelData>();
        for (ModelVariant v : value) {
            class_1799 stack = EXISTING_MODELS.computeIfAbsent(v.model(), BaseItemProvider::requestModel);
            modelData.add(new ModelData(stack, (Quaternionfc)new Quaternionf().rotateY((float)(-Math.PI) / 180 * (float)v.y()).rotateX((float)Math.PI / 180 * (float)v.x()), v.weigth()));
        }
        return modelData;
    }

    public static interface ModelGetter {
        public ModelData getModel(class_5819 var1);

        public static ModelGetter of(List<ModelData> data) {
            if (data.size() == 1) {
                return new SingleGetter(data.get(0));
            }
            return WeightedGetter.create(data);
        }
    }

    public record ModelData(class_1799 stack, Quaternionfc quaternionfc, int weight) {
    }

    private record WeightedGetter(List<class_6008.class_6010<ModelData>> data, int weightedSum) implements ModelGetter
    {
        public static ModelGetter create(List<ModelData> data) {
            ArrayList<class_6008.class_6010<ModelData>> list = new ArrayList<class_6008.class_6010<ModelData>>();
            for (ModelData d : data) {
                list.add((class_6008.class_6010<ModelData>)class_6008.method_34980((Object)d, (int)d.weight));
            }
            int x = class_6011.method_34984(list);
            return new WeightedGetter(list, x);
        }

        @Override
        public ModelData getModel(class_5819 random) {
            return (ModelData)class_6011.method_34985(this.data, (int)(Math.abs((int)random.method_43055()) % this.weightedSum)).orElse(this.data.get(0)).comp_2542();
        }
    }

    private record SingleGetter(ModelData data) implements ModelGetter
    {
        @Override
        public ModelData getModel(class_5819 random) {
            return this.data;
        }
    }
}

