/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly.render;

import eu.pb4.cctpatch.impl.poly.render.ScreenElement;
import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public record CanvasRenderer(DrawableCanvas canvas, List<ScreenElement> elementList) {
    public static CanvasRenderer of(DrawableCanvas canvas) {
        return new CanvasRenderer(canvas, new ArrayList<ScreenElement>());
    }

    public void add(ScreenElement element) {
        this.elementList.add(element);
        this.sort();
    }

    public void remove(ScreenElement element) {
        this.elementList.remove(element);
    }

    public void sort() {
        this.elementList.sort(Comparator.comparing(e -> e.zIndex));
    }

    public void render(long tick, int mouseX, int mouseY) {
        CanvasUtils.clear((DrawableCanvas)this.canvas, (CanvasColor)CanvasColor.CLEAR_FORCE);
        for (ScreenElement element : this.elementList) {
            element.render(this.canvas, tick, mouseX, mouseY);
        }
    }

    public void click(int x, int y, ScreenElement.ClickType type) {
        for (ScreenElement element : this.elementList) {
            if (!element.isIn(x, y)) continue;
            element.click(x - element.x, y - element.y, type);
        }
    }
}

