/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly.render;

import com.google.common.base.Supplier;
import eu.pb4.cctpatch.impl.poly.ext.ServerInputStateExt;
import eu.pb4.cctpatch.impl.poly.gui.ComputerGui;
import eu.pb4.cctpatch.impl.poly.render.ScreenElement;
import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.DefaultFonts;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;

public class KeyboardView
extends ScreenElement {
    private static final Key[][] KEYS = new Key[][]{{KeyboardView.k("ESC", 256), KeyboardView.e(16), KeyboardView.k("F1", 290), KeyboardView.k("F2", 291), KeyboardView.k("F3", 292), KeyboardView.k("F4", 293), KeyboardView.e(12), KeyboardView.k("F5", 294), KeyboardView.k("F6", 295), KeyboardView.k("F7", 296), KeyboardView.k("F8", 297), KeyboardView.e(12), KeyboardView.k("F9", 298), KeyboardView.k("F10", 299), KeyboardView.k("F11", 300), KeyboardView.k("F12", 301), KeyboardView.e(5), KeyboardView.k("Prn", 283), KeyboardView.k("SLk", 281), KeyboardView.k("\u23f8", 284)}, {KeyboardView.k("~\n`", 96, '`', '~'), KeyboardView.k("!\n1", 49, '1', '!'), KeyboardView.k("@\n2", 50, '2', '@'), KeyboardView.k("#\n3", 51, '3', '#'), KeyboardView.k("$\n4", 52, '4', '$'), KeyboardView.k("%\n5", 53, '5', '%'), KeyboardView.k("^\n6", 54, '6', '^'), KeyboardView.k("&\n7", 55, '7', '&'), KeyboardView.k("*\n8", 56, '8', '*'), KeyboardView.k("(\n9", 57, '9', '('), KeyboardView.k(")\n0", 48, '0', ')'), KeyboardView.k("_\n-", 45, '-', '_'), KeyboardView.k("+\n=", 61), KeyboardView.k("<--", 259, 44), KeyboardView.e(5), KeyboardView.k("Ins", 260), KeyboardView.k("Hm", 268), KeyboardView.k("P\u23f6", 266)}, {KeyboardView.k("Tab", 258, 32), KeyboardView.k("Q", 81), KeyboardView.k("W", 87), KeyboardView.k("E", 69), KeyboardView.k("R", 82), KeyboardView.k("T", 84), KeyboardView.k("Y", 89), KeyboardView.k("U", 85), KeyboardView.k("I", 73), KeyboardView.k("O", 79), KeyboardView.k("P", 80), KeyboardView.k("{\n[", 91, '[', '{'), KeyboardView.k("}\n]", 93, ']', '}'), KeyboardView.k("Enter", 257, 32), KeyboardView.e(5), KeyboardView.k("Del", 261), KeyboardView.k("End", 269), KeyboardView.k("P\u23f7", 267)}, {KeyboardView.k("Caps", 280, 38), KeyboardView.k("A", 65), KeyboardView.k("S", 83), KeyboardView.k("D", 68), KeyboardView.k("F", 70), KeyboardView.k("G", 71), KeyboardView.k("H", 72), KeyboardView.k("J", 74), KeyboardView.k("K", 75), KeyboardView.k("L", 76), KeyboardView.k(":\n;", 59, ';', ':'), KeyboardView.k("\"\n'", 39, '\'', '\"'), KeyboardView.k("|\n\\", 92, '\\', '|'), KeyboardView.k("", 257, 26)}, {KeyboardView.k("Shift", 340, 54), KeyboardView.k("Z", 90), KeyboardView.k("X", 88), KeyboardView.k("C", 67), KeyboardView.k("V", 86), KeyboardView.k("B", 66), KeyboardView.k("N", 78), KeyboardView.k("M", 77), KeyboardView.k("<\n,", 44, ',', '<'), KeyboardView.k(">\n.", 46, '.', '>'), KeyboardView.k("?\n/", 47, '/', '?'), KeyboardView.k("Shift", 344, 54), KeyboardView.e(27), KeyboardView.k("\u25b2", 265)}, {KeyboardView.k("Ctrl", 341, 33), KeyboardView.k("\u26cf", 348, 27), KeyboardView.k("Alt", 342, 27), KeyboardView.k(" ", 32, 144), KeyboardView.k("Alt", 346, 27), KeyboardView.k("\u2697", 347, 27), KeyboardView.k("Ctrl", 345, 33), KeyboardView.e(5), KeyboardView.k("\u25c0", 263), KeyboardView.k("\u25bc", 264), KeyboardView.k("\u25b6", 262)}};
    public static final int KEYBOARD_WIDTH = (Integer)((Supplier)() -> {
        int longest = 0;
        for (Key[] keyLine : KEYS) {
            int length = 0;
            for (Key key : keyLine) {
                length += key.width() + 2;
            }
            longest = Math.max(longest, length);
        }
        return longest;
    }).get();
    public static final int[] LINE_WIDTH = (int[])((Supplier)() -> {
        int[] array = new int[KEYS.length];
        for (int i = 0; i < KEYS.length; ++i) {
            int length = 0;
            for (Key key : KEYS[i]) {
                length += key.width() + 2;
            }
            array[i] = length;
        }
        return array;
    }).get();
    public static final int[] KEY_SPACING = (int[])((Supplier)() -> {
        int[] array = new int[KEYS.length];
        for (int i = 0; i < KEYS.length; ++i) {
            int length = 0;
            for (Key key : KEYS[i]) {
                length += key.width();
            }
            array[i] = (KEYBOARD_WIDTH - length) / KEYS[i].length;
        }
        return array;
    }).get();
    public static final Char2ObjectMap<Key> CHAR_TO_KEY = (Char2ObjectMap)((Supplier)() -> {
        Char2ObjectOpenHashMap map = new Char2ObjectOpenHashMap();
        Key[][] keyArray = KEYS;
        int n = keyArray.length;
        for (int i = 0; i < n; ++i) {
            Key[] i2;
            for (Key x : i2 = keyArray[i]) {
                map.put(x.lowerCase, (Object)x);
                map.put(x.upperCase, (Object)x);
            }
        }
        return map;
    }).get();
    private final ComputerGui gui;

    public KeyboardView(int x, int y, ComputerGui gui) {
        super(x, y);
        this.gui = gui;
    }

    @Override
    public void render(DrawableCanvas canvas, long tick, int mouseX, int mouseY) {
        int buttonCollisionHeight = 16;
        int y = 0;
        ServerInputStateExt inputExt = ServerInputStateExt.of(this.gui.input);
        for (int l = 0; l < KEYS.length; ++l) {
            int x = 0;
            for (Key key : KEYS[l]) {
                if (key.key() != -1) {
                    int a;
                    boolean isHeld = inputExt.isKeyDown(key.key());
                    int n = a = isHeld ? 1 : 0;
                    if (key.key() == 257) {
                        CanvasColor color2;
                        CanvasColor color;
                        boolean hover;
                        int tX2 = 0;
                        for (Key keyTmp : KEYS[3]) {
                            if (keyTmp.key == 257) continue;
                            tX2 += keyTmp.width() + 2;
                        }
                        boolean bl = hover = ScreenElement.isIn(mouseX, mouseY, this.x + tX2, this.y + 32 - 3, this.x + tX2 + 32, this.y + 32 + buttonCollisionHeight) || ScreenElement.isIn(mouseX, mouseY, this.x + tX2, this.y + 48 - 3, this.x + tX2 + 26, this.y + 48 + buttonCollisionHeight);
                        CanvasColor canvasColor = isHeld ? CanvasColor.WHITE_GRAY_LOW : (color = hover ? CanvasColor.WHITE_GRAY_NORMAL : CanvasColor.WHITE_GRAY_HIGH);
                        CanvasColor canvasColor2 = isHeld ? CanvasColor.GRAY_LOW : (color2 = hover ? CanvasColor.WHITE_GRAY_LOW : CanvasColor.WHITE_GRAY_LOW);
                        if (l == 3) {
                            if (!isHeld) {
                                CanvasUtils.fill((DrawableCanvas)canvas, (int)(this.x + x), (int)(this.y + y * 16 - 3), (int)(this.x + x + key.width() + 1), (int)(this.y + y * 16 + 14 + 1), (CanvasColor)color2);
                            }
                            CanvasUtils.fill((DrawableCanvas)canvas, (int)(this.x + x + a), (int)(this.y + y * 16 - 3 + a), (int)(this.x + x + key.width() + a), (int)(this.y + y * 16 + 14 + a), (CanvasColor)color);
                        } else {
                            if (!isHeld) {
                                CanvasUtils.fill((DrawableCanvas)canvas, (int)(this.x + x), (int)(this.y + y * 16), (int)(this.x + x + key.width() + 1), (int)(this.y + y * 16 + 14 + 1), (CanvasColor)color2);
                            }
                            CanvasUtils.fill((DrawableCanvas)canvas, (int)(this.x + x + a), (int)(this.y + y * 16 + a), (int)(this.x + x + key.width() + a), (int)(this.y + y * 16 + 14 + a), (CanvasColor)color);
                        }
                    } else {
                        CanvasColor color2;
                        CanvasColor color;
                        boolean hover = ScreenElement.isIn(mouseX, mouseY, this.x + x, this.y + y * 16, this.x + x + key.width(), this.y + y * 16 + buttonCollisionHeight);
                        CanvasColor canvasColor = isHeld ? CanvasColor.WHITE_GRAY_LOW : (color = hover ? CanvasColor.WHITE_GRAY_NORMAL : CanvasColor.WHITE_GRAY_HIGH);
                        CanvasColor canvasColor3 = isHeld ? CanvasColor.GRAY_LOW : (color2 = hover ? CanvasColor.WHITE_GRAY_LOW : CanvasColor.WHITE_GRAY_LOW);
                        if (!isHeld) {
                            CanvasUtils.fill((DrawableCanvas)canvas, (int)(this.x + x), (int)(this.y + y * 16), (int)(this.x + x + key.width() + 1), (int)(this.y + y * 16 + 14 + 1), (CanvasColor)color2);
                        }
                        CanvasUtils.fill((DrawableCanvas)canvas, (int)(this.x + x + a), (int)(this.y + y * 16 + a), (int)(this.x + x + key.width() + a), (int)(this.y + y * 16 + 14 + a), (CanvasColor)color);
                    }
                    CharSequence[] lines = key.display.split("\n");
                    if (lines.length == 1) {
                        String line = lines[0];
                        int width = DefaultFonts.VANILLA.getTextWidth(line, 8.0);
                        DefaultFonts.VANILLA.drawText(canvas, line, this.x + x + (key.width() - width) / 2 + a, this.y + y * 16 + 4 + a, 8.0, CanvasColor.BLACK_HIGH);
                    } else {
                        String merged = String.join((CharSequence)"|", lines);
                        int offset = DefaultFonts.VANILLA.getTextWidth(merged, 8.0);
                        int widthChange = offset / (lines.length / 2);
                        int heightChange = 8 / lines.length + 1;
                        int startHeight = 4 / heightChange;
                        int startWidth = offset / 2;
                        for (int i = 0; i < lines.length; ++i) {
                            CharSequence line = lines[i];
                            int width = DefaultFonts.VANILLA.getTextWidth((String)line, 8.0);
                            DefaultFonts.VANILLA.drawText(canvas, (String)line, this.x + x + (key.width() - width + startWidth - widthChange * i) / 2 + a, this.y + y * 16 + i * heightChange + startHeight + 1 + a, 8.0, CanvasColor.BLACK_HIGH);
                        }
                    }
                }
                x += key.width() + 2;
            }
            ++y;
        }
    }

    @Override
    public void click(int x, int y, ScreenElement.ClickType type) {
        int height = KEYS.length;
        ServerInputStateExt inputExt = ServerInputStateExt.of(this.gui.input);
        for (int ly = 0; ly < height; ++ly) {
            int lys = ly * 16;
            if (lys > y || lys + 16 <= y) continue;
            int lxs = 0;
            for (Key key : KEYS[ly]) {
                if (lxs <= x && lxs + key.width() > x) {
                    int id = key.key();
                    if (inputExt.isKeyDown(id)) {
                        if (type == ScreenElement.ClickType.LEFT_DOWN) {
                            this.gui.input.keyUp(id);
                        }
                    } else {
                        char character;
                        this.gui.input.keyDown(id, type == ScreenElement.ClickType.RIGHT_DOWN);
                        boolean shift = inputExt.isKeyDown(340) || inputExt.isKeyDown(344);
                        char c = character = shift || inputExt.isKeyDown(280) ? key.upperCase() : key.lowerCase();
                        if (character >= ' ' && character <= '~' || character >= '\u00a0' && character <= '\u00ff') {
                            this.gui.input.queueEvent("char", new Object[]{Character.toString(character), false});
                        }
                        if (type == ScreenElement.ClickType.LEFT_DOWN) {
                            this.gui.keysToReleaseNextTick.add(key.key());
                        }
                    }
                    return;
                }
                lxs += key.width() + 2;
            }
            return;
        }
    }

    @Override
    public int width() {
        return KEYBOARD_WIDTH;
    }

    @Override
    public int height() {
        return KEYS.length * 18;
    }

    private static Key k(String display, int key, int width) {
        return new Key(display, key, width, (char)Character.toLowerCase(key), (char)Character.toUpperCase(key));
    }

    private static Key k(String display, int key) {
        return new Key(display, key, 20, (char)Character.toLowerCase(key), (char)Character.toUpperCase(key));
    }

    private static Key k(String display, int key, char lowerCase, char upperCase) {
        return new Key(display, key, 20, lowerCase, upperCase);
    }

    private static Key e() {
        return new Key("", -1, 20, '\u0000', '\u0000');
    }

    private static Key e(int width) {
        return new Key("", -1, width, '\u0000', '\u0000');
    }

    public record Key(String display, int key, int width, char lowerCase, char upperCase) {
    }
}

