/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly.render;

import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import eu.pb4.cctpatch.impl.poly.TerminalRenderer;
import eu.pb4.cctpatch.impl.poly.render.ScreenElement;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;

public final class TerminalView
extends ScreenElement {
    public final TerminalRenderer terminal;
    public final ServerInputHandler inputState;

    public TerminalView(int x, int y, TerminalRenderer terminal, ServerInputHandler inputState) {
        super(x, y);
        this.terminal = terminal;
        this.inputState = inputState;
    }

    @Override
    public void render(DrawableCanvas canvas, long tick, int mouseX, int mouseY) {
        CanvasUtils.draw((DrawableCanvas)canvas, (int)this.x, (int)this.y, (DrawableCanvas)this.terminal.getImage(tick));
    }

    @Override
    public int width() {
        return this.terminal.renderedWidth();
    }

    @Override
    public int height() {
        return this.terminal.renderedHeight();
    }

    @Override
    public void click(int x, int y, ScreenElement.ClickType type) {
        int lx = x / this.terminal.fontWidth() + 1;
        int ly = y / this.terminal.fontHeight() + 1;
        if (type == ScreenElement.ClickType.RIGHT_DOWN) {
            this.inputState.mouseClick(0, lx, ly);
        } else if (type == ScreenElement.ClickType.LEFT_DOWN) {
            this.inputState.mouseClick(1, lx, ly);
        }
    }
}

