/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly.render;

import eu.pb4.cctpatch.impl.poly.render.ScreenElement;
import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;

public class TextButton
extends ScreenElement {
    private final int height;
    private OnClick callback;
    private int clickTick = -1;
    public CanvasFont font;
    public int width;
    public int size;
    public String text;
    public CanvasColor color;

    public TextButton(int x, int y, int width, int height, String text, CanvasFont font, int size, CanvasColor color, OnClick callback) {
        super(x, y);
        this.height = height;
        this.width = width;
        this.font = font;
        this.size = size;
        this.text = text;
        this.color = color;
        this.callback = callback;
    }

    @Override
    public void render(DrawableCanvas canvas, long tick, int mouseX, int mouseY) {
        int a;
        CanvasColor color;
        boolean isHeld;
        boolean hover = ScreenElement.isIn(mouseX, mouseY, this.x, this.y, this.x + this.width, this.y + this.height);
        boolean bl = isHeld = (long)(this.clickTick + 10) > tick;
        CanvasColor canvasColor = isHeld ? CanvasColor.GRAY_HIGH : (color = hover ? CanvasColor.WHITE_GRAY_NORMAL : CanvasColor.WHITE_GRAY_HIGH);
        CanvasColor color2 = isHeld ? CanvasColor.GRAY_LOW : (hover ? CanvasColor.WHITE_GRAY_LOW : CanvasColor.WHITE_GRAY_LOW);
        int n = a = isHeld ? 1 : 0;
        if (!isHeld) {
            CanvasUtils.fill((DrawableCanvas)canvas, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (CanvasColor)color2);
        }
        CanvasUtils.fill((DrawableCanvas)canvas, (int)(this.x + a), (int)(this.y + a), (int)(this.x + this.width + a - 1), (int)(this.y + this.height + a - 1), (CanvasColor)color);
        this.font.drawText(canvas, this.text, this.x + (this.width - this.font.getTextWidth(this.text, (double)this.size)) / 2, this.y + (this.height - this.size) / 2, (double)this.size, this.color);
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public void click(int x, int y, ScreenElement.ClickType type) {
        this.callback.click(x, y, type);
    }

    public static interface OnClick {
        public void click(int var1, int var2, ScreenElement.ClickType var3);
    }
}

