/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.impl.poly.textures;

import eu.pb4.cctpatch.impl.poly.textures.ButtonTexture;
import eu.pb4.cctpatch.impl.poly.textures.ComputerTexture;
import eu.pb4.cctpatch.impl.poly.textures.PrintedPageTexture;
import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import java.awt.image.BufferedImage;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class GuiTextures {
    public static ButtonTexture CLOSE_ICON;
    public static ButtonTexture SHUTDOWN_ICON;
    public static ButtonTexture SHUTDOWN_ACTIVE;
    public static ButtonTexture TERMINATE;
    public static ComputerTexture ADVANCED_COMPUTER;
    public static ComputerTexture COMPUTER;
    public static ComputerTexture COMMAND_COMPUTER;
    public static PrintedPageTexture PRINTED_PAGE;

    private static ButtonTexture createButton(Path texturePath, String name) {
        return new ButtonTexture(GuiTextures.readTexture(texturePath.resolve(name + ".png")), GuiTextures.readTexture(texturePath.resolve(name + "_hover.png")));
    }

    private static CanvasImage readTexture(Path resolve) {
        try {
            return CanvasImage.from((BufferedImage)ImageIO.read(Files.newInputStream(resolve, new OpenOption[0])));
        }
        catch (Throwable e) {
            CanvasImage x = new CanvasImage(32, 32);
            CanvasUtils.clear((DrawableCanvas)x, (CanvasColor)CanvasColor.RED_HIGH);
            return x;
        }
    }

    static {
        Path texturePath = ((ModContainer)FabricLoader.getInstance().getModContainer("computercraft").get()).getPath("assets/computercraft/textures/gui/");
        Path selfPath = ((ModContainer)FabricLoader.getInstance().getModContainer("cc-tweaked-polymer-patch").get()).getPath("map/");
        SHUTDOWN_ICON = GuiTextures.createButton(texturePath, "buttons/turned_off");
        SHUTDOWN_ACTIVE = GuiTextures.createButton(texturePath, "buttons/turned_on");
        TERMINATE = GuiTextures.createButton(texturePath, "buttons/terminate");
        CLOSE_ICON = GuiTextures.createButton(selfPath, "close");
        ADVANCED_COMPUTER = ComputerTexture.from(GuiTextures.readTexture(texturePath.resolve("border_advanced.png")), GuiTextures.readTexture(texturePath.resolve("sidebar_advanced.png")));
        COMPUTER = ComputerTexture.from(GuiTextures.readTexture(texturePath.resolve("border_normal.png")), GuiTextures.readTexture(texturePath.resolve("sidebar_normal.png")));
        COMMAND_COMPUTER = ComputerTexture.from(GuiTextures.readTexture(texturePath.resolve("border_command.png")), GuiTextures.readTexture(texturePath.resolve("sidebar_command.png")));
        PRINTED_PAGE = PrintedPageTexture.from(GuiTextures.readTexture(texturePath.resolve("printout.png")));
    }
}

