/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.cctpatch.mixin.mod.block;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import eu.pb4.cctpatch.impl.poly.ext.ServerMonitorExt;
import eu.pb4.cctpatch.impl.poly.ext.TerminalExt;
import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.core.PlayerCanvas;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import eu.pb4.mapcanvas.api.utils.VirtualDisplay;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5536;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MonitorBlockEntity.class})
public abstract class MonitorBlockEntityMixin
extends class_2586 {
    @Shadow
    private int xIndex;
    @Shadow
    private int yIndex;
    @Shadow
    private int height;
    @Shadow
    private int width;
    @Unique
    private PlayerCanvas canvas = null;
    @Unique
    private VirtualDisplay display = null;
    @Unique
    private final Set<class_3222> currentWatchers = new HashSet<class_3222>();

    @Shadow
    public abstract int getHeight();

    @Shadow
    @Nullable
    protected abstract ServerMonitor getServerMonitor();

    @Shadow
    protected abstract void eachComputer(Consumer<IComputerAccess> var1);

    public MonitorBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(class_2591 type, class_2338 pos, class_2680 state, boolean advanced, CallbackInfo ci) {
        this.updateDisplaySize();
    }

    @Inject(method={"markRemoved"}, at={@At(value="TAIL")})
    private void onRemoved(CallbackInfo ci) {
        if (this.display != null) {
            this.display.destroy();
            this.canvas.destroy();
            this.currentWatchers.clear();
            this.display = null;
            this.canvas = null;
        }
    }

    @Inject(method={"readNbt"}, at={@At(value="TAIL")})
    private void onReadNbt(class_2487 nbt, class_7225.class_7874 registries, CallbackInfo ci) {
        if (this.field_11863 != null) {
            this.updateDisplaySize();
        }
    }

    @Inject(method={"blockTick"}, at={@At(value="TAIL")}, remap=false)
    private void onTick(CallbackInfo ci) {
        if ((this.xIndex != 0 || this.yIndex != 0) && this.display != null) {
            this.updateDisplaySize();
        } else {
            this.updateDisplay();
        }
        this.updateWatchers();
    }

    @Inject(method={"createServerMonitor"}, at={@At(value="RETURN")}, remap=false)
    private void onCreateServerMonitor(CallbackInfoReturnable<ServerMonitor> cir) {
        this.updateDisplaySize();
    }

    @Inject(method={"updateBlockState"}, at={@At(value="RETURN")}, remap=false)
    private void onUpdateBlockState(CallbackInfo ci) {
        this.updateDisplaySize();
    }

    @Unique
    private void updateDisplaySize() {
        if (this.display != null) {
            this.display.destroy();
            this.display = null;
        }
        if (this.canvas != null) {
            this.canvas.destroy();
            this.canvas = null;
        }
        this.currentWatchers.clear();
        if (this.xIndex == 0 && this.yIndex == 0) {
            class_2338 blockPos;
            class_2350 dir;
            int rotation;
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)MonitorBlock.FACING);
            class_2350 orientation = (class_2350)this.method_11010().method_11654((class_2769)MonitorBlock.ORIENTATION);
            if (orientation == class_2350.field_11043) {
                rotation = 0;
                dir = facing;
                blockPos = this.method_11016().method_10093(dir).method_10086(this.getHeight() - 1);
            } else {
                dir = orientation;
                rotation = facing.method_10161();
                blockPos = this.method_11016().method_10093(dir).method_10079(facing, orientation.method_10164() * (1 - this.height));
            }
            this.canvas = DrawableCanvas.create((int)this.width, (int)this.height);
            this.display = VirtualDisplay.builder((PlayerCanvas)this.canvas, (class_2338)blockPos, (class_2350)dir).rotation(class_2470.values()[rotation]).glowing(true).invisible().raycast().callback(this::onClick).build();
            this.updateDisplay();
        }
    }

    @Unique
    private void onClick(class_3222 player, class_5536 action, int x, int y) {
        ServerMonitor monitor = this.getServerMonitor();
        if (monitor != null && action == class_5536.field_27014) {
            x = (x - 20) / 6 / ServerMonitorExt.of(monitor).getTextScalePublic();
            y = (y - 21) / 9 / ServerMonitorExt.of(monitor).getTextScalePublic();
            if (x >= 0 && y >= 0 && x < monitor.getTerminal().getWidth() && y < monitor.getTerminal().getHeight()) {
                int finalX = x + 1;
                int finalY = y + 1;
                this.eachComputer(c -> c.queueEvent("monitor_touch", new Object[]{c.getAttachmentName(), finalX, finalY}));
            }
        }
    }

    @Unique
    private void updateDisplay() {
        if (this.xIndex != 0 && this.yIndex != 0) {
            if (this.canvas != null) {
                this.canvas.destroy();
            }
            if (this.display != null) {
                this.display.destroy();
            }
            return;
        }
        CanvasImage image = new CanvasImage(this.canvas.getWidth(), this.canvas.getHeight());
        ServerMonitor monitor = this.getServerMonitor();
        if (monitor != null && monitor.getTerminal() != null) {
            CanvasUtils.fill((DrawableCanvas)image, (int)16, (int)16, (int)(image.getWidth() - 16), (int)(image.getHeight() - 16), (CanvasColor)CanvasColor.BLACK_NORMAL);
            assert (this.field_11863 != null);
            DrawableCanvas screen = TerminalExt.of((Terminal)monitor.getTerminal()).getRenderer().getImage(this.field_11863.method_8510());
            int scale = ServerMonitorExt.of(monitor).getTextScalePublic();
            int sWidth = screen.getWidth() * scale;
            int sHeight = screen.getHeight() * scale;
            CanvasUtils.draw((DrawableCanvas)image, (int)20, (int)21, (int)sWidth, (int)sHeight, (DrawableCanvas)screen);
        } else {
            CanvasUtils.fill((DrawableCanvas)image, (int)20, (int)21, (int)(image.getWidth() - 20), (int)(image.getHeight() - 20), (CanvasColor)CanvasColor.BLACK_LOWEST);
        }
        CanvasUtils.draw((DrawableCanvas)this.canvas, (int)0, (int)0, (DrawableCanvas)image);
        this.updateWatchers();
    }

    @Unique
    public void updateWatchers() {
        if (this.field_11863 != null && this.display != null && this.canvas != null) {
            class_2338 pos = this.method_11016();
            List players = ((class_3218)this.field_11863).method_18766(p -> p.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) < 4096.0);
            for (class_3222 player : players) {
                if (this.currentWatchers.contains(player)) continue;
                this.canvas.addPlayer(player);
                this.display.addPlayer(player);
                this.currentWatchers.add(player);
            }
            for (class_3222 player : new ArrayList<class_3222>(this.currentWatchers)) {
                if (players.contains(player)) continue;
                this.display.removePlayer(player);
                this.canvas.removePlayer(player);
                this.currentWatchers.remove(player);
            }
            this.canvas.sendUpdates();
        }
    }
}

