# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [v21.0.28-1.21] - 2024-09-09
### Added
- Add `FabricMappingResolver`
### Changed
- Allow for preliminary compatibility with Minecraft 1.21.1 when enabled via Fabric's [Dependency Overrides](https://fabricmc.net/wiki/tutorial:dependency_overrides)
- Update mixin implementation for `AnimalTameCallback` and `ProjectileImpactCallback` on Fabric

## [v21.0.27-1.21] - 2024-09-06
### Added
- Experimental settings screens are now automatically skipped to avoid being shown for bundled data packs
### Fixed
- Fix `DynamicPackResources` providing an invalid pack when dynamic data generation fails

## [v21.0.26-1.21] - 2024-09-05
### Added
- Add `AbstractRegistriesDatapackGenerator`

## [v21.0.25-1.21] - 2024-09-04
### Changed
- Expand `ComputeLootingLevelCallback` as `ComputeEnchantedLootBonusCallback`
- Add new helper methods to `LookupHelper`
### Fixed
- Fix skipping validation option not always working in `AbstractLootProvider`

## [v21.0.24-1.21] - 2024-08-26
### Fixed
- Fix item model display overrides being able to compute before models have been reloaded on Fabric again

## [v21.0.23-1.21] - 2024-08-23
### Changed
- Enable accessing `HolderLookup$Provider` in `AbstractLootProvider` implementations
### Fixed
- Fix item model display overrides being able to compute before models have been reloaded on Fabric

## [v21.0.22-1.21] - 2024-08-14
### Fixed
- Fix `RegistryEntryAddedCallback` unable to find a mod event bus on NeoForge

## [v21.0.21-1.21] - 2024-08-14
### Added
- Add `BlockEntityHelper`
### Changed
- Allow `AbstractTagAppender` to accept `Holder$Reference` instances
- Update `RegistryEntryAddedCallback` to use NeoForge's `ModifyRegistriesEvent`
### Fixed
- Fix adding list elements via the built-in configuration screen

## [v21.0.20-1.21] - 2024-08-09
### Added
- Add `AddBlockEntityTypeBlocksCallback`
### Fixed
- Fix `ModelEvents` mixing up different block state models when baking on NeoForge
- Fix `ModelEvents` breaking when ModernFix's dynamic resources option is enabled

## [v21.0.19-1.21] - 2024-08-07
### Changed
- Disable config file watcher after too many reloads
### Fixed
- Fix enum values in configs causing the config to be reloaded indefinitely

## [v21.0.18-1.21] - 2024-07-26
### Added
- Add support for in-game configuration screens
### Changed
- Rework `AddDataPackReloadListenersCallback` to use Fabric Api's implementation

## [v21.0.17-1.21] - 2024-07-18
### Added
- Add `TooltipBuilder`
### Changed
- Compatible with NeoForge v21.0.102

## [v21.0.16-1.21] - 2024-07-15
### Changed
- Allow `TooltipComponent` to optionally not split tooltip lines
- Minor additions to `ClientComponentSplitter`

## [v21.0.15-1.21] - 2024-07-14
### Added
- Add `ItemHelper`

## [v21.0.14-1.21] - 2024-07-14
### Added
- Add custom `/config` command format for development
### Fixed
- Fix camera z-rotation from `ComputeCameraAnglesCallback` on Fabric
- Fix loot tables and advancements data generation output paths

## [v21.0.13-1.21] - 2024-07-12
### Fixed
- Fix crash on NeoForge v21.0.82 by updating config system internals
- Fix `BlockConversionHelper` failing to copy tags client-side
- Fix `TooltipRenderHelper` drawing tooltip contents above the screen layer

## [v21.0.12-1.21] - 2024-07-09
### Added
- Add `NbtSerializableCodec`
- Add `LookupHelper`
### Changed
- Some adjustments for data-driven enchantments
- Provide `HolderLookup.Provider` to `NbtSerializable`

## [v21.0.11-1.21] - 2024-07-08
### Added
- Add `RegistryFactory`
### Fixed
- Fix `FinalizeItemComponentsCallback` and `ComputeItemAttributeModifiersCallback` not being called on Fabric due to registering too late

## [v21.0.10-1.21] - 2024-07-08
### Added
- Add `GatherEffectScreenTooltipCallback`
- Add `AddDataPackReloadListenersCallback` for replacing `ModConstructor::onRegisterDataPackReloadListeners`
- Add `AddResourcePackReloadListenersCallback` for replacing `ClientModConstructor::onRegisterResourcePackReloadListeners`
### Changed
- Call `LoadCompleteCallback` much earlier on clients
### Fixed
- Fix `FinalizeItemComponentsCallback` and `ComputeItemAttributeModifiersCallback` not being called on NeoForge due to registering too late

## [v21.0.9-1.21] - 2024-07-07
### Added
- Add `TooltipComponent`
### Changed
- Update to NeoForge v21.0.75

## [v21.0.8-1.21] - 2024-07-07
### Fixed
- Fix `ModelEvents.ModifyUnbakedModel` providing an incorrect model lookup

## [v21.0.7-1.21] - 2024-07-07
### Changed
- Rename `ContainerImpl` to `ListBackedContainer`

## [v21.0.6-1.21] - 2024-07-06
### Changed
- Rename `ContainerHelper` to `ContainerItemHelper`

## [v21.0.5-1.21] - 2024-07-06
### Added
- Add `ContainerHelper`
### Fixed
- Fix `FOV Effects` accessibility setting being broken on Fabric
- Fix `ContainerSerializationHelper::createTag` failing to store the actual item

## [v21.0.4-1.21] - 2024-07-06
### Fixed
- Fix `AbstractLootProvider` generating an empty loot table
- Fix item lookup failing in `AbstractRecipeProvider`
- Fix `ClassCastException` when sending `MessageV2`

## [v21.0.3-1.21] - 2024-07-06
### Added
- Add `SearchRegistryHelper`

## [v21.0.2-1.21] - 2024-07-05
### Changed
- Revert common publication namespace change
- Some additions for `ExtraStreamCodecs`
### Removed
- Remove `MessageSerializer` in favor of `StreamCodec`

## [v21.0.1-1.21] - 2024-07-05
### Changed
- Switch common publication namespace to intermediary

## [v21.0.0-1.21] - 2024-07-04
- Port to Minecraft 1.21
- Forge is no longer support in favor of NeoForge
### Added
- Add `FinalizeItemComponentsCallback`
- Add `ResourceLocationHelper`
- Add `EntityTickEvents` in favor of `LivingTickCallback`
- Add `RegisterPotionBrewingMixesCallback` in favor of `PotionBrewingRegistry`
### Changed
- Overhaul `RenderGuiLayerEvents` ids
- Expand `ScreenTooltipFactory` to allow for directly setting the tooltip on a widget
- Migrate `ItemAttributeModifiersCallback` to `ComputeItemAttributeModifiersCallback`
- Migrate `ArmorMaterial` helpers from `ItemEquipmentFactories` to `RegistryManager`
- Migrate `CopyTagRecipe` to `CopyComponentsRecipe`
### Removed
- Remove old `ScreenHelper` in favor of access widener
- Remove `NetworkHandlerV2`, `MessageV2` is now compatible with `MessageV3` and can therefore be registered via `NetworkHandlerV2`
- Remove remaining Cardinal Components classes
