//Reloading the recipes

ServerEvents.loaded((event) => {
  event.server.runCommandSilent("reload");
});

// on join ->
PlayerEvents.loggedIn((event) => {
  const { player, server } = event;
  // Check if player doesn't have "first_time" stage yet
  if (!player.stages.has("first_time")) {
    // Add the stage
    player.teleportTo("universutil:universe", 0, 100, 0, 0, 0);
    server.runCommandSilent(`execute as ${player.name.string} run rtp`);
    server.runCommandSilent(`respawn dimension universutil:universe`);
    server.runCommandSilent(
      `execute as ${player.name.string} at @s run spawnpoint @s ~ ~ ~`
    );
    server.runCommandSilent(
      `thitemstages add ${event.player.name.string} universe`
    );
    player.give("ftbquests:book");
    player.stages.add("first_time");
    server.runCommandSilent("gamerule sendCommandFeedback false");
  }
});

// on quest complete
FTBQuestsEvents.completed((event) => {
  // Check if the player completed a quest with the "celebrate" tag and summon fire works so celebrate :D
  event.onlineMembers.runCommandSilent(`title @s times 20 20 20`);
  event.onlineMembers.playSound("entity.player.levelup", 0.24, 1);
  event.onlineMembers.runCommandSilent(
    `title @s actionbar "§aQuest Complete!§r"`
  );
});
