priority: 666;

ServerEvents.recipes((event) => {
  function transmute(input, output, reagents, min, cost) {
    event.custom({
      type: "reactive:transmutation",
      reactant: {
        item: input,
      },
      product: {
        item: output,
      },
      reagents: reagents,
      min: min,
      cost: cost,
    });
  }

  // silicon dust from silicon
  event
    .custom({
      type: "alchemistry:compactor",
      group: "alchemistry:compactor",
      input: {
        count: 16,
        ingredient: {
          item: "chemlib:silicon",
        },
      },
      result: {
        item: "chemlib:silicon_dust",
      },
    })
    .id("universio:alchemistry/compactor/silicon_dust");

  // cosmic dust dissolving
  event
    .custom({
      type: "alchemistry:dissolver",
      group: "alchemistry:dissolver",
      input: {
        count: 1,
        ingredient: {
          item: "universutil:cosmic_dust",
        },
      },
      output: {
        groups: [
          {
            probability: 2.0,
            results: [
              {
                item: "chemlib:carbon",
              },
            ],
          },
          {
            probability: 2.0,
            results: [
              {
                item: "chemlib:nitrogen",
              },
            ],
          },
          {
            probability: 2.0,
            results: [
              {
                item: "chemlib:platinum",
              },
            ],
          },
          {
            probability: 2.0,
            results: [
              {
                item: "chemlib:gold",
              },
            ],
          },
          {
            probability: 2.0,
            results: [
              {
                item: "chemlib:lead",
              },
            ],
          },
          {
            probability: 2.0,
            results: [
              {
                item: "chemlib:copper",
              },
            ],
          },
          {
            probability: 2.0,
            results: [
              {
                item: "chemlib:iron",
              },
            ],
          },
          {
            probability: 2.0,
            results: [
              {
                item: "chemlib:osmium",
              },
            ],
          },
          {
            probability: 2.0,
            results: [
              {
                item: "chemlib:sulfur",
              },
            ],
          },
          {
            probability: 2.0,
            results: [
              {
                item: "chemlib:silicon",
              },
            ],
          },
        ],
        rolls: 2,
        weighted: true,
      },
    })
    .id("universio:alchemistry/dissolver/cosmic_dust");

  // netherite scraps
  event
    .custom({
      type: "alchemistry:combiner",
      group: "alchemistry:combiner",
      input: [
        {
          count: 16,
          ingredient: {
            item: "chemlib:tungsten",
          },
        },
        {
          count: 16,
          ingredient: {
            item: "chemlib:carbon",
          },
        },
      ],
      result: {
        item: "minecraft:netherite_scrap",
      },
    })
    .id("universio:alchemistry/combiner/netherite_scrap");

  // add reactive recipes
  transmute(
    "chemlib:oxygen",
    "cloudstorage:cloud",
    ["reactive:vital"],
    110,
    10
  );
  transmute(
    "botania:red_petal",
    "cloudstorage:balloon_bit",
    ["reactive:caustic"],
    110,
    10
  );

  transmute(
    "chemlib:iron",
    "pneumaticcraft:ingot_iron_compressed",
    ["reactive:caustic"],
    110,
    10
  );
  transmute(
    "minecraft:smooth_stone",
    "pneumaticcraft:compressed_stone",
    ["reactive:caustic"],
    110,
    10
  );
});
