priority: 888;

ServerEvents.recipes((event) => {
  // remove recipes here
  raw_materials.forEach((material) => {
    //smelting - blasting
    event.remove({
      type: "blasting",
      input: `#forge:raw_materials/${material}`,
    });
    event.remove({
      type: "smelting",
      input: `#forge:raw_materials/${material}`,
    });
    event.remove({ type: "smelting", input: `#forge:ores/${material}` });
    event.remove({ type: "blasting", input: `#forge:ores/${material}` });
  });

  ingots.forEach((ingot) => {
    event.remove({ type: "blasting", input: `#forge:dusts/${ingot}` });
  });

  //event.replaceInput({ output: "" }, "minecraft:furnace", "pneumaticcraft:compressed_stone")
  event.replaceInput(
    { output: "minecraft:furnace" },
    "#minecraft:stone_tool_materials",
    "pneumaticcraft:compressed_stone"
  );
  event.replaceInput(
    { output: "pneumaticcraft:vortex_tube" },
    "minecraft:gold_ingot",
    "chemlib:aluminum_ingot"
  );
  event.replaceInput(
    { output: "pneumaticcraft:refinery_output" },
    "minecraft:diamond",
    "universutil:cosmic_ingot"
  );

  // change peripheral casing recipe
  event.replaceInput(
    { output: "advancedperipherals:peripheral_casing" },
    "minecraft:iron_ingot",
    "botania:terrasteel_ingot"
  );
  event.replaceInput(
    { output: "advancedperipherals:peripheral_casing" },
    "minecraft:iron_bars",
    "fluxnetworks:flux_dust"
  );
  event.replaceInput(
    { output: "advancedperipherals:peripheral_casing" },
    "minecraft:redstone_block",
    "#pneumaticcraft:compressed_stone"
  );

  // change temporal pouch recipe
  event.replaceInput(
    { output: "gag:time_sand_pouch" },
    "minecraft:raw_gold_block",
    "minecraft:gold_block"
  );
  event.replaceInput(
    { output: "gag:time_sand_pouch" },
    "minecraft:nautilus_shell",
    "universutil:cosmic_dust"
  );
  event.replaceInput(
    { output: "gag:time_sand_pouch" },
    "minecraft:ender_eye",
    "universutil:cosmic_dust_block"
  );

  // change computer recipe
  event.replaceInput(
    { output: "computercraft:computer_normal" },
    "#balm:stones",
    "#pneumaticcraft:compressed_stone"
  );
  event.replaceInput(
    { output: "computercraft:computer_normal" },
    "minecraft:redstone",
    "refinedstorage:machine_casing"
  );
  event.replaceInput(
    { output: "computercraft:computer_normal" },
    "#forge:glass_panes",
    "minecraft:redstone"
  );

  // remove recipes
  event.remove({ id: "projecte:conversions/diamond_to_emerald" });
  event.remove({ id: "projecte:conversions/diamond_to_gold_ingot" });
  event.remove({ id: "projecte:conversions/emerald_to_diamond" });
  event.remove({ id: "projecte:conversions/iron_ingot_to_ender_pearl" });
  event.remove({ id: "projecte:conversions/iron_ingot_to_gold_ingot" });
  event.remove({ id: "projecte:conversions/coal_to_charcoal" });
  event.remove({ id: "projecte:conversions/gold_ingot_to_diamond" });
  event.remove({ id: "projecte:conversions/gold_ingot_to_iron_ingot" });
  event.remove({ id: "projecte:conversions/charcoal_to_coal" });
  event.remove({ id: "projecte:conversions/coal_to_charcoal" });

  event.remove({ output: "gag:escape_rope" });
  event.remove({ output: "reactive:scroll" });
  event.remove({ output: "fluxnetworks:flux_dust" });
  event.remove({ output: "botania:mana_spreader" });
  event.remove({ output: "botania:mana_powder" });
  event.remove({ output: "#forge:ingots/compressed_iron" });
  event.remove({ output: "pneumaticcraft:assembly_program_drill_laser" });
  event.remove({ id: "reactive:dissolve/iron_from_manasteel" });
  event.remove({ id: "computercraft:computer_advanced" });
  event.remove({ id: "pneumaticcraft:pressure_chamber/coal_to_diamond" });
  event.remove({ id: "alchemistry:compactor" });
  event.remove({ id: "alchemistry:dissolver" });
  event.remove({ id: "alchemistry:combiner" });
  event.remove({ id: "pneumaticcraft:thermo_plant/plastic_from_biodiesel" });
  event.remove({ id: "projecte:low_covalence_dust" });
  event.remove({ id: "projecte:medium_covalence_dust" });
  event.remove({ id: "projecte:high_covalence_dust" });
  event.remove({ type: "pneumaticcraft:amadron" });

  event.replaceInput(
    { output: "alchemistry:fusion_chamber_controller" },
    "minecraft:nether_star",
    "universutil:star_block"
  );

  event.replaceInput(
    { output: "alchemistry:fusion_chamber_controller" },
    "minecraft:iron_ingot",
    "minecraft:netherite_ingot"
  );

  event.replaceInput(
    { output: "alchemistry:fission_chamber_controller" },
    "minecraft:iron_ingot",
    "minecraft:netherite_ingot"
  );

  event.replaceInput(
    { output: "alchemistry:fission_chamber_controller" },
    "minecraft:glowstone_dust",
    "universutil:cosmic_dust"
  );

  event.replaceInput(
    { type: "botania:runic_altar" },
    "botania:mana_diamond",
    "botania:terrasteel_ingot"
  );

  event.replaceInput(
    { id: "clickmachine:auto_clicker" },
    "minecraft:diorite",
    "botania:livingrock"
  );

  event.replaceInput(
    { id: "clickmachine:auto_clicker" },
    "minecraft:chorus_flower",
    "universutil:cosmic_ingot"
  );

  event.replaceInput(
    { id: "clickmachine:auto_clicker" },
    "minecrtaft:diorite",
    "botania:livingrock"
  );

  //replace inputs / ore dict attempts
  // BrickHopper: brick hopper
  event.replaceInput(
    { output: "brickhopper:brick_hopper" },
    "#forge:chests/wooden",
    "woodenhopper:wooden_hopper"
  );

  event.replaceInput(
    { output: "botanypots:terracotta_hopper_botany_pot" },
    "minecraft:hopper",
    "#universio:hoppers"
  );

  event.replaceInput(
    { mod: "projecte" },
    "#balm:stones",
    "biggerreactors:graphite_block"
  );
  event.replaceInput(
    { mod: "projecte" },
    "#balm:wooden_chests",
    "minecraft:chest"
  );

  event.replaceInput(
    { mod: "prettypipes" },
    "minecraft:quartz",
    "pneumaticcraft:ingot_iron_compressed"
  );

  event.replaceInput(
    { mod: "prettypipes" },
    "minecraft:diamond",
    "universutil:cosmic_ingot"
  );

  event.replaceInput(
    { output: "pneumaticcraft:gps_tool" },
    "minecraft:diamond",
    "universutil:cosmic_ingot"
  );

  event.replaceInput(
    { output: "projectexpansion:final_star" },
    "minecraft:dragon_egg",
    "witherstormmod:withered_nether_star"
  );

  // add recipes here
  event.shapeless("chemlib:hydrogen", ["universutil:atom"]);

  event.shapeless("4x minecraft:clay_ball", ["minecraft:clay"]);

  event
    .shapeless("minecraft:coal", [
      "projecte:philosophers_stone",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
    ])
    .replaceIngredient(
      "projecte:philosophers_stone",
      "projecte:philosophers_stone"
    );

  event
    .shapeless("24x projecte:low_covalence_dust", [
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:silicon_dioxide",
      "chemlib:silicon_dioxide",
      "chemlib:silicon_dioxide",
      "chemlib:silicon_dioxide",
    ])
    .id("universio:crafting/low_dust");

  event
    .shapeless("43x projecte:medium_covalence_dust", [
      "chemlib:strontium_carbonate",
      "chemlib:strontium_carbonate",
      "chemlib:strontium_carbonate",
      "chemlib:strontium_carbonate",
      "chemlib:iron_oxide",
      "chemlib:iron_oxide",
      "chemlib:iron_oxide",
      "chemlib:iron_oxide",
      "chemlib:iron",
    ])
    .id("universio:crafting/mid_dust");

  event
    .shapeless("60x projecte:high_covalence_dust", [
      "minecraft:diamond",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
      "chemlib:carbon",
    ])
    .id("universio:crafting/high_dust");

  event
    .shapeless("chemlib:helium", [
      "projecte:philosophers_stone",
      "chemlib:hydrogen",
      "chemlib:hydrogen",
    ])
    .replaceIngredient(
      "projecte:philosophers_stone",
      "projecte:philosophers_stone"
    );

  event
    .shapeless("chemlib:lithium", [
      "projecte:philosophers_stone",
      "chemlib:hydrogen",
      "chemlib:helium",
    ])
    .replaceIngredient(
      "projecte:philosophers_stone",
      "projecte:philosophers_stone"
    );

  event
    .shapeless("chemlib:beryllium", [
      "projecte:philosophers_stone",
      "chemlib:helium",
      "chemlib:helium",
    ])
    .replaceIngredient(
      "projecte:philosophers_stone",
      "projecte:philosophers_stone"
    );

  event
    .shapeless("chemlib:beryllium", [
      "projecte:philosophers_stone",
      "chemlib:lithium",
      "chemlib:hydrogen",
    ])
    .replaceIngredient(
      "projecte:philosophers_stone",
      "projecte:philosophers_stone"
    );

  event
    .shapeless("chemlib:boron", [
      "projecte:philosophers_stone",
      "chemlib:lithium",
      "chemlib:helium",
    ])
    .replaceIngredient(
      "projecte:philosophers_stone",
      "projecte:philosophers_stone"
    );

  event
    .shapeless("chemlib:boron", [
      "projecte:philosophers_stone",
      "chemlib:beryllium",
      "chemlib:hydrogen",
    ])
    .replaceIngredient(
      "projecte:philosophers_stone",
      "projecte:philosophers_stone"
    );

  event
    .shaped("universutil:gravity", ["A B", " P ", " C "], {
      A: "chemlib:lithium",
      B: "chemlib:beryllium",
      C: "chemlib:boron",
      P: "projecte:philosophers_stone",
    })
    .replaceIngredient(
      "projecte:philosophers_stone",
      "projecte:philosophers_stone"
    );

  event
    .shaped("universutil:star", [" A ", "BGB", " A "], {
      A: "chemlib:hydrogen",
      B: "chemlib:helium",
      G: "universutil:gravity",
    })
    .replaceIngredient("universutil:gravity", "universutil:gravity");

  event
    .shaped("universutil:earth", ["ABC", "DXE", "FGH"], {
      A: "chemlib:iron",
      B: "chemlib:oxygen",
      C: "chemlib:silicon",
      D: "chemlib:magnesium",
      E: "chemlib:sulfur",
      F: "chemlib:zinc",
      G: "chemlib:calcium",
      H: "chemlib:aluminum",
      X: "universutil:gravity",
    })
    .replaceIngredient("universutil:gravity", "universutil:gravity")
    .id("universio:crafting/earth");

  event
    .shaped("minecraft:sugar_cane", ["AAA", "AAA"], { A: "#minecraft:leaves" })
    .id("universio:crafting/sugar_cane_from_leaves");

  event
    .shaped("minecraft:cauldron", ["F F", "FMF", "FFF"], {
      F: "chemlib:iron",
      M: "botania:mana_pool",
    })
    .id("universio:crafting/cauldron");

  event
    .shapeless("chemlib:water", [
      "projecte:philosophers_stone",
      "chemlib:hydrogen",
      "chemlib:hydrogen",
      "chemlib:oxygen",
    ])
    .id("universio:crafting/water")
    .replaceIngredient(
      "projecte:philosophers_stone",
      "projecte:philosophers_stone"
    );

  event
    .shapeless(
      Item.of(
        "woodenbucket:wooden_bucket",
        '{Damage:0,Fluid:{Amount:1000,FluidName:"minecraft:water"}}'
      ),
      ["chemlib:water", "woodenbucket:wooden_bucket"]
    )
    .id("universio:crafting/water_bucket");

  event
    .shaped("minecraft:bucket", ["F F", "FBF", " F "], {
      F: "chemlib:iron",
      B: "woodenbucket:wooden_bucket",
    })
    .id("universio:crafting/iron_bucket_from_wooden_bucket");

  event
    .shaped("minecraft:cake", ["MMM", "TPC", "SSS"], {
      M: "chemlib:calcium",
      T: "chemlib:starch",
      P: "chemlib:protein",
      C: "chemlib:cellulose",
      S: "chemlib:sucrose",
    })
    .id("universio:crafting/chemical_cake");

  event
    .shaped("refinedstorage:machine_casing", ["INI", "NCN", "INI"], {
      I: "refinedstorage:quartz_enriched_iron",
      N: "minecraft:nether_brick",
      C: "advancedperipherals:peripheral_casing",
    })
    .id("refinedstorage:machine_casing");

  event
    .shapeless(
      Item.of(
        "patchouli:guide_book",
        '{"patchouli:book":"patchouli:universutil"}'
      ),
      ["chemlib:hydrogen"]
    )
    .id("universio:crafting/guide_book");

  event
    .shapeless("2x minecraft:slime_ball", [
      "farmersdelight:wheat_dough",
      "#forge:dyes/lime",
    ])
    .id("universio:crafting/slime_ball");

  event
    .shaped("minecraft:command_block", ["AAA", "ADA", "AAA"], {
      A: "universutil:dolor_stone",
      D: "minecraft:dragon_egg",
    })
    .id("universio:crafting/command_block");

  event.recipes.minecraft.campfire_cooking("minecraft:glass", "#forge:sand");
  event.recipes.minecraft.campfire_cooking(
    "universutil:cosmic_ingot",
    "universutil:cosmic_dust"
  );
  event.recipes.minecraft.campfire_cooking(
    "minecraft:charcoal",
    "#minecraft:logs"
  );
  event.recipes.minecraft.campfire_cooking(
    "minecraft:brick",
    "minecraft:clay_ball"
  );
  event.recipes.minecraft.campfire_cooking(
    "ceramicshears:ceramic_shears_part",
    "ceramicshears:clay_shears_part"
  );

  event.recipes.minecraft.stonecutting(
    "minecraft:budding_amethyst",
    "amethyst_block"
  );

  event
    .shaped("minecraft:spawner", ["III", "ISI", "ICI"], {
      I: "minecraft:iron_bars",
      C: "pneumaticcraft:compressed_iron_block",
      S: "universutil:cosmic_ingot",
    })
    .id("universio:crafting/spwaner");

  event.shaped("witherstormmod:command_block_book", [
    "FBF",
    "BCB",
    "FBF"
  ],
  {
    F: "projectexpansion:fading_matter",
    B: "minecraft:book",
    C: "minecraft:command_block"
  })

  event.shaped("witherstormmod:withered_nether_star", [
    " B ",
    "SNF",
    " E "
  ],
  {
    F: "witherstormmod:formidibomb",
    B: "witherstormmod:command_block_book",
    S: "witherstormmod:command_block_sword",
    E: "projectexpansion:final_star_shard",
    N: "minecraft:nether_star"
  })

  event
    .smelting("minecraft:amethyst_shard", "hexcasting:amethyst_dust")
    .xp(7)
    .id("universio:smelting/amethyst_shard");

  event
    .blasting("2x refinedstorage:silicon", "chemlib:silicon_dust")
    .xp(7)
    .id("refinedstorage:silicon");
});
