ServerEvents.recipes(event => {

    let item = "ITEM";
    //let fluid = "FLUID";

    function amadron(input, input_type, input_count, output, output_type, output_count, id) {
        event.custom({
            "type": "pneumaticcraft:amadron",
            "id": id,
            "input": {
                "type": input_type,
                "amount": input_count,
                "id": input
            },
            "level": 0,
            "output": {
                "type": output_type,
                "amount": output_count,
                "id": output
            },
            "static": true
        })
    }

    function assemble(input, input_count, output, output_count, program, id) {
        event.custom({
            "type": "pneumaticcraft:assembly_laser",
            "input": {
                "type": "pneumaticcraft:stacked_item",
                "count": input_count,
                "item": input
            },
            "program": program,
            "result": {
                "count": output_count,
                "item": output
            }
        }).id(id)
    }

    function compress(input, input_count, output, output_count, pressure) {
        event.custom({
            "type": "pneumaticcraft:pressure_chamber",
            "inputs": [
                {
                    "type": "pneumaticcraft:stacked_item",
                    "count": input_count,
                    item: input
                }
            ],
            "pressure": pressure,
            "results": [
                {
                    item: output,
                    "count": output_count
                }
            ]
        })
    }


    // elements 2 dusts
    compress("chemlib:iron", 16, "chemlib:iron_dust", 1, 2.0)
    compress("chemlib:copper", 16, "chemlib:copper_dust", 1, 2.0)
    compress("chemlib:gold", 16, "chemlib:gold_dust", 1, 2.0)

    compress("minecraft:charcoal", 1, "minecraft:coal", 1, 1.5)
    compress("minecraft:charcoal", 9, "minecraft:coal_block", 1, 1.5)

    // etching acid recipe
    event.custom({
        "type": "pneumaticcraft:pressure_chamber",
        "inputs": [
            {
                "item": "minecraft:water_bucket"
            },
            {
                "item": "chemlib:iron"
            },
            {
                "item": "chemlib:hydrogen"
            },
            {
                "item": "chemlib:nitrogen"
            },
            {
                "type": "pneumaticcraft:stacked_item",
                "count": 3,
                "item": "chemlib:chlorine"
            },
            {
                "type": "pneumaticcraft:stacked_item",
                "count": 3,
                "item": "chemlib:oxygen"
            }
        ],
        "pressure": 1.7,
        "results": [
            {
                "item": "pneumaticcraft:etching_acid_bucket"
            }
        ]
    })

    // add amadron trades
    amadron("numismaticoverhaul:silver_coin", item, 49, "pneumaticcraft:assembly_program_drill", item, 1, "universio:pncr/amadron/prog_drill")
    amadron("numismaticoverhaul:silver_coin", item, 49, "pneumaticcraft:assembly_program_laser", item, 1, "universio:pncr/amadron/prog_laser")
    amadron("numismaticoverhaul:gold_coin", item, 1, "pneumaticcraft:assembly_program_drill_laser", item, 1, "universio:pncr/amadron/prog_drill_laser")

    // add custom recipes using assembly
    assemble("minecraft:redstone", 8, "fluxnetworks:flux_dust", 2, "laser", "universio:pncr/assembly/redstone_to_flux_dust")

    // block heat property
    event.custom({
        "type": "pneumaticcraft:heat_properties",
        "block": "universutil:star_block",
        "temperature": 820,
        "heatCapacity": 13500,
        "transformCold": {
            "block": "minecraft:obsidian"
        }
    })

    event.custom({
        "type": "pneumaticcraft:heat_properties",
        "block": "universutil:everythingness",
        "temperature": 170,
        "thermalResistance": 200,
        "heatCapacity": 20000,
        "transformHot": {
            "block": "minecraft:air"
        }
    }
    )

})