priority: 999;

ServerEvents.tags("item", (event) => {
  function addChiselTag(name) {
    event.add(`rechiseled:${name}_blocks`, [
      `rechiseled:${name}_diagonal_tiles`,
      `rechiseled:${name}_diagonal_tiles_connecting`,
      `rechiseled:${name}_flooring`,
      `rechiseled:${name}_large_tiles`,
      `rechiseled:${name}_pattern_connecting`,
      `rechiseled:${name}_small_bricks`,
      `rechiseled:${name}_small_tiles_connecting`,
      `rechiseled:${name}_tiles_connecting`,
      `rechiseled:${name}_woven_connecting`,
      `rechiseled:${name}_woven`,
      `rechiseled:${name}_crate`,
      `rechiseled:${name}_dotted_connecting`,
      `rechiseled:${name}_pattern`,
      `rechiseled:${name}_beams_connecting`,
      `rechiseled:${name}_small_bricks_connecting`,
      `rechiseled:${name}_dotted`,
      `rechiseled:${name}_wavy`,
      `rechiseled:${name}_wavy_connecting`,
      `rechiseled:${name}_diagonal_stripes_connecting`,
      `rechiseled:${name}_diagonal_stripes`,
      `rechiseled:${name}_crate_connecting`,
      `rechiseled:${name}_bricks_connecting`,
      `rechiseled:${name}_squares_connecting`,
      `rechiseled:${name}_flooring_connecting`,
      `rechiseled:${name}_bricks`,
      `rechiseled:${name}_beams`,
      `rechiseled:${name}_large_tiles_connecting`,
      `rechiseled:${name}_small_tiles`,
      `rechiseled:${name}_large_tiles_connecting`,
      `rechiseled:${name}_squares`,
      `rechiseled:${name}_squares_connecting`,
      `rechiseled:${name}_tiles`,
      `rechiseled:${name}_tiles_connecting`,
    ]);
  }

  let woodTypes = [
    "spruce_planks",
    "warped_planks",
    "oak_planks",
    "jungle_planks",
    "dark_oak_planks",
    "crimson_planks",
    "birch_planks",
    "acacia_planks",
  ];

  woodTypes.forEach((wood) => {
    addChiselTag(wood);
  });

  event.add("universio:dev_tools", [
    "@itemfilters",
    "@ftbquests",
    "@questsadditions",
    "@plonk",
    "@vm",
    "@citadel",
    "@zerocore",
  ]);
  event.add("universio:corail_tombstone", ["@tombstone"]);

  event.add("universio:pncr/programs", [
    "pneumaticcraft:assembly_program_drill",
    "pneumaticcraft:assembly_program_laser",
    "pneumaticcraft:assembly_program_drill_laser",
  ]);

  event.add("forge:coals", ["#minecraft:coals"]);

  event.add("ftbultimine:tools", [
    "#witherstormmod:command_block_tools",
    "#forge:tools/pickaxes",
    "#forge:tools/axes",
    "#forge:tools/knives",
    "#forge:tools/hammers",
    "#forge:tools/katars",
    "#forge:tools/morning_star",
    "#forge:tools/shovel",
    "#forge:tools/hoes",
    "#forge:shears",
  ]);

  event.add("universio:stripped_logs", [
    "minecraft:stripped_oak_log",
    "minecraft:stripped_spruce_log",
    "minecraft:stripped_birch_log",
    "minecraft:stripped_jungle_log",
    "minecraft:stripped_acacia_log",
    "minecraft:stripped_dark_oak_log",
    "minecraft:stripped_mangrove_log",
  ]);

  event.add("universio:hoppers", [
    "minecraft:hopper",
    "brickhopper:brick_hopper",
  ]);

  event.add("universio:projecte", ["@projecte", "@projectexpansion"]);

  event.add("forge:dusts", [
    "universutil:cosmic_dust",
    "fluxnetworks:flux_dust",
    "projecte:low_covalence_dust",
    "projecte:medium_covalence_dust",
    "projecte:high_covalence_dust",
    "hexcasting:amethyst_dust",
  ]);

  event.add("forge:dusts/cosmic", ["universutil:cosmic_dust"]);
  event.add("forge:dusts/brass", ["squirtgun:brass_blend"]);
  event.add("forge:dusts/salt", ["chemlib:sodium_chloride_dust"]);

  event.add("universio:to_hide", [
    "gag:escape_rope",
    "gag:energized_hearthstone",
    "aiotbotania:livingwood_shears",
    "aiotbotania:livingrock_shears",
  ]);

  event.add("reactive:body_sources", ["chemlib:oxygen"]);
  event.add("reactive:caustic_sources", ["chemlib:phosphorus"]);
  event.add("reactive:curse_sources", ["chemlib:argon"]);
  event.add("reactive:light_sources", ["chemlib:neon"]);
  event.add("reactive:mind_sources", ["chemlib:nitrogen"]);
  event.add("reactive:soul_sources", ["chemlib:chromium"]);
  event.add("reactive:warp_sources", ["chemlib:strontium"]);
});
